/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.ThreadSetupAction;
import io.undertow.servlet.core.CompositeThreadSetupAction;
import io.undertow.servlet.core.ContextClassLoaderSetupAction;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.websockets.jsr.JsrWebSocketFilter;
import io.undertow.websockets.jsr.ServerWebSocketContainer;
import io.undertow.websockets.jsr.WebSocketDeploymentInfo;
import java.util.ArrayList;
import javax.servlet.DispatcherType;
import javax.websocket.DeploymentException;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpointConfig;

public class Bootstrap
implements ServletExtension {
    public static final String FILTER_NAME = "Undertow Web Socket Filter";

    public void handleDeployment(DeploymentInfo deploymentInfo, ServletContextImpl servletContext) {
        WebSocketDeploymentInfo info = (WebSocketDeploymentInfo)deploymentInfo.getServletContextAttributes().get("io.undertow.websockets.jsr.WebSocketDeploymentInfo");
        if (info == null) {
            return;
        }
        ArrayList<ContextClassLoaderSetupAction> setup = new ArrayList<ContextClassLoaderSetupAction>();
        setup.add(new ContextClassLoaderSetupAction(deploymentInfo.getClassLoader()));
        setup.addAll(deploymentInfo.getThreadSetupActions());
        CompositeThreadSetupAction threadSetupAction = new CompositeThreadSetupAction(setup);
        ServerWebSocketContainer container = new ServerWebSocketContainer(deploymentInfo.getClassIntrospecter(), info.getWorker(), info.getBuffers(), (ThreadSetupAction)threadSetupAction);
        try {
            for (Class<?> annotation : info.getAnnotatedEndpoints()) {
                container.addEndpoint(annotation);
            }
            for (ServerEndpointConfig programatic : info.getProgramaticEndpoints()) {
                container.addEndpoint(programatic);
            }
        }
        catch (DeploymentException e) {
            throw new RuntimeException(e);
        }
        deploymentInfo.addFilter(Servlets.filter((String)FILTER_NAME, JsrWebSocketFilter.class));
        deploymentInfo.addFilterUrlMapping(FILTER_NAME, "/*", DispatcherType.REQUEST);
        servletContext.setAttribute(ServerContainer.class.getName(), (Object)container);
        info.containerReady(container);
    }
}

