/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.websockets.core.AbstractReceiveListener;
import io.undertow.websockets.core.BufferedBinaryMessage;
import io.undertow.websockets.core.BufferedTextMessage;
import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.core.UTF8Output;
import io.undertow.websockets.core.WebSocketCallback;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import io.undertow.websockets.jsr.DefaultPongMessage;
import io.undertow.websockets.jsr.Encoding;
import io.undertow.websockets.jsr.JsrWebSocketMessages;
import io.undertow.websockets.jsr.OrderedExecutor;
import io.undertow.websockets.jsr.UndertowSession;
import io.undertow.websockets.jsr.util.ClassUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import javax.websocket.CloseReason;
import javax.websocket.DecodeException;
import javax.websocket.Endpoint;
import javax.websocket.MessageHandler;
import javax.websocket.PongMessage;
import javax.websocket.Session;
import org.xnio.Buffers;
import org.xnio.Pooled;

class FrameHandler
extends AbstractReceiveListener {
    private final Endpoint endpoint;
    private final UndertowSession session;
    protected static final byte[] EMPTY = new byte[0];
    private final ConcurrentMap<FrameType, HandlerWrapper> handlers = new ConcurrentHashMap<FrameType, HandlerWrapper>();
    private final Executor executor;

    protected FrameHandler(UndertowSession session, Endpoint endpoint) {
        this.session = session;
        this.endpoint = endpoint;
        this.executor = new OrderedExecutor((Executor)session.getWebSocketChannel().getWorker());
    }

    protected void onFullCloseMessage(final WebSocketChannel channel, BufferedBinaryMessage message) {
        final Pooled pooled = message.getData();
        final ByteBuffer singleBuffer = FrameHandler.toBuffer((ByteBuffer[])pooled.getResource());
        final ByteBuffer toSend = singleBuffer.duplicate();
        this.session.getContainer().invokeEndpointMethod(this.executor, new Runnable(){

            @Override
            public void run() {
                WebSockets.sendClose((ByteBuffer)toSend, (WebSocketChannel)channel, null);
                try {
                    if (singleBuffer.remaining() > 1) {
                        CloseReason.CloseCode code = CloseReason.CloseCodes.getCloseCode((int)singleBuffer.getShort());
                        String reasonPhrase = singleBuffer.remaining() > 1 ? new UTF8Output(new ByteBuffer[]{singleBuffer}).extract() : null;
                        FrameHandler.this.session.close(new CloseReason(code, reasonPhrase));
                    } else {
                        FrameHandler.this.session.close();
                    }
                }
                catch (IOException e) {
                    FrameHandler.this.invokeOnError(e);
                }
                finally {
                    pooled.free();
                }
            }
        });
    }

    private void invokeOnError(final Throwable e) {
        this.session.getContainer().invokeEndpointMethod(this.executor, new Runnable(){

            @Override
            public void run() {
                try {
                    FrameHandler.this.getEndpoint().onError((Session)FrameHandler.this.session, e);
                }
                finally {
                    FrameHandler.this.session.forceClose();
                }
            }
        });
    }

    protected void onFullPongMessage(WebSocketChannel webSocketChannel, BufferedBinaryMessage bufferedBinaryMessage) {
        final HandlerWrapper handler = this.getHandler(FrameType.PONG);
        if (handler != null) {
            final Pooled pooled = bufferedBinaryMessage.getData();
            final PongMessage message = DefaultPongMessage.create(FrameHandler.toBuffer((ByteBuffer[])pooled.getResource()));
            this.session.getContainer().invokeEndpointMethod(this.executor, new Runnable(){

                @Override
                public void run() {
                    try {
                        ((MessageHandler.Whole)handler.getHandler()).onMessage((Object)message);
                    }
                    finally {
                        pooled.free();
                    }
                }
            });
        }
    }

    protected void onText(WebSocketChannel webSocketChannel, StreamSourceFrameChannel messageChannel) throws IOException {
        final HandlerWrapper handler = this.getHandler(FrameType.TEXT);
        if (handler != null && handler.isPartialHandler()) {
            BufferedTextMessage data = new BufferedTextMessage(false);
            data.read(messageChannel, (WebSocketCallback)new WebSocketCallback<BufferedTextMessage>(){

                public void complete(WebSocketChannel channel, BufferedTextMessage context) {
                    FrameHandler.this.invokeTextHandler(context, handler, context.isComplete());
                }

                public void onError(WebSocketChannel channel, BufferedTextMessage context, Throwable throwable) {
                    FrameHandler.this.invokeOnError(throwable);
                }
            });
        } else {
            this.bufferFullMessage(messageChannel);
        }
    }

    protected void onBinary(WebSocketChannel webSocketChannel, StreamSourceFrameChannel messageChannel) throws IOException {
        final HandlerWrapper handler = this.getHandler(FrameType.BYTE);
        if (handler != null && handler.isPartialHandler()) {
            BufferedBinaryMessage data = new BufferedBinaryMessage((long)this.session.getMaxBinaryMessageBufferSize(), false);
            data.read(messageChannel, (WebSocketCallback)new WebSocketCallback<BufferedBinaryMessage>(){

                public void complete(WebSocketChannel channel, BufferedBinaryMessage context) {
                    FrameHandler.this.invokeBinaryHandler(context, handler, context.isComplete());
                }

                public void onError(WebSocketChannel channel, BufferedBinaryMessage context, Throwable throwable) {
                    FrameHandler.this.invokeOnError(throwable);
                }
            });
        } else {
            this.bufferFullMessage(messageChannel);
        }
    }

    private void invokeBinaryHandler(BufferedBinaryMessage context, final HandlerWrapper handler, final boolean finalFragment) {
        final Pooled pooled = context.getData();
        this.session.getContainer().invokeEndpointMethod(this.executor, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (handler.isPartialHandler()) {
                        MessageHandler.Partial mHandler = (MessageHandler.Partial)handler.getHandler();
                        ByteBuffer[] payload = (ByteBuffer[])pooled.getResource();
                        if (handler.getMessageType() == ByteBuffer.class) {
                            mHandler.onMessage((Object)FrameHandler.toBuffer(payload), finalFragment);
                        } else if (handler.getMessageType() == byte[].class) {
                            byte[] data = FrameHandler.toArray(payload);
                            mHandler.onMessage((Object)data, finalFragment);
                        } else if (handler.getMessageType() == InputStream.class) {
                            byte[] data = FrameHandler.toArray(payload);
                            mHandler.onMessage((Object)new ByteArrayInputStream(data), finalFragment);
                        } else {
                            try {
                                Object object = FrameHandler.this.getSession().getEncoding().decodeBinary(handler.getMessageType(), FrameHandler.toArray(payload));
                                mHandler.onMessage(object, finalFragment);
                            }
                            catch (DecodeException e) {
                                FrameHandler.this.invokeOnError(e);
                            }
                        }
                    } else {
                        MessageHandler.Whole mHandler = (MessageHandler.Whole)handler.getHandler();
                        ByteBuffer[] payload = (ByteBuffer[])pooled.getResource();
                        if (handler.getMessageType() == ByteBuffer.class) {
                            mHandler.onMessage((Object)FrameHandler.toBuffer(payload));
                        } else if (handler.getMessageType() == byte[].class) {
                            byte[] data = FrameHandler.toArray(payload);
                            mHandler.onMessage((Object)data);
                        } else if (handler.getMessageType() == InputStream.class) {
                            byte[] data = FrameHandler.toArray(payload);
                            mHandler.onMessage((Object)new ByteArrayInputStream(data));
                        } else {
                            try {
                                Object object = FrameHandler.this.getSession().getEncoding().decodeBinary(handler.getMessageType(), FrameHandler.toArray(payload));
                                mHandler.onMessage(object);
                            }
                            catch (DecodeException e) {
                                FrameHandler.this.invokeOnError(e);
                            }
                        }
                    }
                }
                finally {
                    pooled.free();
                }
            }
        });
    }

    private void invokeTextHandler(BufferedTextMessage data, final HandlerWrapper handler, final boolean finalFragment) {
        final String message = data.getData();
        this.session.getContainer().invokeEndpointMethod(this.executor, new Runnable(){

            @Override
            public void run() {
                MessageHandler mHandler = handler.getHandler();
                if (mHandler instanceof MessageHandler.Partial) {
                    if (handler.getMessageType() == String.class) {
                        ((MessageHandler.Partial)handler.getHandler()).onMessage((Object)message, finalFragment);
                    } else if (handler.getMessageType() == Reader.class) {
                        ((MessageHandler.Partial)handler.getHandler()).onMessage((Object)new StringReader(message), finalFragment);
                    } else {
                        try {
                            Object object = FrameHandler.this.getSession().getEncoding().decodeText(handler.getMessageType(), message);
                            ((MessageHandler.Partial)handler.getHandler()).onMessage(object, finalFragment);
                        }
                        catch (DecodeException e) {
                            FrameHandler.this.invokeOnError(e);
                        }
                    }
                } else if (handler.getMessageType() == String.class) {
                    ((MessageHandler.Whole)handler.getHandler()).onMessage((Object)message);
                } else if (handler.getMessageType() == Reader.class) {
                    ((MessageHandler.Whole)handler.getHandler()).onMessage((Object)new StringReader(message));
                } else {
                    try {
                        Object object = FrameHandler.this.getSession().getEncoding().decodeText(handler.getMessageType(), message);
                        ((MessageHandler.Whole)handler.getHandler()).onMessage(object);
                    }
                    catch (DecodeException e) {
                        FrameHandler.this.invokeOnError(e);
                    }
                }
            }
        });
    }

    protected void onError(WebSocketChannel channel, Throwable error) {
        try {
            this.getEndpoint().onError((Session)this.session, error);
        }
        finally {
            this.session.forceClose();
        }
    }

    protected void onFullTextMessage(WebSocketChannel channel, BufferedTextMessage message) {
        HandlerWrapper handler = this.getHandler(FrameType.TEXT);
        if (handler != null) {
            this.invokeTextHandler(message, handler, true);
        }
    }

    protected void onFullBinaryMessage(WebSocketChannel channel, BufferedBinaryMessage message) {
        HandlerWrapper handler = this.getHandler(FrameType.BYTE);
        if (handler != null) {
            this.invokeBinaryHandler(message, handler, true);
        }
    }

    protected static ByteBuffer toBuffer(ByteBuffer ... payload) {
        if (payload.length == 1) {
            return payload[0];
        }
        int size = (int)Buffers.remaining((Buffer[])payload);
        if (size == 0) {
            return Buffers.EMPTY_BYTE_BUFFER;
        }
        ByteBuffer buffer = ByteBuffer.allocate(size);
        for (ByteBuffer buf : payload) {
            buffer.put(buf);
        }
        buffer.flip();
        return buffer;
    }

    protected static byte[] toArray(ByteBuffer ... payload) {
        ByteBuffer buf;
        if (payload.length == 1 && (buf = payload[0]).hasArray() && buf.arrayOffset() == 0 && buf.position() == 0 && buf.array().length == buf.remaining()) {
            return buf.array();
        }
        return Buffers.take((ByteBuffer[])payload, (int)0, (int)payload.length);
    }

    public final void addHandler(MessageHandler handler) {
        Map<Class<?>, Boolean> types = ClassUtils.getHandlerTypes(handler.getClass());
        for (Map.Entry<Class<?>, Boolean> e : types.entrySet()) {
            Class<?> type = e.getKey();
            this.verify(type, handler);
            HandlerWrapper handlerWrapper = this.createHandlerWrapper(type, handler, e.getValue());
            if (this.handlers.containsKey((Object)handlerWrapper.getFrameType())) {
                throw JsrWebSocketMessages.MESSAGES.handlerAlreadyRegistered(handlerWrapper.getFrameType());
            }
            if (this.handlers.putIfAbsent(handlerWrapper.getFrameType(), handlerWrapper) == null) continue;
            throw JsrWebSocketMessages.MESSAGES.handlerAlreadyRegistered(handlerWrapper.getFrameType());
        }
    }

    protected HandlerWrapper createHandlerWrapper(Class<?> type, MessageHandler handler, boolean partialHandler) {
        if (partialHandler) {
            if (type == String.class) {
                return new HandlerWrapper(FrameType.TEXT, handler, type, false, true);
            }
            if (type == byte[].class || type == ByteBuffer.class) {
                return new HandlerWrapper(FrameType.BYTE, handler, type, false, true);
            }
            throw JsrWebSocketMessages.MESSAGES.unsupportedFrameType(type);
        }
        if (type == byte[].class || type == ByteBuffer.class || type == InputStream.class) {
            return new HandlerWrapper(FrameType.BYTE, handler, type, false, false);
        }
        if (type == String.class || type == Reader.class) {
            return new HandlerWrapper(FrameType.TEXT, handler, type, false, false);
        }
        if (type == PongMessage.class) {
            return new HandlerWrapper(FrameType.PONG, handler, type, false, false);
        }
        Encoding encoding = this.session.getEncoding();
        if (encoding.canDecodeText(type)) {
            return new HandlerWrapper(FrameType.TEXT, handler, type, true, false);
        }
        if (encoding.canDecodeBinary(type)) {
            return new HandlerWrapper(FrameType.BYTE, handler, type, true, false);
        }
        throw JsrWebSocketMessages.MESSAGES.unsupportedFrameType(type);
    }

    protected void verify(Class<?> type, MessageHandler handler) {
    }

    public final void removeHandler(MessageHandler handler) {
        Map<Class<?>, Boolean> types = ClassUtils.getHandlerTypes(handler.getClass());
        for (Map.Entry<Class<?>, Boolean> e : types.entrySet()) {
            Class<?> type = e.getKey();
            HandlerWrapper handlerWrapper = this.createHandlerWrapper(type, handler, e.getValue());
            FrameType frameType = handlerWrapper.getFrameType();
            HandlerWrapper wrapper = (HandlerWrapper)this.handlers.get((Object)frameType);
            if (wrapper == null || wrapper.getMessageType() != type) continue;
            this.handlers.remove((Object)frameType, wrapper);
        }
    }

    public final Set<MessageHandler> getHandlers() {
        HashSet<MessageHandler> msgHandlers = new HashSet<MessageHandler>();
        for (HandlerWrapper handler : this.handlers.values()) {
            msgHandlers.add(handler.getHandler());
        }
        return msgHandlers;
    }

    protected final HandlerWrapper getHandler(FrameType type) {
        return (HandlerWrapper)this.handlers.get((Object)type);
    }

    protected long getMaxTextBufferSize() {
        return this.session.getMaxTextMessageBufferSize();
    }

    protected long getMaxBinaryBufferSize() {
        return this.session.getMaxBinaryMessageBufferSize();
    }

    UndertowSession getSession() {
        return this.session;
    }

    Endpoint getEndpoint() {
        return this.endpoint;
    }

    static final class HandlerWrapper {
        private final FrameType frameType;
        private final MessageHandler handler;
        private final Class<?> msgType;
        private final boolean decodingNeeded;
        private final boolean partialHandler;

        private HandlerWrapper(FrameType frameType, MessageHandler handler, Class<?> msgType, boolean decodingNeeded, boolean partialHandler) {
            this.frameType = frameType;
            this.handler = handler;
            this.msgType = msgType;
            this.decodingNeeded = decodingNeeded;
            this.partialHandler = partialHandler;
        }

        public MessageHandler getHandler() {
            return this.handler;
        }

        public Class<?> getMessageType() {
            return this.msgType;
        }

        FrameType getFrameType() {
            return this.frameType;
        }

        boolean isDecodingNeeded() {
            return this.decodingNeeded;
        }

        boolean isPartialHandler() {
            return this.partialHandler;
        }
    }

    static enum FrameType {
        PONG,
        BYTE,
        TEXT;

    }
}

