/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.websockets.core.BinaryOutputStream;
import io.undertow.websockets.core.StreamSinkFrameChannel;
import io.undertow.websockets.core.WebSocketCallback;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.core.WebSocketUtils;
import io.undertow.websockets.core.WebSockets;
import io.undertow.websockets.jsr.Encoding;
import io.undertow.websockets.jsr.JsrWebSocketMessages;
import io.undertow.websockets.jsr.SendHandlerAdapter;
import io.undertow.websockets.jsr.SendResultFuture;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.concurrent.Future;
import javax.websocket.EncodeException;
import javax.websocket.EndpointConfig;
import javax.websocket.RemoteEndpoint;
import javax.websocket.SendHandler;
import org.xnio.channels.Channels;
import org.xnio.channels.SuspendableWriteChannel;

final class WebSocketSessionRemoteEndpoint
implements RemoteEndpoint {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final WebSocketChannel webSocketChannel;
    private final EndpointConfig config;
    private final RemoteEndpoint.Async async = new AsyncWebSocketSessionRemoteEndpoint();
    private final RemoteEndpoint.Basic basic = new BasicWebSocketSessionRemoteEndpoint();
    private final Encoding encoding;

    public WebSocketSessionRemoteEndpoint(WebSocketChannel webSocketChannel, EndpointConfig config, Encoding encoding) {
        this.webSocketChannel = webSocketChannel;
        this.config = config;
        this.encoding = encoding;
    }

    public RemoteEndpoint.Async getAsync() {
        return this.async;
    }

    public RemoteEndpoint.Basic getBasic() {
        return this.basic;
    }

    public void flushBatch() {
    }

    public void setBatchingAllowed(boolean allowed) throws IOException {
    }

    public boolean getBatchingAllowed() {
        return false;
    }

    public void sendPing(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
        WebSockets.sendPing((ByteBuffer)applicationData, (WebSocketChannel)this.webSocketChannel, null);
    }

    public void sendPong(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
        WebSockets.sendPong((ByteBuffer)applicationData, (WebSocketChannel)this.webSocketChannel, null);
    }

    class BasicWebSocketSessionRemoteEndpoint
    implements RemoteEndpoint.Basic {
        private StreamSinkFrameChannel binaryFrameSender;
        private StreamSinkFrameChannel textFrameSender;

        BasicWebSocketSessionRemoteEndpoint() {
        }

        public void assertNotInFragment() {
            if (this.textFrameSender != null || this.binaryFrameSender != null) {
                throw JsrWebSocketMessages.MESSAGES.cannotSendInMiddleOfFragmentedMessage();
            }
        }

        public void sendText(String text) throws IOException {
            this.assertNotInFragment();
            WebSockets.sendTextBlocking((String)text, (WebSocketChannel)WebSocketSessionRemoteEndpoint.this.webSocketChannel);
        }

        public void sendBinary(ByteBuffer data) throws IOException {
            this.assertNotInFragment();
            WebSockets.sendBinaryBlocking((ByteBuffer)data, (WebSocketChannel)WebSocketSessionRemoteEndpoint.this.webSocketChannel);
        }

        public void sendText(String partialMessage, boolean isLast) throws IOException {
            if (this.binaryFrameSender != null) {
                throw JsrWebSocketMessages.MESSAGES.cannotSendInMiddleOfFragmentedMessage();
            }
            if (this.textFrameSender == null) {
                this.textFrameSender = WebSocketSessionRemoteEndpoint.this.webSocketChannel.send(WebSocketFrameType.TEXT);
            }
            try {
                Channels.writeBlocking((WritableByteChannel)this.textFrameSender, (ByteBuffer)WebSocketUtils.fromUtf8String((CharSequence)partialMessage));
                if (isLast) {
                    this.textFrameSender.shutdownWrites();
                    Channels.flushBlocking((SuspendableWriteChannel)this.textFrameSender);
                }
            }
            finally {
                if (isLast) {
                    this.textFrameSender = null;
                }
            }
        }

        public void sendBinary(ByteBuffer partialByte, boolean isLast) throws IOException {
            if (this.textFrameSender != null) {
                throw JsrWebSocketMessages.MESSAGES.cannotSendInMiddleOfFragmentedMessage();
            }
            if (this.binaryFrameSender == null) {
                this.binaryFrameSender = WebSocketSessionRemoteEndpoint.this.webSocketChannel.send(WebSocketFrameType.BINARY);
            }
            try {
                Channels.writeBlocking((WritableByteChannel)this.binaryFrameSender, (ByteBuffer)partialByte);
                if (isLast) {
                    this.binaryFrameSender.shutdownWrites();
                    Channels.flushBlocking((SuspendableWriteChannel)this.binaryFrameSender);
                }
            }
            finally {
                if (isLast) {
                    this.binaryFrameSender = null;
                }
            }
        }

        public OutputStream getSendStream() throws IOException {
            this.assertNotInFragment();
            return new BinaryOutputStream(WebSocketSessionRemoteEndpoint.this.webSocketChannel.send(WebSocketFrameType.BINARY));
        }

        public Writer getSendWriter() throws IOException {
            this.assertNotInFragment();
            return new OutputStreamWriter((OutputStream)new BinaryOutputStream(WebSocketSessionRemoteEndpoint.this.webSocketChannel.send(WebSocketFrameType.TEXT)), UTF_8);
        }

        public void sendObject(Object data) throws IOException, EncodeException {
            this.sendObjectImpl(data);
        }

        private void sendObjectImpl(Object o) throws IOException {
            block4: {
                try {
                    if (WebSocketSessionRemoteEndpoint.this.encoding.canEncodeText(o.getClass())) {
                        WebSockets.sendTextBlocking((String)WebSocketSessionRemoteEndpoint.this.encoding.encodeText(o), (WebSocketChannel)WebSocketSessionRemoteEndpoint.this.webSocketChannel);
                        break block4;
                    }
                    if (WebSocketSessionRemoteEndpoint.this.encoding.canEncodeBinary(o.getClass())) {
                        WebSockets.sendBinaryBlocking((ByteBuffer)WebSocketSessionRemoteEndpoint.this.encoding.encodeBinary(o), (WebSocketChannel)WebSocketSessionRemoteEndpoint.this.webSocketChannel);
                        break block4;
                    }
                    throw new EncodeException(o, "No suitable encoder found");
                }
                catch (EncodeException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public void setBatchingAllowed(boolean allowed) throws IOException {
        }

        public boolean getBatchingAllowed() {
            return false;
        }

        public void flushBatch() throws IOException {
        }

        public void sendPing(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
            WebSockets.sendPingBlocking((ByteBuffer)applicationData, (WebSocketChannel)WebSocketSessionRemoteEndpoint.this.webSocketChannel);
        }

        public void sendPong(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
            WebSockets.sendPingBlocking((ByteBuffer)applicationData, (WebSocketChannel)WebSocketSessionRemoteEndpoint.this.webSocketChannel);
        }
    }

    class AsyncWebSocketSessionRemoteEndpoint
    implements RemoteEndpoint.Async {
        AsyncWebSocketSessionRemoteEndpoint() {
        }

        public long getSendTimeout() {
            return 0L;
        }

        public void setSendTimeout(long timeoutmillis) {
        }

        public void sendText(String text, SendHandler handler) {
            WebSockets.sendText((String)text, (WebSocketChannel)WebSocketSessionRemoteEndpoint.this.webSocketChannel, (WebSocketCallback)new SendHandlerAdapter(handler));
        }

        public Future<Void> sendText(String text) {
            SendResultFuture future = new SendResultFuture();
            WebSockets.sendText((String)text, (WebSocketChannel)WebSocketSessionRemoteEndpoint.this.webSocketChannel, future);
            return future;
        }

        public Future<Void> sendBinary(ByteBuffer data) {
            SendResultFuture future = new SendResultFuture();
            WebSockets.sendBinary((ByteBuffer)data, (WebSocketChannel)WebSocketSessionRemoteEndpoint.this.webSocketChannel, future);
            return future;
        }

        public void sendBinary(ByteBuffer data, SendHandler completion) {
            WebSockets.sendBinary((ByteBuffer)data, (WebSocketChannel)WebSocketSessionRemoteEndpoint.this.webSocketChannel, (WebSocketCallback)new SendHandlerAdapter(completion));
        }

        public Future<Void> sendObject(Object o) {
            SendResultFuture future = new SendResultFuture();
            this.sendObjectImpl(o, future);
            return future;
        }

        public void sendObject(Object data, SendHandler handler) {
            this.sendObjectImpl(data, new SendHandlerAdapter(handler));
        }

        private void sendObjectImpl(Object o, WebSocketCallback callback) {
            block4: {
                try {
                    if (WebSocketSessionRemoteEndpoint.this.encoding.canEncodeText(o.getClass())) {
                        WebSockets.sendText((String)WebSocketSessionRemoteEndpoint.this.encoding.encodeText(o), (WebSocketChannel)WebSocketSessionRemoteEndpoint.this.webSocketChannel, (WebSocketCallback)callback);
                        break block4;
                    }
                    if (WebSocketSessionRemoteEndpoint.this.encoding.canEncodeBinary(o.getClass())) {
                        WebSockets.sendBinary((ByteBuffer)WebSocketSessionRemoteEndpoint.this.encoding.encodeBinary(o), (WebSocketChannel)WebSocketSessionRemoteEndpoint.this.webSocketChannel, (WebSocketCallback)callback);
                        break block4;
                    }
                    throw new EncodeException(o, "No suitable encoder found");
                }
                catch (EncodeException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public void setBatchingAllowed(boolean allowed) throws IOException {
        }

        public boolean getBatchingAllowed() {
            return false;
        }

        public void flushBatch() throws IOException {
        }

        public void sendPing(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
            WebSockets.sendPing((ByteBuffer)applicationData, (WebSocketChannel)WebSocketSessionRemoteEndpoint.this.webSocketChannel, null);
        }

        public void sendPong(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
            WebSockets.sendPong((ByteBuffer)applicationData, (WebSocketChannel)WebSocketSessionRemoteEndpoint.this.webSocketChannel, null);
        }
    }
}

