/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.api.ThreadSetupAction;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.servlet.util.ImmediateInstanceHandle;
import io.undertow.util.PathTemplate;
import io.undertow.websockets.WebSocketExtension;
import io.undertow.websockets.client.WebSocketClient;
import io.undertow.websockets.client.WebSocketClientNegotiation;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketVersion;
import io.undertow.websockets.jsr.ConfiguredClientEndpoint;
import io.undertow.websockets.jsr.ConfiguredServerEndpoint;
import io.undertow.websockets.jsr.EncodingFactory;
import io.undertow.websockets.jsr.EndpointSessionHandler;
import io.undertow.websockets.jsr.ExtensionImpl;
import io.undertow.websockets.jsr.JsrWebSocketLogger;
import io.undertow.websockets.jsr.JsrWebSocketMessages;
import io.undertow.websockets.jsr.UndertowSession;
import io.undertow.websockets.jsr.WebsocketClientSslProvider;
import io.undertow.websockets.jsr.annotated.AnnotatedEndpointFactory;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import javax.servlet.DispatcherType;
import javax.websocket.ClientEndpoint;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.HandshakeResponse;
import javax.websocket.Session;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.xnio.IoFuture;
import org.xnio.OptionMap;
import org.xnio.Pool;
import org.xnio.XnioWorker;
import org.xnio.ssl.XnioSsl;

public class ServerWebSocketContainer
implements ServerContainer,
Closeable {
    private final ClassIntrospecter classIntrospecter;
    private final Map<Class<?>, ConfiguredClientEndpoint> clientEndpoints = new HashMap();
    private final List<ConfiguredServerEndpoint> configuredServerEndpoints = new ArrayList<ConfiguredServerEndpoint>();
    private final TreeSet<PathTemplate> seenPaths = new TreeSet();
    private final XnioWorker xnioWorker;
    private final Pool<ByteBuffer> bufferPool;
    private final ThreadSetupAction threadSetupAction;
    private final boolean dispatchToWorker;
    private volatile long defaultAsyncSendTimeout;
    private volatile long maxSessionIdleTimeout;
    private volatile int defaultMaxBinaryMessageBufferSize;
    private volatile int defaultMaxTextMessageBufferSize;
    private volatile boolean deploymentComplete = false;
    private ServletContextImpl contextToAddFilter = null;
    private final List<WebsocketClientSslProvider> clientSslProviders;

    public ServerWebSocketContainer(ClassIntrospecter classIntrospecter, XnioWorker xnioWorker, Pool<ByteBuffer> bufferPool, ThreadSetupAction threadSetupAction, boolean dispatchToWorker, boolean clientMode) {
        this(classIntrospecter, ServerWebSocketContainer.class.getClassLoader(), xnioWorker, bufferPool, threadSetupAction, dispatchToWorker);
    }

    public ServerWebSocketContainer(ClassIntrospecter classIntrospecter, ClassLoader classLoader, XnioWorker xnioWorker, Pool<ByteBuffer> bufferPool, ThreadSetupAction threadSetupAction, boolean dispatchToWorker) {
        this.classIntrospecter = classIntrospecter;
        this.bufferPool = bufferPool;
        this.xnioWorker = xnioWorker;
        this.threadSetupAction = threadSetupAction;
        this.dispatchToWorker = dispatchToWorker;
        ArrayList<WebsocketClientSslProvider> clientSslProviders = new ArrayList<WebsocketClientSslProvider>();
        for (WebsocketClientSslProvider provider : ServiceLoader.load(WebsocketClientSslProvider.class, classLoader)) {
            clientSslProviders.add(provider);
        }
        this.clientSslProviders = Collections.unmodifiableList(clientSslProviders);
    }

    public long getDefaultAsyncSendTimeout() {
        return this.defaultAsyncSendTimeout;
    }

    public void setAsyncSendTimeout(long defaultAsyncSendTimeout) {
        this.defaultAsyncSendTimeout = defaultAsyncSendTimeout;
    }

    public Session connectToServer(Object annotatedEndpointInstance, URI path) throws DeploymentException, IOException {
        WebsocketClientSslProvider provider;
        ConfiguredClientEndpoint config = this.getClientEndpoint(annotatedEndpointInstance.getClass());
        if (config == null) {
            throw JsrWebSocketMessages.MESSAGES.notAValidClientEndpointType(annotatedEndpointInstance.getClass());
        }
        Endpoint instance = config.getFactory().createInstanceForExisting(annotatedEndpointInstance);
        XnioSsl ssl = null;
        Iterator<WebsocketClientSslProvider> i$ = this.clientSslProviders.iterator();
        while (i$.hasNext() && (ssl = (provider = i$.next()).getSsl(this.xnioWorker, annotatedEndpointInstance, path)) == null) {
        }
        return this.connectToServerInternal(instance, ssl, config, path);
    }

    public Session connectToServer(Class<?> aClass, URI uri) throws DeploymentException, IOException {
        ConfiguredClientEndpoint config = this.getClientEndpoint(aClass);
        if (config == null) {
            throw JsrWebSocketMessages.MESSAGES.notAValidClientEndpointType(aClass);
        }
        try {
            WebsocketClientSslProvider provider;
            InstanceHandle<Endpoint> instance = config.getFactory().createInstance();
            XnioSsl ssl = null;
            Iterator<WebsocketClientSslProvider> i$ = this.clientSslProviders.iterator();
            while (i$.hasNext() && (ssl = (provider = i$.next()).getSsl(this.xnioWorker, aClass, uri)) == null) {
            }
            return this.connectToServerInternal((Endpoint)instance.getInstance(), ssl, config, uri);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public Session connectToServer(Endpoint endpointInstance, ClientEndpointConfig config, URI path) throws DeploymentException, IOException {
        WebsocketClientSslProvider provider;
        ClientEndpointConfig cec = config != null ? config : ClientEndpointConfig.Builder.create().build();
        ClientNegotiation clientNegotiation = new ClientNegotiation(cec.getPreferredSubprotocols(), ServerWebSocketContainer.toExtensionList(cec.getExtensions()), cec);
        XnioSsl ssl = null;
        Iterator<WebsocketClientSslProvider> i$ = this.clientSslProviders.iterator();
        while (i$.hasNext() && (ssl = (provider = i$.next()).getSsl(this.xnioWorker, endpointInstance, cec, path)) == null) {
        }
        IoFuture session = WebSocketClient.connect((XnioWorker)this.xnioWorker, ssl, this.bufferPool, (OptionMap)OptionMap.EMPTY, (URI)path, (WebSocketVersion)WebSocketVersion.V13, (WebSocketClientNegotiation)clientNegotiation);
        WebSocketChannel channel = (WebSocketChannel)session.get();
        EndpointSessionHandler sessionHandler = new EndpointSessionHandler(this);
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        HashMap<String, Extension> extMap = new HashMap<String, Extension>();
        for (Extension ext : cec.getExtensions()) {
            extMap.put(ext.getName(), ext);
        }
        for (WebSocketExtension e : clientNegotiation.getSelectedExtensions()) {
            Extension ext = (Extension)extMap.get(e.getName());
            if (ext == null) {
                throw JsrWebSocketMessages.MESSAGES.extensionWasNotPresentInClientHandshake(e.getName(), clientNegotiation.getSupportedExtensions());
            }
            extensions.add(ExtensionImpl.create(e));
        }
        EncodingFactory encodingFactory = EncodingFactory.createFactory(this.classIntrospecter, cec.getDecoders(), cec.getEncoders());
        UndertowSession undertowSession = new UndertowSession(channel, path, Collections.<String, String>emptyMap(), Collections.<String, List<String>>emptyMap(), sessionHandler, null, (InstanceHandle<Endpoint>)new ImmediateInstanceHandle((Object)endpointInstance), (EndpointConfig)cec, path.getQuery(), encodingFactory.createEncoding((EndpointConfig)cec), new HashSet<Session>(), clientNegotiation.getSelectedSubProtocol(), extensions);
        endpointInstance.onOpen((Session)undertowSession, (EndpointConfig)cec);
        channel.resumeReceives();
        return undertowSession;
    }

    public Session connectToServer(Class<? extends Endpoint> endpointClass, ClientEndpointConfig cec, URI path) throws DeploymentException, IOException {
        try {
            Endpoint endpoint = endpointClass.newInstance();
            return this.connectToServer(endpoint, cec, path);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private Session connectToServerInternal(Endpoint endpointInstance, XnioSsl ssl, ConfiguredClientEndpoint cec, URI path) throws DeploymentException, IOException {
        ClientNegotiation clientNegotiation = new ClientNegotiation(cec.getConfig().getPreferredSubprotocols(), ServerWebSocketContainer.toExtensionList(cec.getConfig().getExtensions()), cec.getConfig());
        IoFuture session = WebSocketClient.connect((XnioWorker)this.xnioWorker, (XnioSsl)ssl, this.bufferPool, (OptionMap)OptionMap.EMPTY, (URI)path, (WebSocketVersion)WebSocketVersion.V13, (WebSocketClientNegotiation)clientNegotiation);
        WebSocketChannel channel = (WebSocketChannel)session.get();
        EndpointSessionHandler sessionHandler = new EndpointSessionHandler(this);
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        HashMap<String, Extension> extMap = new HashMap<String, Extension>();
        for (Extension ext : cec.getConfig().getExtensions()) {
            extMap.put(ext.getName(), ext);
        }
        for (WebSocketExtension e : clientNegotiation.getSelectedExtensions()) {
            Extension ext = (Extension)extMap.get(e.getName());
            if (ext == null) {
                throw JsrWebSocketMessages.MESSAGES.extensionWasNotPresentInClientHandshake(e.getName(), clientNegotiation.getSupportedExtensions());
            }
            extensions.add(ExtensionImpl.create(e));
        }
        UndertowSession undertowSession = new UndertowSession(channel, path, Collections.<String, String>emptyMap(), Collections.<String, List<String>>emptyMap(), sessionHandler, null, (InstanceHandle<Endpoint>)new ImmediateInstanceHandle((Object)endpointInstance), (EndpointConfig)cec.getConfig(), path.getQuery(), cec.getEncodingFactory().createEncoding((EndpointConfig)cec.getConfig()), new HashSet<Session>(), clientNegotiation.getSelectedSubProtocol(), extensions);
        endpointInstance.onOpen((Session)undertowSession, (EndpointConfig)cec.getConfig());
        channel.resumeReceives();
        return undertowSession;
    }

    public long getDefaultMaxSessionIdleTimeout() {
        return this.maxSessionIdleTimeout;
    }

    public void setDefaultMaxSessionIdleTimeout(long timeout) {
        this.maxSessionIdleTimeout = timeout;
    }

    public int getDefaultMaxBinaryMessageBufferSize() {
        return this.defaultMaxBinaryMessageBufferSize;
    }

    public void setDefaultMaxBinaryMessageBufferSize(int defaultMaxBinaryMessageBufferSize) {
        this.defaultMaxBinaryMessageBufferSize = defaultMaxBinaryMessageBufferSize;
    }

    public int getDefaultMaxTextMessageBufferSize() {
        return this.defaultMaxTextMessageBufferSize;
    }

    public void setDefaultMaxTextMessageBufferSize(int defaultMaxTextMessageBufferSize) {
        this.defaultMaxTextMessageBufferSize = defaultMaxTextMessageBufferSize;
    }

    public Set<Extension> getInstalledExtensions() {
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeEndpointMethod(Executor executor, final Runnable invocation) {
        if (this.dispatchToWorker) {
            executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ThreadSetupAction.Handle handle = ServerWebSocketContainer.this.threadSetupAction.setup(null);
                    try {
                        invocation.run();
                    }
                    finally {
                        handle.tearDown();
                    }
                }
            });
        } else {
            ThreadSetupAction.Handle handle = this.threadSetupAction.setup(null);
            try {
                invocation.run();
            }
            finally {
                handle.tearDown();
            }
        }
    }

    public void addEndpoint(Class<?> endpoint) throws DeploymentException {
        if (this.deploymentComplete) {
            throw JsrWebSocketMessages.MESSAGES.cannotAddEndpointAfterDeployment();
        }
        this.addEndpointInternal(endpoint);
    }

    private void addEndpointInternal(Class<?> endpoint) throws DeploymentException {
        block8: {
            try {
                ServerEndpoint serverEndpoint = endpoint.getAnnotation(ServerEndpoint.class);
                ClientEndpoint clientEndpoint = endpoint.getAnnotation(ClientEndpoint.class);
                if (serverEndpoint != null) {
                    JsrWebSocketLogger.ROOT_LOGGER.addingAnnotatedServerEndpoint(endpoint, serverEndpoint.value());
                    PathTemplate template = PathTemplate.create((String)serverEndpoint.value());
                    if (this.seenPaths.contains(template)) {
                        PathTemplate existing = null;
                        for (PathTemplate p : this.seenPaths) {
                            if (p.compareTo(template) != 0) continue;
                            existing = p;
                            break;
                        }
                        throw JsrWebSocketMessages.MESSAGES.multipleEndpointsWithOverlappingPaths(template, existing);
                    }
                    this.seenPaths.add(template);
                    EncodingFactory encodingFactory = EncodingFactory.createFactory(this.classIntrospecter, serverEndpoint.decoders(), serverEndpoint.encoders());
                    AnnotatedEndpointFactory factory = AnnotatedEndpointFactory.create(endpoint, this.classIntrospecter.createInstanceFactory(endpoint), encodingFactory, template.getParameterNames());
                    Class configuratorClass = serverEndpoint.configurator();
                    Object configurator = configuratorClass != ServerEndpointConfig.Configurator.class ? (ServerEndpointConfig.Configurator)configuratorClass.newInstance() : new ServerInstanceFactoryConfigurator(factory);
                    ServerEndpointConfig config = ServerEndpointConfig.Builder.create(endpoint, (String)serverEndpoint.value()).decoders(Arrays.asList(serverEndpoint.decoders())).encoders(Arrays.asList(serverEndpoint.encoders())).subprotocols(Arrays.asList(serverEndpoint.subprotocols())).configurator(configurator).build();
                    ConfiguredServerEndpoint confguredServerEndpoint = new ConfiguredServerEndpoint(config, factory, template, encodingFactory);
                    this.configuredServerEndpoints.add(confguredServerEndpoint);
                    this.handleAddingFilterMapping();
                    break block8;
                }
                if (clientEndpoint != null) {
                    JsrWebSocketLogger.ROOT_LOGGER.addingAnnotatedClientEndpoint(endpoint);
                    EncodingFactory encodingFactory = EncodingFactory.createFactory(this.classIntrospecter, clientEndpoint.decoders(), clientEndpoint.encoders());
                    AnnotatedEndpointFactory factory = AnnotatedEndpointFactory.create(endpoint, this.classIntrospecter.createInstanceFactory(endpoint), encodingFactory, Collections.<String>emptySet());
                    ClientEndpointConfig config = ClientEndpointConfig.Builder.create().decoders(Arrays.asList(clientEndpoint.decoders())).encoders(Arrays.asList(clientEndpoint.encoders())).preferredSubprotocols(Arrays.asList(clientEndpoint.subprotocols())).configurator((ClientEndpointConfig.Configurator)clientEndpoint.configurator().newInstance()).build();
                    ConfiguredClientEndpoint configuredClientEndpoint = new ConfiguredClientEndpoint(config, factory, encodingFactory);
                    this.clientEndpoints.put(endpoint, configuredClientEndpoint);
                    break block8;
                }
                throw JsrWebSocketMessages.MESSAGES.classWasNotAnnotated(endpoint);
            }
            catch (NoSuchMethodException e) {
                throw JsrWebSocketMessages.MESSAGES.couldNotDeploy(e);
            }
            catch (InstantiationException e) {
                throw JsrWebSocketMessages.MESSAGES.couldNotDeploy(e);
            }
            catch (IllegalAccessException e) {
                throw JsrWebSocketMessages.MESSAGES.couldNotDeploy(e);
            }
        }
    }

    private void handleAddingFilterMapping() {
        if (this.contextToAddFilter != null) {
            this.contextToAddFilter.getDeployment().getDeploymentInfo().addFilterUrlMapping("Undertow Web Socket Filter", "/*", DispatcherType.REQUEST);
            this.contextToAddFilter.getDeployment().getServletPaths().invalidate();
            this.contextToAddFilter = null;
        }
    }

    public void addEndpoint(ServerEndpointConfig endpoint) throws DeploymentException {
        if (this.deploymentComplete) {
            throw JsrWebSocketMessages.MESSAGES.cannotAddEndpointAfterDeployment();
        }
        JsrWebSocketLogger.ROOT_LOGGER.addingProgramaticEndpoint(endpoint.getEndpointClass(), endpoint.getPath());
        PathTemplate template = PathTemplate.create((String)endpoint.getPath());
        if (this.seenPaths.contains(template)) {
            PathTemplate existing = null;
            for (PathTemplate p : this.seenPaths) {
                if (p.compareTo(template) != 0) continue;
                existing = p;
                break;
            }
            throw JsrWebSocketMessages.MESSAGES.multipleEndpointsWithOverlappingPaths(template, existing);
        }
        this.seenPaths.add(template);
        EncodingFactory encodingFactory = EncodingFactory.createFactory(this.classIntrospecter, endpoint.getDecoders(), endpoint.getEncoders());
        ConfiguredServerEndpoint confguredServerEndpoint = new ConfiguredServerEndpoint(endpoint, null, template, encodingFactory);
        this.configuredServerEndpoints.add(confguredServerEndpoint);
        this.handleAddingFilterMapping();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfiguredClientEndpoint getClientEndpoint(Class<?> type) {
        ConfiguredClientEndpoint existing = this.clientEndpoints.get(type);
        if (existing != null) {
            return existing;
        }
        ServerWebSocketContainer serverWebSocketContainer = this;
        synchronized (serverWebSocketContainer) {
            existing = this.clientEndpoints.get(type);
            if (existing != null) {
                return existing;
            }
            if (type.isAnnotationPresent(ClientEndpoint.class)) {
                try {
                    this.addEndpointInternal(type);
                    return this.clientEndpoints.get(type);
                }
                catch (DeploymentException e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }
    }

    public void deploymentComplete() {
        this.deploymentComplete = true;
    }

    public List<ConfiguredServerEndpoint> getConfiguredServerEndpoints() {
        return this.configuredServerEndpoints;
    }

    public ServletContextImpl getContextToAddFilter() {
        return this.contextToAddFilter;
    }

    public void setContextToAddFilter(ServletContextImpl contextToAddFilter) {
        this.contextToAddFilter = contextToAddFilter;
    }

    @Override
    public synchronized void close() {
        for (ConfiguredServerEndpoint endpoint : this.configuredServerEndpoints) {
            for (Session session : endpoint.getOpenSessions()) {
                try {
                    session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.GOING_AWAY, ""));
                }
                catch (Exception e) {
                    JsrWebSocketLogger.ROOT_LOGGER.couldNotCloseOnUndeploy(e);
                }
            }
        }
    }

    private static List<WebSocketExtension> toExtensionList(List<Extension> extensions) {
        ArrayList<WebSocketExtension> ret = new ArrayList<WebSocketExtension>();
        for (Extension e : extensions) {
            ArrayList<WebSocketExtension.Parameter> parameters = new ArrayList<WebSocketExtension.Parameter>();
            for (Extension.Parameter p : e.getParameters()) {
                parameters.add(new WebSocketExtension.Parameter(p.getName(), p.getValue()));
            }
            ret.add(new WebSocketExtension(e.getName(), parameters));
        }
        return ret;
    }

    private class ClientNegotiation
    extends WebSocketClientNegotiation {
        private final ClientEndpointConfig config;

        public ClientNegotiation(List<String> supportedSubProtocols, List<WebSocketExtension> supportedExtensions, ClientEndpointConfig config) {
            super(supportedSubProtocols, supportedExtensions);
            this.config = config;
        }

        public void afterRequest(Map<String, String> headers) {
            ClientEndpointConfig.Configurator configurator = this.config.getConfigurator();
            if (configurator != null) {
                final HashMap newHeaders = new HashMap();
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(entry.getValue());
                    newHeaders.put(entry.getKey(), arrayList);
                }
                configurator.afterResponse(new HandshakeResponse(){

                    public Map<String, List<String>> getHeaders() {
                        return newHeaders;
                    }
                });
            }
        }

        public void beforeRequest(Map<String, String> headers) {
            ClientEndpointConfig.Configurator configurator = this.config.getConfigurator();
            if (configurator != null) {
                HashMap newHeaders = new HashMap();
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(entry.getValue());
                    newHeaders.put(entry.getKey(), arrayList);
                }
                configurator.beforeRequest(newHeaders);
                headers.clear();
                for (Map.Entry<String, String> entry : newHeaders.entrySet()) {
                    if (((List)((Object)entry.getValue())).isEmpty()) continue;
                    headers.put(entry.getKey(), (String)((List)((Object)entry.getValue())).get(0));
                }
            }
        }
    }

    private static final class ServerInstanceFactoryConfigurator
    extends ServerEndpointConfig.Configurator {
        private final InstanceFactory<?> factory;

        private ServerInstanceFactoryConfigurator(InstanceFactory<?> factory) {
            this.factory = factory;
        }

        public <T> T getEndpointInstance(Class<T> endpointClass) throws InstantiationException {
            return (T)this.factory.createInstance().getInstance();
        }
    }
}

