/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.websockets.core.BinaryOutputStream;
import io.undertow.websockets.core.StreamSinkFrameChannel;
import io.undertow.websockets.core.WebSocketCallback;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.core.WebSocketUtils;
import io.undertow.websockets.core.WebSockets;
import io.undertow.websockets.jsr.Encoding;
import io.undertow.websockets.jsr.JsrWebSocketMessages;
import io.undertow.websockets.jsr.SendHandlerAdapter;
import io.undertow.websockets.jsr.SendResultFuture;
import io.undertow.websockets.jsr.UndertowSession;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.concurrent.Future;
import javax.websocket.EncodeException;
import javax.websocket.RemoteEndpoint;
import javax.websocket.SendHandler;
import org.xnio.channels.Channels;
import org.xnio.channels.SuspendableWriteChannel;

final class WebSocketSessionRemoteEndpoint
implements RemoteEndpoint {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final UndertowSession undertowSession;
    private final RemoteEndpoint.Async async = new AsyncWebSocketSessionRemoteEndpoint();
    private final RemoteEndpoint.Basic basic = new BasicWebSocketSessionRemoteEndpoint();
    private final Encoding encoding;

    public WebSocketSessionRemoteEndpoint(UndertowSession session, Encoding encoding) {
        this.undertowSession = session;
        this.encoding = encoding;
    }

    public RemoteEndpoint.Async getAsync() {
        return this.async;
    }

    public RemoteEndpoint.Basic getBasic() {
        return this.basic;
    }

    public void flushBatch() {
    }

    public void setBatchingAllowed(boolean allowed) throws IOException {
    }

    public boolean getBatchingAllowed() {
        return false;
    }

    public void sendPing(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
        if (applicationData == null) {
            throw JsrWebSocketMessages.MESSAGES.messageInNull();
        }
        if (applicationData.remaining() > 125) {
            throw JsrWebSocketMessages.MESSAGES.messageTooLarge(applicationData.remaining(), 125);
        }
        WebSockets.sendPing((ByteBuffer)applicationData, (WebSocketChannel)this.undertowSession.getWebSocketChannel(), null);
    }

    public void sendPong(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
        if (applicationData == null) {
            throw JsrWebSocketMessages.MESSAGES.messageInNull();
        }
        if (applicationData.remaining() > 125) {
            throw JsrWebSocketMessages.MESSAGES.messageTooLarge(applicationData.remaining(), 125);
        }
        WebSockets.sendPong((ByteBuffer)applicationData, (WebSocketChannel)this.undertowSession.getWebSocketChannel(), null);
    }

    class BasicWebSocketSessionRemoteEndpoint
    implements RemoteEndpoint.Basic {
        private StreamSinkFrameChannel binaryFrameSender;
        private StreamSinkFrameChannel textFrameSender;

        BasicWebSocketSessionRemoteEndpoint() {
        }

        public void assertNotInFragment() {
            if (this.textFrameSender != null || this.binaryFrameSender != null) {
                throw JsrWebSocketMessages.MESSAGES.cannotSendInMiddleOfFragmentedMessage();
            }
        }

        public void sendText(String text) throws IOException {
            if (text == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            this.assertNotInFragment();
            WebSockets.sendTextBlocking((String)text, (WebSocketChannel)WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel());
        }

        public void sendBinary(ByteBuffer data) throws IOException {
            if (data == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            this.assertNotInFragment();
            WebSockets.sendBinaryBlocking((ByteBuffer)data, (WebSocketChannel)WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel());
            data.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendText(String partialMessage, boolean isLast) throws IOException {
            if (partialMessage == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            if (this.binaryFrameSender != null) {
                throw JsrWebSocketMessages.MESSAGES.cannotSendInMiddleOfFragmentedMessage();
            }
            if (this.textFrameSender == null) {
                this.textFrameSender = WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel().send(WebSocketFrameType.TEXT);
            }
            try {
                Channels.writeBlocking((WritableByteChannel)this.textFrameSender, (ByteBuffer)WebSocketUtils.fromUtf8String((CharSequence)partialMessage));
                if (isLast) {
                    this.textFrameSender.shutdownWrites();
                }
                Channels.flushBlocking((SuspendableWriteChannel)this.textFrameSender);
            }
            finally {
                if (isLast) {
                    this.textFrameSender = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendBinary(ByteBuffer partialByte, boolean isLast) throws IOException {
            if (partialByte == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            if (this.textFrameSender != null) {
                throw JsrWebSocketMessages.MESSAGES.cannotSendInMiddleOfFragmentedMessage();
            }
            if (this.binaryFrameSender == null) {
                this.binaryFrameSender = WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel().send(WebSocketFrameType.BINARY);
            }
            try {
                Channels.writeBlocking((WritableByteChannel)this.binaryFrameSender, (ByteBuffer)partialByte);
                if (isLast) {
                    this.binaryFrameSender.shutdownWrites();
                }
                Channels.flushBlocking((SuspendableWriteChannel)this.binaryFrameSender);
            }
            finally {
                if (isLast) {
                    this.binaryFrameSender = null;
                }
            }
            partialByte.clear();
        }

        public OutputStream getSendStream() throws IOException {
            this.assertNotInFragment();
            return new BinaryOutputStream(WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel().send(WebSocketFrameType.BINARY));
        }

        public Writer getSendWriter() throws IOException {
            this.assertNotInFragment();
            return new OutputStreamWriter((OutputStream)new BinaryOutputStream(WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel().send(WebSocketFrameType.TEXT)), UTF_8);
        }

        public void sendObject(Object data) throws IOException, EncodeException {
            if (data == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            this.sendObjectImpl(data);
        }

        private void sendObjectImpl(Object o) throws IOException, EncodeException {
            if (o instanceof String) {
                this.sendText((String)o);
            } else if (o instanceof byte[]) {
                this.sendBinary(ByteBuffer.wrap((byte[])o));
            } else if (o instanceof ByteBuffer) {
                this.sendBinary((ByteBuffer)o);
            } else if (WebSocketSessionRemoteEndpoint.this.encoding.canEncodeText(o.getClass())) {
                WebSockets.sendTextBlocking((String)WebSocketSessionRemoteEndpoint.this.encoding.encodeText(o), (WebSocketChannel)WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel());
            } else if (WebSocketSessionRemoteEndpoint.this.encoding.canEncodeBinary(o.getClass())) {
                WebSockets.sendBinaryBlocking((ByteBuffer)WebSocketSessionRemoteEndpoint.this.encoding.encodeBinary(o), (WebSocketChannel)WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel());
            } else {
                throw new EncodeException(o, "No suitable encoder found");
            }
        }

        public void setBatchingAllowed(boolean allowed) throws IOException {
        }

        public boolean getBatchingAllowed() {
            return false;
        }

        public void flushBatch() throws IOException {
        }

        public void sendPing(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
            if (applicationData == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            if (applicationData.remaining() > 125) {
                throw JsrWebSocketMessages.MESSAGES.messageTooLarge(applicationData.remaining(), 125);
            }
            WebSockets.sendPingBlocking((ByteBuffer)applicationData, (WebSocketChannel)WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel());
        }

        public void sendPong(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
            if (applicationData == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            if (applicationData.remaining() > 125) {
                throw JsrWebSocketMessages.MESSAGES.messageTooLarge(applicationData.remaining(), 125);
            }
            WebSockets.sendPongBlocking((ByteBuffer)applicationData, (WebSocketChannel)WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel());
        }
    }

    class AsyncWebSocketSessionRemoteEndpoint
    implements RemoteEndpoint.Async {
        private long sendTimeout = 0L;

        AsyncWebSocketSessionRemoteEndpoint() {
        }

        public long getSendTimeout() {
            return this.sendTimeout;
        }

        public void setSendTimeout(long timeoutmillis) {
            this.sendTimeout = timeoutmillis;
        }

        public void sendText(String text, SendHandler handler) {
            if (handler == null) {
                throw JsrWebSocketMessages.MESSAGES.handlerIsNull();
            }
            if (text == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            WebSockets.sendText((String)text, (WebSocketChannel)WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel(), (WebSocketCallback)new SendHandlerAdapter(handler), (long)this.sendTimeout);
        }

        public Future<Void> sendText(String text) {
            if (text == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            SendResultFuture future = new SendResultFuture();
            WebSockets.sendText((String)text, (WebSocketChannel)WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel(), future, (long)this.sendTimeout);
            return future;
        }

        public Future<Void> sendBinary(ByteBuffer data) {
            if (data == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            SendResultFuture future = new SendResultFuture();
            WebSockets.sendBinary((ByteBuffer)data, (WebSocketChannel)WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel(), future, (long)this.sendTimeout);
            return future;
        }

        public void sendBinary(ByteBuffer data, SendHandler completion) {
            if (completion == null) {
                throw JsrWebSocketMessages.MESSAGES.handlerIsNull();
            }
            if (data == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            WebSockets.sendBinary((ByteBuffer)data, (WebSocketChannel)WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel(), (WebSocketCallback)new SendHandlerAdapter(completion), (long)this.sendTimeout);
        }

        public Future<Void> sendObject(Object o) {
            if (o == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            SendResultFuture future = new SendResultFuture();
            this.sendObjectImpl(o, future);
            return future;
        }

        public void sendObject(Object data, SendHandler handler) {
            if (handler == null) {
                throw JsrWebSocketMessages.MESSAGES.handlerIsNull();
            }
            if (data == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            this.sendObjectImpl(data, new SendHandlerAdapter(handler));
        }

        private void sendObjectImpl(Object o, WebSocketCallback callback) {
            block7: {
                try {
                    if (o instanceof String) {
                        WebSockets.sendText((String)((String)o), (WebSocketChannel)WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel(), (WebSocketCallback)callback, (long)this.sendTimeout);
                        break block7;
                    }
                    if (o instanceof byte[]) {
                        WebSockets.sendBinary((ByteBuffer)ByteBuffer.wrap((byte[])o), (WebSocketChannel)WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel(), (WebSocketCallback)callback, (long)this.sendTimeout);
                        break block7;
                    }
                    if (o instanceof ByteBuffer) {
                        WebSockets.sendBinary((ByteBuffer)((ByteBuffer)o), (WebSocketChannel)WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel(), (WebSocketCallback)callback, (long)this.sendTimeout);
                        break block7;
                    }
                    if (WebSocketSessionRemoteEndpoint.this.encoding.canEncodeText(o.getClass())) {
                        WebSockets.sendText((String)WebSocketSessionRemoteEndpoint.this.encoding.encodeText(o), (WebSocketChannel)WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel(), (WebSocketCallback)callback, (long)this.sendTimeout);
                        break block7;
                    }
                    if (WebSocketSessionRemoteEndpoint.this.encoding.canEncodeBinary(o.getClass())) {
                        WebSockets.sendBinary((ByteBuffer)WebSocketSessionRemoteEndpoint.this.encoding.encodeBinary(o), (WebSocketChannel)WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel(), (WebSocketCallback)callback, (long)this.sendTimeout);
                        break block7;
                    }
                    throw new EncodeException(o, "No suitable encoder found");
                }
                catch (Exception e) {
                    callback.onError(WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel(), null, (Throwable)e);
                }
            }
        }

        public void setBatchingAllowed(boolean allowed) throws IOException {
        }

        public boolean getBatchingAllowed() {
            return false;
        }

        public void flushBatch() throws IOException {
        }

        public void sendPing(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
            if (applicationData == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            if (applicationData.remaining() > 125) {
                throw JsrWebSocketMessages.MESSAGES.messageTooLarge(applicationData.remaining(), 125);
            }
            WebSockets.sendPing((ByteBuffer)applicationData, (WebSocketChannel)WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel(), null, (long)this.sendTimeout);
        }

        public void sendPong(ByteBuffer applicationData) throws IOException, IllegalArgumentException {
            if (applicationData == null) {
                throw JsrWebSocketMessages.MESSAGES.messageInNull();
            }
            if (applicationData.remaining() > 125) {
                throw JsrWebSocketMessages.MESSAGES.messageTooLarge(applicationData.remaining(), 125);
            }
            WebSockets.sendPong((ByteBuffer)applicationData, (WebSocketChannel)WebSocketSessionRemoteEndpoint.this.undertowSession.getWebSocketChannel(), null, (long)this.sendTimeout);
        }
    }
}

