/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.websockets.jsr;

import io.undertow.connector.ByteBufferPool;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.HttpUpgradeListener;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.InstanceHandle;
import io.undertow.servlet.api.ThreadSetupHandler;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.servlet.util.ConstructorInstanceFactory;
import io.undertow.servlet.util.ImmediateInstanceHandle;
import io.undertow.servlet.websockets.ServletWebSocketHttpExchange;
import io.undertow.util.CopyOnWriteMap;
import io.undertow.util.PathTemplate;
import io.undertow.websockets.WebSocketExtension;
import io.undertow.websockets.client.WebSocketClient;
import io.undertow.websockets.client.WebSocketClientNegotiation;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.protocol.Handshake;
import io.undertow.websockets.extensions.ExtensionHandshake;
import io.undertow.websockets.jsr.ConfiguredClientEndpoint;
import io.undertow.websockets.jsr.ConfiguredServerEndpoint;
import io.undertow.websockets.jsr.DefaultContainerConfigurator;
import io.undertow.websockets.jsr.EncodingFactory;
import io.undertow.websockets.jsr.EndpointSessionHandler;
import io.undertow.websockets.jsr.ExtensionImpl;
import io.undertow.websockets.jsr.JsrWebSocketLogger;
import io.undertow.websockets.jsr.JsrWebSocketMessages;
import io.undertow.websockets.jsr.UndertowSession;
import io.undertow.websockets.jsr.WebSocketDeploymentInfo;
import io.undertow.websockets.jsr.WebSocketReconnectHandler;
import io.undertow.websockets.jsr.WebsocketClientSslProvider;
import io.undertow.websockets.jsr.annotated.AnnotatedEndpoint;
import io.undertow.websockets.jsr.annotated.AnnotatedEndpointFactory;
import io.undertow.websockets.jsr.handshake.HandshakeUtil;
import io.undertow.websockets.jsr.handshake.JsrHybi07Handshake;
import io.undertow.websockets.jsr.handshake.JsrHybi08Handshake;
import io.undertow.websockets.jsr.handshake.JsrHybi13Handshake;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.websocket.ClientEndpoint;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.HandshakeResponse;
import javax.websocket.Session;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.StreamConnection;
import org.xnio.XnioWorker;
import org.xnio.http.UpgradeFailedException;
import org.xnio.ssl.XnioSsl;

public class ServerWebSocketContainer
implements ServerContainer,
Closeable {
    public static final String TIMEOUT = "io.undertow.websocket.CONNECT_TIMEOUT";
    public static final int DEFAULT_WEB_SOCKET_TIMEOUT_SECONDS = 10;
    private final ClassIntrospecter classIntrospecter;
    private final Map<Class<?>, ConfiguredClientEndpoint> clientEndpoints = new CopyOnWriteMap();
    private final List<ConfiguredServerEndpoint> configuredServerEndpoints = new ArrayList<ConfiguredServerEndpoint>();
    private final Set<Class<?>> annotatedEndpointClasses = new HashSet();
    private final TreeSet<PathTemplate> seenPaths = new TreeSet();
    private final XnioWorker xnioWorker;
    private final ByteBufferPool bufferPool;
    private final boolean dispatchToWorker;
    private final InetSocketAddress clientBindAddress;
    private final WebSocketReconnectHandler webSocketReconnectHandler;
    private volatile long defaultAsyncSendTimeout;
    private volatile long defaultMaxSessionIdleTimeout;
    private volatile int defaultMaxBinaryMessageBufferSize;
    private volatile int defaultMaxTextMessageBufferSize;
    private volatile boolean deploymentComplete = false;
    private final List<DeploymentException> deploymentExceptions = new ArrayList<DeploymentException>();
    private ServletContextImpl contextToAddFilter = null;
    private final List<WebsocketClientSslProvider> clientSslProviders;
    private final List<PauseListener> pauseListeners = new ArrayList<PauseListener>();
    private final List<Extension> installedExtensions;
    private final ThreadSetupHandler.Action<Void, Runnable> invokeEndpointTask;
    private volatile boolean closed = false;

    public ServerWebSocketContainer(ClassIntrospecter classIntrospecter, XnioWorker xnioWorker, ByteBufferPool bufferPool, List<ThreadSetupHandler> threadSetupHandlers, boolean dispatchToWorker, boolean clientMode) {
        this(classIntrospecter, ServerWebSocketContainer.class.getClassLoader(), xnioWorker, bufferPool, threadSetupHandlers, dispatchToWorker, null, null);
    }

    public ServerWebSocketContainer(ClassIntrospecter classIntrospecter, ClassLoader classLoader, XnioWorker xnioWorker, ByteBufferPool bufferPool, List<ThreadSetupHandler> threadSetupHandlers, boolean dispatchToWorker) {
        this(classIntrospecter, classLoader, xnioWorker, bufferPool, threadSetupHandlers, dispatchToWorker, null, null);
    }

    public ServerWebSocketContainer(ClassIntrospecter classIntrospecter, ClassLoader classLoader, XnioWorker xnioWorker, ByteBufferPool bufferPool, List<ThreadSetupHandler> threadSetupHandlers, boolean dispatchToWorker, InetSocketAddress clientBindAddress, WebSocketReconnectHandler reconnectHandler) {
        this(classIntrospecter, classLoader, xnioWorker, bufferPool, threadSetupHandlers, dispatchToWorker, clientBindAddress, reconnectHandler, Collections.emptyList());
    }

    public ServerWebSocketContainer(ClassIntrospecter classIntrospecter, ClassLoader classLoader, XnioWorker xnioWorker, ByteBufferPool bufferPool, List<ThreadSetupHandler> threadSetupHandlers, boolean dispatchToWorker, InetSocketAddress clientBindAddress, WebSocketReconnectHandler reconnectHandler, List<Extension> installedExtensions) {
        this.classIntrospecter = classIntrospecter;
        this.bufferPool = bufferPool;
        this.xnioWorker = xnioWorker;
        this.dispatchToWorker = dispatchToWorker;
        this.clientBindAddress = clientBindAddress;
        this.installedExtensions = new ArrayList<Extension>(installedExtensions);
        ArrayList<WebsocketClientSslProvider> clientSslProviders = new ArrayList<WebsocketClientSslProvider>();
        for (WebsocketClientSslProvider provider : ServiceLoader.load(WebsocketClientSslProvider.class, classLoader)) {
            clientSslProviders.add(provider);
        }
        this.clientSslProviders = Collections.unmodifiableList(clientSslProviders);
        this.webSocketReconnectHandler = reconnectHandler;
        ThreadSetupHandler.Action<Void, Runnable> task = new ThreadSetupHandler.Action<Void, Runnable>(){

            public Void call(HttpServerExchange exchange, Runnable context) throws Exception {
                context.run();
                return null;
            }
        };
        for (ThreadSetupHandler handler : threadSetupHandlers) {
            task = handler.create((ThreadSetupHandler.Action)task);
        }
        this.invokeEndpointTask = task;
    }

    public long getDefaultAsyncSendTimeout() {
        return this.defaultAsyncSendTimeout;
    }

    public void setAsyncSendTimeout(long defaultAsyncSendTimeout) {
        this.defaultAsyncSendTimeout = defaultAsyncSendTimeout;
    }

    public Session connectToServer(Object annotatedEndpointInstance, WebSocketClient.ConnectionBuilder connectionBuilder) throws DeploymentException, IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        ConfiguredClientEndpoint config = this.getClientEndpoint(annotatedEndpointInstance.getClass(), false);
        if (config == null) {
            throw JsrWebSocketMessages.MESSAGES.notAValidClientEndpointType(annotatedEndpointInstance.getClass());
        }
        AnnotatedEndpoint instance = config.getFactory().createInstance((InstanceHandle<?>)new ImmediateInstanceHandle(annotatedEndpointInstance));
        return this.connectToServerInternal(instance, config, connectionBuilder);
    }

    public Session connectToServer(Object annotatedEndpointInstance, URI path) throws DeploymentException, IOException {
        WebsocketClientSslProvider provider;
        if (this.closed) {
            throw new ClosedChannelException();
        }
        ConfiguredClientEndpoint config = this.getClientEndpoint(annotatedEndpointInstance.getClass(), false);
        if (config == null) {
            throw JsrWebSocketMessages.MESSAGES.notAValidClientEndpointType(annotatedEndpointInstance.getClass());
        }
        AnnotatedEndpoint instance = config.getFactory().createInstance((InstanceHandle<?>)new ImmediateInstanceHandle(annotatedEndpointInstance));
        XnioSsl ssl = null;
        Iterator<WebsocketClientSslProvider> iterator = this.clientSslProviders.iterator();
        while (iterator.hasNext() && (ssl = (provider = iterator.next()).getSsl(this.xnioWorker, annotatedEndpointInstance, path)) == null) {
        }
        if (ssl == null) {
            try {
                ssl = new UndertowXnioSsl(this.xnioWorker.getXnio(), OptionMap.EMPTY, SSLContext.getDefault());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        return this.connectToServerInternal(instance, ssl, config, path);
    }

    public Session connectToServer(Class<?> aClass, WebSocketClient.ConnectionBuilder connectionBuilder) throws DeploymentException, IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        ConfiguredClientEndpoint config = this.getClientEndpoint(aClass, true);
        if (config == null) {
            throw JsrWebSocketMessages.MESSAGES.notAValidClientEndpointType(aClass);
        }
        try {
            AnnotatedEndpointFactory factory = config.getFactory();
            InstanceHandle instance = config.getInstanceFactory().createInstance();
            return this.connectToServerInternal(factory.createInstance(instance), config, connectionBuilder);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public Session connectToServer(Class<?> aClass, URI uri) throws DeploymentException, IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        ConfiguredClientEndpoint config = this.getClientEndpoint(aClass, true);
        if (config == null) {
            throw JsrWebSocketMessages.MESSAGES.notAValidClientEndpointType(aClass);
        }
        try {
            WebsocketClientSslProvider provider;
            AnnotatedEndpointFactory factory = config.getFactory();
            InstanceHandle instance = config.getInstanceFactory().createInstance();
            XnioSsl ssl = null;
            Iterator<WebsocketClientSslProvider> iterator = this.clientSslProviders.iterator();
            while (iterator.hasNext() && (ssl = (provider = iterator.next()).getSsl(this.xnioWorker, aClass, uri)) == null) {
            }
            if (ssl == null) {
                try {
                    ssl = new UndertowXnioSsl(this.xnioWorker.getXnio(), OptionMap.EMPTY, SSLContext.getDefault());
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    // empty catch block
                }
            }
            return this.connectToServerInternal(factory.createInstance(instance), ssl, config, uri);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public Session connectToServer(Endpoint endpointInstance, ClientEndpointConfig config, URI path) throws DeploymentException, IOException {
        WebsocketClientSslProvider provider;
        if (this.closed) {
            throw new ClosedChannelException();
        }
        ClientEndpointConfig cec = config != null ? config : ClientEndpointConfig.Builder.create().build();
        XnioSsl ssl = null;
        Iterator<WebsocketClientSslProvider> iterator = this.clientSslProviders.iterator();
        while (iterator.hasNext() && (ssl = (provider = iterator.next()).getSsl(this.xnioWorker, endpointInstance, cec, path)) == null) {
        }
        if (ssl == null) {
            try {
                ssl = new UndertowXnioSsl(this.xnioWorker.getXnio(), OptionMap.EMPTY, SSLContext.getDefault());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        ClientNegotiation clientNegotiation = new ClientNegotiation(cec.getPreferredSubprotocols(), ServerWebSocketContainer.toExtensionList(cec.getExtensions()), cec);
        WebSocketClient.ConnectionBuilder connectionBuilder = WebSocketClient.connectionBuilder((XnioWorker)this.xnioWorker, (ByteBufferPool)this.bufferPool, (URI)path).setSsl(ssl).setBindAddress(this.clientBindAddress).setClientNegotiation((WebSocketClientNegotiation)clientNegotiation);
        return this.connectToServer(endpointInstance, config, connectionBuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session connectToServer(Endpoint endpointInstance, ClientEndpointConfig config, WebSocketClient.ConnectionBuilder connectionBuilder) throws DeploymentException, IOException {
        WebSocketChannel channel;
        Number timeout;
        if (this.closed) {
            throw new ClosedChannelException();
        }
        ClientEndpointConfig cec = config != null ? config : ClientEndpointConfig.Builder.create().build();
        WebSocketClientNegotiation clientNegotiation = connectionBuilder.getClientNegotiation();
        IoFuture session = connectionBuilder.connect();
        if (session.await((timeout = (Number)cec.getUserProperties().get(TIMEOUT)) == null ? 10L : (long)timeout.intValue(), TimeUnit.SECONDS) == IoFuture.Status.WAITING) {
            session.cancel();
            session.addNotifier((IoFuture.Notifier)new IoFuture.HandlingNotifier<WebSocketChannel, Object>(){

                public void handleDone(WebSocketChannel data, Object attachment) {
                    IoUtils.safeClose((Closeable)data);
                }
            }, null);
            throw JsrWebSocketMessages.MESSAGES.connectionTimedOut();
        }
        try {
            channel = (WebSocketChannel)session.get();
        }
        catch (UpgradeFailedException e) {
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
        EndpointSessionHandler sessionHandler = new EndpointSessionHandler(this);
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        HashMap<String, Extension> extMap = new HashMap<String, Extension>();
        for (Extension ext : cec.getExtensions()) {
            extMap.put(ext.getName(), ext);
        }
        for (Object e : clientNegotiation.getSelectedExtensions()) {
            Extension ext = (Extension)extMap.get(e.getName());
            if (ext == null) {
                throw JsrWebSocketMessages.MESSAGES.extensionWasNotPresentInClientHandshake(e.getName(), clientNegotiation.getSupportedExtensions());
            }
            extensions.add(ExtensionImpl.create(e));
        }
        ConfiguredClientEndpoint configured = this.clientEndpoints.get(endpointInstance.getClass());
        if (configured == null) {
            Object e;
            e = this.clientEndpoints;
            synchronized (e) {
                configured = this.clientEndpoints.get(endpointInstance.getClass());
                if (configured == null) {
                    configured = new ConfiguredClientEndpoint();
                    this.clientEndpoints.put(endpointInstance.getClass(), configured);
                }
            }
        }
        EncodingFactory encodingFactory = EncodingFactory.createFactory(this.classIntrospecter, cec.getDecoders(), cec.getEncoders());
        UndertowSession undertowSession = new UndertowSession(channel, connectionBuilder.getUri(), Collections.emptyMap(), Collections.emptyMap(), sessionHandler, null, (InstanceHandle<Endpoint>)new ImmediateInstanceHandle((Object)endpointInstance), (EndpointConfig)cec, connectionBuilder.getUri().getQuery(), encodingFactory.createEncoding((EndpointConfig)cec), configured, clientNegotiation.getSelectedSubProtocol(), extensions, connectionBuilder);
        endpointInstance.onOpen((Session)undertowSession, (EndpointConfig)cec);
        channel.resumeReceives();
        return undertowSession;
    }

    public Session connectToServer(Class<? extends Endpoint> endpointClass, ClientEndpointConfig cec, URI path) throws DeploymentException, IOException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
        try {
            Endpoint endpoint = (Endpoint)this.classIntrospecter.createInstanceFactory(endpointClass).createInstance().getInstance();
            return this.connectToServer(endpoint, cec, path);
        }
        catch (InstantiationException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public void doUpgrade(HttpServletRequest request, HttpServletResponse response, final ServerEndpointConfig sec, Map<String, String> pathParams) throws ServletException, IOException {
        ServerEndpointConfig.Configurator configurator = sec.getConfigurator();
        try {
            EncodingFactory encodingFactory = EncodingFactory.createFactory(this.classIntrospecter, sec.getDecoders(), sec.getEncoders());
            PathTemplate pt = PathTemplate.create((String)sec.getPath());
            InstanceFactory instanceFactory = null;
            try {
                instanceFactory = this.classIntrospecter.createInstanceFactory(sec.getEndpointClass());
            }
            catch (Exception e) {
                if (configurator == null || configurator.getClass() == ServerEndpointConfig.Configurator.class) {
                    throw JsrWebSocketMessages.MESSAGES.couldNotDeploy(e);
                }
                instanceFactory = new InstanceFactory<Object>(){

                    public InstanceHandle<Object> createInstance() throws InstantiationException {
                        throw JsrWebSocketMessages.MESSAGES.endpointDoesNotHaveAppropriateConstructor(sec.getEndpointClass());
                    }
                };
            }
            if (configurator == null) {
                configurator = DefaultContainerConfigurator.INSTANCE;
            }
            ServerEndpointConfig config = ServerEndpointConfig.Builder.create((Class)sec.getEndpointClass(), (String)sec.getPath()).decoders(sec.getDecoders()).encoders(sec.getEncoders()).subprotocols(sec.getSubprotocols()).extensions(sec.getExtensions()).configurator(configurator).build();
            AnnotatedEndpointFactory annotatedEndpointFactory = null;
            if (!Endpoint.class.isAssignableFrom(sec.getEndpointClass())) {
                annotatedEndpointFactory = AnnotatedEndpointFactory.create(sec.getEndpointClass(), encodingFactory, pt.getParameterNames());
            }
            ConfiguredServerEndpoint confguredServerEndpoint = annotatedEndpointFactory == null ? new ConfiguredServerEndpoint(config, instanceFactory, null, encodingFactory) : new ConfiguredServerEndpoint(config, instanceFactory, null, encodingFactory, annotatedEndpointFactory, this.installedExtensions);
            WebSocketDeploymentInfo info = (WebSocketDeploymentInfo)request.getServletContext().getAttribute("io.undertow.websockets.jsr.WebSocketDeploymentInfo");
            WebSocketHandshakeHolder hand = info == null || info.getExtensions() == null ? ServerWebSocketContainer.handshakes(confguredServerEndpoint) : ServerWebSocketContainer.handshakes(confguredServerEndpoint, info.getExtensions());
            final ServletWebSocketHttpExchange facade = new ServletWebSocketHttpExchange(request, response, new HashSet());
            Handshake handshaker = null;
            for (Handshake method : hand.handshakes) {
                if (!method.matches((WebSocketHttpExchange)facade)) continue;
                handshaker = method;
                break;
            }
            if (handshaker != null) {
                if (this.isClosed()) {
                    response.sendError(503);
                    return;
                }
                facade.putAttachment(HandshakeUtil.PATH_PARAMS, pathParams);
                final Handshake selected = handshaker;
                facade.upgradeChannel(new HttpUpgradeListener(){

                    public void handleUpgrade(StreamConnection streamConnection, HttpServerExchange exchange) {
                        WebSocketChannel channel = selected.createChannel((WebSocketHttpExchange)facade, streamConnection, facade.getBufferPool());
                        new EndpointSessionHandler(ServerWebSocketContainer.this).onConnect((WebSocketHttpExchange)facade, channel);
                    }
                });
                handshaker.handshake((WebSocketHttpExchange)facade);
                return;
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private Session connectToServerInternal(Endpoint endpointInstance, XnioSsl ssl, ConfiguredClientEndpoint cec, URI path) throws DeploymentException, IOException {
        ClientNegotiation clientNegotiation = new ClientNegotiation(cec.getConfig().getPreferredSubprotocols(), ServerWebSocketContainer.toExtensionList(cec.getConfig().getExtensions()), cec.getConfig());
        WebSocketClient.ConnectionBuilder connectionBuilder = WebSocketClient.connectionBuilder((XnioWorker)this.xnioWorker, (ByteBufferPool)this.bufferPool, (URI)path).setSsl(ssl).setBindAddress(this.clientBindAddress).setClientNegotiation((WebSocketClientNegotiation)clientNegotiation);
        return this.connectToServerInternal(endpointInstance, cec, connectionBuilder);
    }

    private Session connectToServerInternal(Endpoint endpointInstance, ConfiguredClientEndpoint cec, WebSocketClient.ConnectionBuilder connectionBuilder) throws DeploymentException, IOException {
        WebSocketChannel channel;
        Number timeout;
        IoFuture session = connectionBuilder.connect();
        IoFuture.Status result = session.await((timeout = (Number)cec.getConfig().getUserProperties().get(TIMEOUT)) == null ? 10L : (long)timeout.intValue(), TimeUnit.SECONDS);
        if (result == IoFuture.Status.WAITING) {
            session.cancel();
            session.addNotifier((IoFuture.Notifier)new IoFuture.HandlingNotifier<WebSocketChannel, Object>(){

                public void handleDone(WebSocketChannel data, Object attachment) {
                    IoUtils.safeClose((Closeable)data);
                }
            }, null);
            throw JsrWebSocketMessages.MESSAGES.connectionTimedOut();
        }
        try {
            channel = (WebSocketChannel)session.get();
        }
        catch (UpgradeFailedException e) {
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
        EndpointSessionHandler sessionHandler = new EndpointSessionHandler(this);
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        HashMap<String, Extension> extMap = new HashMap<String, Extension>();
        for (Object ext : cec.getConfig().getExtensions()) {
            extMap.put(ext.getName(), (Extension)ext);
        }
        String subProtocol = null;
        if (connectionBuilder.getClientNegotiation() != null) {
            for (WebSocketExtension e : connectionBuilder.getClientNegotiation().getSelectedExtensions()) {
                Extension ext = (Extension)extMap.get(e.getName());
                if (ext == null) {
                    throw JsrWebSocketMessages.MESSAGES.extensionWasNotPresentInClientHandshake(e.getName(), connectionBuilder.getClientNegotiation().getSupportedExtensions());
                }
                extensions.add(ExtensionImpl.create(e));
            }
            subProtocol = connectionBuilder.getClientNegotiation().getSelectedSubProtocol();
        }
        UndertowSession undertowSession = new UndertowSession(channel, connectionBuilder.getUri(), Collections.emptyMap(), Collections.emptyMap(), sessionHandler, null, (InstanceHandle<Endpoint>)new ImmediateInstanceHandle((Object)endpointInstance), (EndpointConfig)cec.getConfig(), connectionBuilder.getUri().getQuery(), cec.getEncodingFactory().createEncoding((EndpointConfig)cec.getConfig()), cec, subProtocol, extensions, connectionBuilder);
        endpointInstance.onOpen((Session)undertowSession, (EndpointConfig)cec.getConfig());
        channel.resumeReceives();
        return undertowSession;
    }

    public long getDefaultMaxSessionIdleTimeout() {
        return this.defaultMaxSessionIdleTimeout;
    }

    public void setDefaultMaxSessionIdleTimeout(long timeout) {
        this.defaultMaxSessionIdleTimeout = timeout;
    }

    public int getDefaultMaxBinaryMessageBufferSize() {
        return this.defaultMaxBinaryMessageBufferSize;
    }

    public void setDefaultMaxBinaryMessageBufferSize(int defaultMaxBinaryMessageBufferSize) {
        this.defaultMaxBinaryMessageBufferSize = defaultMaxBinaryMessageBufferSize;
    }

    public int getDefaultMaxTextMessageBufferSize() {
        return this.defaultMaxTextMessageBufferSize;
    }

    public void setDefaultMaxTextMessageBufferSize(int defaultMaxTextMessageBufferSize) {
        this.defaultMaxTextMessageBufferSize = defaultMaxTextMessageBufferSize;
    }

    public Set<Extension> getInstalledExtensions() {
        return new HashSet<Extension>(this.installedExtensions);
    }

    public void invokeEndpointMethod(Executor executor, final Runnable invocation) {
        if (this.dispatchToWorker) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    ServerWebSocketContainer.this.invokeEndpointMethod(invocation);
                }
            });
        } else {
            this.invokeEndpointMethod(invocation);
        }
    }

    public void invokeEndpointMethod(Runnable invocation) {
        try {
            this.invokeEndpointTask.call(null, (Object)invocation);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addEndpoint(Class<?> endpoint) throws DeploymentException {
        if (this.deploymentComplete) {
            throw JsrWebSocketMessages.MESSAGES.cannotAddEndpointAfterDeployment();
        }
        if (this.annotatedEndpointClasses.contains(endpoint)) {
            return;
        }
        this.annotatedEndpointClasses.add(endpoint);
        try {
            this.addEndpointInternal(endpoint, true);
        }
        catch (DeploymentException e) {
            this.deploymentExceptions.add(e);
            throw e;
        }
    }

    private synchronized void addEndpointInternal(final Class<?> endpoint, boolean requiresCreation) throws DeploymentException {
        ServerEndpoint serverEndpoint = endpoint.getAnnotation(ServerEndpoint.class);
        ClientEndpoint clientEndpoint = endpoint.getAnnotation(ClientEndpoint.class);
        if (serverEndpoint != null) {
            DefaultContainerConfigurator configurator;
            JsrWebSocketLogger.ROOT_LOGGER.addingAnnotatedServerEndpoint(endpoint, serverEndpoint.value());
            PathTemplate template = PathTemplate.create((String)serverEndpoint.value());
            if (this.seenPaths.contains(template)) {
                PathTemplate existing = null;
                for (PathTemplate p : this.seenPaths) {
                    if (p.compareTo(template) != 0) continue;
                    existing = p;
                    break;
                }
                throw JsrWebSocketMessages.MESSAGES.multipleEndpointsWithOverlappingPaths(template, existing);
            }
            this.seenPaths.add(template);
            Class configuratorClass = serverEndpoint.configurator();
            EncodingFactory encodingFactory = EncodingFactory.createFactory(this.classIntrospecter, serverEndpoint.decoders(), serverEndpoint.encoders());
            AnnotatedEndpointFactory annotatedEndpointFactory = AnnotatedEndpointFactory.create(endpoint, encodingFactory, template.getParameterNames());
            InstanceFactory instanceFactory = null;
            try {
                instanceFactory = this.classIntrospecter.createInstanceFactory(endpoint);
            }
            catch (Exception e) {
                if (configuratorClass == ServerEndpointConfig.Configurator.class) {
                    throw JsrWebSocketMessages.MESSAGES.couldNotDeploy(e);
                }
                instanceFactory = new InstanceFactory<Object>(){

                    public InstanceHandle<Object> createInstance() throws InstantiationException {
                        throw JsrWebSocketMessages.MESSAGES.endpointDoesNotHaveAppropriateConstructor(endpoint);
                    }
                };
            }
            if (configuratorClass != ServerEndpointConfig.Configurator.class) {
                try {
                    configurator = (ServerEndpointConfig.Configurator)this.classIntrospecter.createInstanceFactory(configuratorClass).createInstance().getInstance();
                }
                catch (InstantiationException | NoSuchMethodException e) {
                    throw JsrWebSocketMessages.MESSAGES.couldNotDeploy(e);
                }
            } else {
                configurator = DefaultContainerConfigurator.INSTANCE;
            }
            ServerEndpointConfig config = ServerEndpointConfig.Builder.create(endpoint, (String)serverEndpoint.value()).decoders(Arrays.asList(serverEndpoint.decoders())).encoders(Arrays.asList(serverEndpoint.encoders())).subprotocols(Arrays.asList(serverEndpoint.subprotocols())).extensions(Collections.emptyList()).configurator((ServerEndpointConfig.Configurator)configurator).build();
            ConfiguredServerEndpoint confguredServerEndpoint = new ConfiguredServerEndpoint(config, instanceFactory, template, encodingFactory, annotatedEndpointFactory, this.installedExtensions);
            this.configuredServerEndpoints.add(confguredServerEndpoint);
            this.handleAddingFilterMapping();
        } else if (clientEndpoint != null) {
            InstanceFactory instanceFactory;
            JsrWebSocketLogger.ROOT_LOGGER.addingAnnotatedClientEndpoint(endpoint);
            EncodingFactory encodingFactory = EncodingFactory.createFactory(this.classIntrospecter, clientEndpoint.decoders(), clientEndpoint.encoders());
            try {
                instanceFactory = this.classIntrospecter.createInstanceFactory(endpoint);
            }
            catch (Exception e) {
                try {
                    instanceFactory = new ConstructorInstanceFactory(endpoint.getConstructor(new Class[0]));
                }
                catch (NoSuchMethodException e1) {
                    if (requiresCreation) {
                        throw JsrWebSocketMessages.MESSAGES.couldNotDeploy(e);
                    }
                    instanceFactory = new InstanceFactory<Object>(){

                        public InstanceHandle<Object> createInstance() throws InstantiationException {
                            throw new InstantiationException();
                        }
                    };
                }
            }
            AnnotatedEndpointFactory factory = AnnotatedEndpointFactory.create(endpoint, encodingFactory, Collections.emptySet());
            ClientEndpointConfig.Configurator configurator = null;
            try {
                configurator = (ClientEndpointConfig.Configurator)this.classIntrospecter.createInstanceFactory(clientEndpoint.configurator()).createInstance().getInstance();
            }
            catch (InstantiationException | NoSuchMethodException e) {
                throw JsrWebSocketMessages.MESSAGES.couldNotDeploy(e);
            }
            ClientEndpointConfig config = ClientEndpointConfig.Builder.create().decoders(Arrays.asList(clientEndpoint.decoders())).encoders(Arrays.asList(clientEndpoint.encoders())).preferredSubprotocols(Arrays.asList(clientEndpoint.subprotocols())).configurator(configurator).build();
            ConfiguredClientEndpoint configuredClientEndpoint = new ConfiguredClientEndpoint(config, factory, encodingFactory, instanceFactory);
            this.clientEndpoints.put(endpoint, configuredClientEndpoint);
        } else {
            throw JsrWebSocketMessages.MESSAGES.classWasNotAnnotated(endpoint);
        }
    }

    private void handleAddingFilterMapping() {
        if (this.contextToAddFilter != null) {
            this.contextToAddFilter.getDeployment().getDeploymentInfo().addFilterUrlMapping("Undertow Web Socket Filter", "/*", DispatcherType.REQUEST);
            this.contextToAddFilter.getDeployment().getServletPaths().invalidate();
            this.contextToAddFilter = null;
        }
    }

    public void addEndpoint(ServerEndpointConfig endpoint) throws DeploymentException {
        if (this.deploymentComplete) {
            throw JsrWebSocketMessages.MESSAGES.cannotAddEndpointAfterDeployment();
        }
        JsrWebSocketLogger.ROOT_LOGGER.addingProgramaticEndpoint(endpoint.getEndpointClass(), endpoint.getPath());
        PathTemplate template = PathTemplate.create((String)endpoint.getPath());
        if (this.seenPaths.contains(template)) {
            PathTemplate existing = null;
            for (PathTemplate p : this.seenPaths) {
                if (p.compareTo(template) != 0) continue;
                existing = p;
                break;
            }
            throw JsrWebSocketMessages.MESSAGES.multipleEndpointsWithOverlappingPaths(template, existing);
        }
        this.seenPaths.add(template);
        EncodingFactory encodingFactory = EncodingFactory.createFactory(this.classIntrospecter, endpoint.getDecoders(), endpoint.getEncoders());
        ConfiguredServerEndpoint confguredServerEndpoint = new ConfiguredServerEndpoint(endpoint, null, template, encodingFactory);
        this.configuredServerEndpoints.add(confguredServerEndpoint);
        this.handleAddingFilterMapping();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfiguredClientEndpoint getClientEndpoint(Class<?> endpointType, boolean requiresCreation) {
        Class<?> type;
        for (type = endpointType; type != Object.class && type != null && !type.isAnnotationPresent(ClientEndpoint.class); type = type.getSuperclass()) {
        }
        if (type == Object.class || type == null) {
            return null;
        }
        ConfiguredClientEndpoint existing = this.clientEndpoints.get(type);
        if (existing != null) {
            return existing;
        }
        ServerWebSocketContainer serverWebSocketContainer = this;
        synchronized (serverWebSocketContainer) {
            existing = this.clientEndpoints.get(type);
            if (existing != null) {
                return existing;
            }
            if (type.isAnnotationPresent(ClientEndpoint.class)) {
                try {
                    this.addEndpointInternal(type, requiresCreation);
                    return this.clientEndpoints.get(type);
                }
                catch (DeploymentException e) {
                    throw new RuntimeException(e);
                }
            }
            return null;
        }
    }

    public void validateDeployment() {
        if (!this.deploymentExceptions.isEmpty()) {
            RuntimeException e = JsrWebSocketMessages.MESSAGES.deploymentFailedDueToProgramaticErrors();
            for (DeploymentException ex : this.deploymentExceptions) {
                e.addSuppressed(ex);
            }
            throw e;
        }
    }

    public void deploymentComplete() {
        this.deploymentComplete = true;
        this.validateDeployment();
    }

    public List<ConfiguredServerEndpoint> getConfiguredServerEndpoints() {
        return this.configuredServerEndpoints;
    }

    public ServletContextImpl getContextToAddFilter() {
        return this.contextToAddFilter;
    }

    public void setContextToAddFilter(ServletContextImpl contextToAddFilter) {
        this.contextToAddFilter = contextToAddFilter;
    }

    public synchronized void close(int waitTime) {
        this.doClose();
        long end = System.currentTimeMillis() + (long)waitTime;
        for (ConfiguredServerEndpoint endpoint : this.configuredServerEndpoints) {
            endpoint.awaitClose(end - System.currentTimeMillis());
        }
    }

    @Override
    public synchronized void close() {
        this.close(10000);
    }

    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    public XnioWorker getXnioWorker() {
        return this.xnioWorker;
    }

    private static List<WebSocketExtension> toExtensionList(List<Extension> extensions) {
        ArrayList<WebSocketExtension> ret = new ArrayList<WebSocketExtension>();
        for (Extension e : extensions) {
            ArrayList<WebSocketExtension.Parameter> parameters = new ArrayList<WebSocketExtension.Parameter>();
            for (Extension.Parameter p : e.getParameters()) {
                parameters.add(new WebSocketExtension.Parameter(p.getName(), p.getValue()));
            }
            ret.add(new WebSocketExtension(e.getName(), parameters));
        }
        return ret;
    }

    public synchronized void pause(PauseListener listener) {
        this.closed = true;
        if (this.configuredServerEndpoints.isEmpty()) {
            listener.paused();
            return;
        }
        if (listener != null) {
            this.pauseListeners.add(listener);
        }
        for (ConfiguredServerEndpoint endpoint : this.configuredServerEndpoints) {
            for (final Session session : endpoint.getOpenSessions()) {
                ((UndertowSession)session).getExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.GOING_AWAY, ""));
                        }
                        catch (Exception e) {
                            JsrWebSocketLogger.ROOT_LOGGER.couldNotCloseOnUndeploy(e);
                        }
                    }
                });
            }
        }
        Runnable done = new Runnable(){
            int count;
            {
                this.count = ServerWebSocketContainer.this.configuredServerEndpoints.size();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized void run() {
                ArrayList copy = null;
                ServerWebSocketContainer serverWebSocketContainer = ServerWebSocketContainer.this;
                synchronized (serverWebSocketContainer) {
                    --this.count;
                    if (this.count == 0) {
                        copy = new ArrayList(ServerWebSocketContainer.this.pauseListeners);
                        ServerWebSocketContainer.this.pauseListeners.clear();
                    }
                }
                if (copy != null) {
                    for (PauseListener p : copy) {
                        p.paused();
                    }
                }
            }
        };
        for (ConfiguredServerEndpoint endpoint : this.configuredServerEndpoints) {
            endpoint.notifyClosed(done);
        }
    }

    private void doClose() {
        this.closed = true;
        for (ConfiguredServerEndpoint endpoint : this.configuredServerEndpoints) {
            for (Session session : endpoint.getOpenSessions()) {
                try {
                    session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.GOING_AWAY, ""));
                }
                catch (Exception e) {
                    JsrWebSocketLogger.ROOT_LOGGER.couldNotCloseOnUndeploy(e);
                }
            }
        }
    }

    static WebSocketHandshakeHolder handshakes(ConfiguredServerEndpoint config) {
        ArrayList<Object> handshakes = new ArrayList<Object>();
        handshakes.add((Object)new JsrHybi13Handshake(config));
        handshakes.add((Object)new JsrHybi08Handshake(config));
        handshakes.add((Object)new JsrHybi07Handshake(config));
        return new WebSocketHandshakeHolder(handshakes, config);
    }

    static WebSocketHandshakeHolder handshakes(ConfiguredServerEndpoint config, List<ExtensionHandshake> extensions) {
        ArrayList<Object> handshakes = new ArrayList<Object>();
        JsrHybi13Handshake jsrHybi13Handshake = new JsrHybi13Handshake(config);
        JsrHybi08Handshake jsrHybi08Handshake = new JsrHybi08Handshake(config);
        JsrHybi07Handshake jsrHybi07Handshake = new JsrHybi07Handshake(config);
        for (ExtensionHandshake extension : extensions) {
            jsrHybi13Handshake.addExtension(extension);
            jsrHybi08Handshake.addExtension(extension);
            jsrHybi07Handshake.addExtension(extension);
        }
        handshakes.add((Object)jsrHybi13Handshake);
        handshakes.add((Object)jsrHybi08Handshake);
        handshakes.add((Object)jsrHybi07Handshake);
        return new WebSocketHandshakeHolder(handshakes, config);
    }

    public synchronized void resume() {
        this.closed = false;
        for (PauseListener p : this.pauseListeners) {
            p.resumed();
        }
        this.pauseListeners.clear();
    }

    public WebSocketReconnectHandler getWebSocketReconnectHandler() {
        return this.webSocketReconnectHandler;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isDispatchToWorker() {
        return this.dispatchToWorker;
    }

    public static interface PauseListener {
        public void paused();

        public void resumed();
    }

    static final class WebSocketHandshakeHolder {
        final List<Handshake> handshakes;
        final ConfiguredServerEndpoint endpoint;

        private WebSocketHandshakeHolder(List<Handshake> handshakes, ConfiguredServerEndpoint endpoint) {
            this.handshakes = handshakes;
            this.endpoint = endpoint;
        }
    }

    private static class ClientNegotiation
    extends WebSocketClientNegotiation {
        private final ClientEndpointConfig config;

        ClientNegotiation(List<String> supportedSubProtocols, List<WebSocketExtension> supportedExtensions, ClientEndpointConfig config) {
            super(supportedSubProtocols, supportedExtensions);
            this.config = config;
        }

        public void afterRequest(Map<String, List<String>> headers) {
            ClientEndpointConfig.Configurator configurator = this.config.getConfigurator();
            if (configurator != null) {
                final TreeMap newHeaders = new TreeMap(String.CASE_INSENSITIVE_ORDER);
                for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                    ArrayList arrayList = new ArrayList();
                    arrayList.addAll(entry.getValue());
                    newHeaders.put(entry.getKey(), arrayList);
                }
                configurator.afterResponse(new HandshakeResponse(){

                    public Map<String, List<String>> getHeaders() {
                        return newHeaders;
                    }
                });
            }
        }

        public void beforeRequest(Map<String, List<String>> headers) {
            ClientEndpointConfig.Configurator configurator = this.config.getConfigurator();
            if (configurator != null) {
                HashMap newHeaders = new HashMap();
                for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                    ArrayList arrayList = new ArrayList();
                    arrayList.addAll(entry.getValue());
                    newHeaders.put(entry.getKey(), arrayList);
                }
                configurator.beforeRequest(newHeaders);
                headers.clear();
                for (Map.Entry<String, List<String>> entry : newHeaders.entrySet()) {
                    if (entry.getValue().isEmpty()) continue;
                    headers.put(entry.getKey(), entry.getValue());
                }
            }
        }
    }
}

