package io.undertow.websockets.jsr;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import java.util.Set;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.String;
import io.undertow.util.PathTemplate;
import java.lang.Exception;
import java.lang.NoSuchMethodException;
import java.lang.RuntimeException;
import io.undertow.websockets.jsr.FrameHandler.FrameType;
import jakarta.websocket.DeploymentException;
import java.lang.Class;
import java.util.List;
import java.lang.Object;
import java.util.Arrays;
import java.lang.IllegalArgumentException;
import java.lang.InstantiationException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageBundleImplementor", date = "2024-02-21T04:12:30-0300")
public class JsrWebSocketMessages_$bundle implements JsrWebSocketMessages, Serializable {
    private static final long serialVersionUID = 1L;
    protected JsrWebSocketMessages_$bundle() {}
    public static final JsrWebSocketMessages_$bundle INSTANCE = new JsrWebSocketMessages_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String pongMessageNotSupported$str() {
        return "UT003001: PongMessage not supported with MessageHandler.Async";
    }
    @Override
    public final IllegalStateException pongMessageNotSupported() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), pongMessageNotSupported$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String sendStreamClosed$str() {
        return "UT003002: SendStream is closed";
    }
    @Override
    public final IOException sendStreamClosed() {
        final IOException result = new IOException(String.format(getLoggingLocale(), sendStreamClosed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String sendWriterClosed$str() {
        return "UT003003: SendWriter is closed";
    }
    @Override
    public final IOException sendWriterClosed() {
        final IOException result = new IOException(String.format(getLoggingLocale(), sendWriterClosed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String clientNotSupported$str() {
        return "UT003004: Client not supported";
    }
    @Override
    public final DeploymentException clientNotSupported() {
        final DeploymentException result = new DeploymentException(String.format(getLoggingLocale(), clientNotSupported$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String handlerAlreadyRegistered$str() {
        return "UT003005: MessageHandler for type %s already registered";
    }
    @Override
    public final IllegalStateException handlerAlreadyRegistered(final FrameType frameType) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), handlerAlreadyRegistered$str(), frameType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unsupportedFrameType$str() {
        return "UT003006: Unable to detect FrameType for clazz %s";
    }
    @Override
    public final IllegalStateException unsupportedFrameType(final Class<?> clazz) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unsupportedFrameType$str(), clazz));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownHandlerType$str() {
        return "UT003007: Unable to detect MessageHandler type for %s";
    }
    @Override
    public final IllegalStateException unknownHandlerType(final Class<?> clazz) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unknownHandlerType$str(), clazz));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownEncoderType$str() {
        return "UT003008: Unable to detect Encoder type for %s";
    }
    @Override
    public final IllegalStateException unknownEncoderType(final Class<?> clazz) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unknownEncoderType$str(), clazz));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String moreThanOneParameterOfType$str() {
        return "UT003009: More than one %s parameter for %s";
    }
    @Override
    public final IllegalArgumentException moreThanOneParameterOfType(final Class<?> type, final Method method) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), moreThanOneParameterOfType$str(), type, method));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String parameterNotFound$str() {
        return "UT003010: No parameter of type %s found in method %s";
    }
    @Override
    public final IllegalArgumentException parameterNotFound(final Class<?> type, final Method method) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), parameterNotFound$str(), type, method));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String moreThanOneAnnotation$str() {
        return "UT003011: More than one method is annotated with %s";
    }
    @Override
    public final DeploymentException moreThanOneAnnotation(final Class<?> clazz) {
        final DeploymentException result = new DeploymentException(String.format(getLoggingLocale(), moreThanOneAnnotation$str(), clazz));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidParameters$str() {
        return "UT003012: Method %s has invalid parameters at locations %s";
    }
    @Override
    public final DeploymentException invalidParameters(final Method method, final Set<Integer> allParams) {
        final DeploymentException result = new DeploymentException(String.format(getLoggingLocale(), invalidParameters$str(), method, allParams));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String couldNotDetermineDecoderTypeFor$str() {
        return "UT003014: Could not determine decoder type for %s";
    }
    @Override
    public final IllegalArgumentException couldNotDetermineDecoderTypeFor(final Class<?> decoderClass) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), couldNotDetermineDecoderTypeFor$str(), decoderClass));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noDecoderAcceptedMessage$str() {
        return "UT003015: No decoder accepted message %s";
    }
    @Override
    public final String noDecoderAcceptedMessage(final List<? extends jakarta.websocket.Decoder> decoders) {
        return String.format(getLoggingLocale(), noDecoderAcceptedMessage$str(), decoders);
    }
    protected String cannotSendInMiddleOfFragmentedMessage$str() {
        return "UT003016: Cannot send in middle of fragmeneted message";
    }
    @Override
    public final IllegalStateException cannotSendInMiddleOfFragmentedMessage() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotSendInMiddleOfFragmentedMessage$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotAddEndpointAfterDeployment$str() {
        return "UT003017: Cannot add endpoint after deployment";
    }
    @Override
    public final IllegalStateException cannotAddEndpointAfterDeployment() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotAddEndpointAfterDeployment$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String couldNotDetermineTypeOfDecodeMethodForClass$str() {
        return "UT003018: Could not determine type of decode method for class %s";
    }
    @Override
    public final DeploymentException couldNotDetermineTypeOfDecodeMethodForClass(final Class<? extends jakarta.websocket.Decoder> decoder, final Exception e) {
        final DeploymentException result = new DeploymentException(String.format(getLoggingLocale(), couldNotDetermineTypeOfDecodeMethodForClass$str(), decoder), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String couldNotDetermineTypeOfEncodeMethodForClass$str() {
        return "UT003019: Could not determine type of encode method for class %s";
    }
    @Override
    public final DeploymentException couldNotDetermineTypeOfEncodeMethodForClass(final Class<? extends jakarta.websocket.Encoder> encoder) {
        final DeploymentException result = new DeploymentException(String.format(getLoggingLocale(), couldNotDetermineTypeOfEncodeMethodForClass$str(), encoder));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String didNotImplementKnownDecoderSubclass$str() {
        return "UT003020: %s did not implement known decoder interface";
    }
    @Override
    public final DeploymentException didNotImplementKnownDecoderSubclass(final Class<? extends jakarta.websocket.Decoder> decoder) {
        final DeploymentException result = new DeploymentException(String.format(getLoggingLocale(), didNotImplementKnownDecoderSubclass$str(), decoder));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String classDoesNotHaveDefaultConstructor$str() {
        return "UT003021: %s does not have default constructor";
    }
    @Override
    public final DeploymentException classDoesNotHaveDefaultConstructor(final Class<?> c, final NoSuchMethodException e) {
        final DeploymentException result = new DeploymentException(String.format(getLoggingLocale(), classDoesNotHaveDefaultConstructor$str(), c), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multipleEndpointsWithOverlappingPaths$str() {
        return "UT003023: Multiple endpoints with the same logical mapping %s and %s";
    }
    @Override
    public final DeploymentException multipleEndpointsWithOverlappingPaths(final PathTemplate template, final PathTemplate existing) {
        final DeploymentException result = new DeploymentException(String.format(getLoggingLocale(), multipleEndpointsWithOverlappingPaths$str(), template, existing));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String couldNotDeploy$str() {
        return "UT003024: Web socket deployment failed";
    }
    @Override
    public final DeploymentException couldNotDeploy(final Exception e) {
        final DeploymentException result = new DeploymentException(String.format(getLoggingLocale(), couldNotDeploy$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotConnectUntilDeploymentComplete$str() {
        return "UT003025: Cannot connect until deployment is complete";
    }
    @Override
    public final IllegalStateException cannotConnectUntilDeploymentComplete() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotConnectUntilDeploymentComplete$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notAValidClientEndpointType$str() {
        return "UT003026: %s is not a valid client endpoint type";
    }
    @Override
    public final DeploymentException notAValidClientEndpointType(final Class<?> type) {
        final DeploymentException result = new DeploymentException(String.format(getLoggingLocale(), notAValidClientEndpointType$str(), type));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String classWasNotAnnotated$str() {
        return "UT003027: Class %s was not annotated with @ClientEndpoint or @ServerEndpoint";
    }
    @Override
    public final DeploymentException classWasNotAnnotated(final Class<?> endpoint) {
        final DeploymentException result = new DeploymentException(String.format(getLoggingLocale(), classWasNotAnnotated$str(), endpoint));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String couldNotFindDecoderForType$str() {
        return "UT003028: Could not find decoder for type %s on method %s";
    }
    @Override
    public final DeploymentException couldNotFindDecoderForType(final Class<?> param, final Method method) {
        final DeploymentException result = new DeploymentException(String.format(getLoggingLocale(), couldNotFindDecoderForType$str(), param, method));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String couldNotFindMessageParameter$str() {
        return "UT003029: Could not find message parameter on method %s";
    }
    @Override
    public final DeploymentException couldNotFindMessageParameter(final Method method) {
        final DeploymentException result = new DeploymentException(String.format(getLoggingLocale(), couldNotFindMessageParameter$str(), method));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String receivedTextFrameButNoMethod$str() {
        return "UT003030: Received a text frame however endpoint does not have a method capable of handling it";
    }
    @Override
    public final RuntimeException receivedTextFrameButNoMethod() {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), receivedTextFrameButNoMethod$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String receivedBinaryFrameButNoMethod$str() {
        return "UT003031: Received a binary frame however endpoint does not have a method capable of handling it";
    }
    @Override
    public final RuntimeException receivedBinaryFrameButNoMethod() {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), receivedBinaryFrameButNoMethod$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidParametersWithWrongAnnotation$str() {
        return "UT003033: Method %s has invalid parameters at locations %s. It looks like you may have accidentally used jakarta.ws.rs.PathParam instead of jakarta.websocket.server.PathParam";
    }
    @Override
    public final DeploymentException invalidParametersWithWrongAnnotation(final Method method, final Set<Integer> allParams) {
        final DeploymentException result = new DeploymentException(String.format(getLoggingLocale(), invalidParametersWithWrongAnnotation$str(), method, allParams));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String extensionWasNotPresentInClientHandshake$str() {
        return "UT003034: Server provided extension %s which was not in client supported extensions %s";
    }
    @Override
    public final IOException extensionWasNotPresentInClientHandshake(final String e, final List<io.undertow.websockets.WebSocketExtension> supportedExtensions) {
        final IOException result = new IOException(String.format(getLoggingLocale(), extensionWasNotPresentInClientHandshake$str(), e, supportedExtensions));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String connectionTimedOut$str() {
        return "UT003035: Connection timed out";
    }
    @Override
    public final IOException connectionTimedOut() {
        final IOException result = new IOException(String.format(getLoggingLocale(), connectionTimedOut$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String handlerIsNull$str() {
        return "UT003036: SendHandler is null";
    }
    @Override
    public final IllegalArgumentException handlerIsNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), handlerIsNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String messageInNull$str() {
        return "UT003037: Message is null";
    }
    @Override
    public final IllegalArgumentException messageInNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), messageInNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String messageTooLarge$str() {
        return "UT003038: Message of size %s was larger than the maximum of %s";
    }
    @Override
    public final IllegalArgumentException messageTooLarge(final int size, final int max) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), messageTooLarge$str(), size, max));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotInstantiateEndpoint$str() {
        return "UT003039: The container cannot find a suitable constructor to instantiate endpoint of type %s";
    }
    @Override
    public final InstantiationException cannotInstantiateEndpoint(final Class<?> c) {
        final InstantiationException result = new InstantiationException(String.format(getLoggingLocale(), cannotInstantiateEndpoint$str(), c));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String endpointNotOfCorrectType$str() {
        return "UT003040: Annotated endpoint instance %s was not of correct type %s";
    }
    @Override
    public final IllegalArgumentException endpointNotOfCorrectType(final Object instance, final Class expected) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), endpointNotOfCorrectType$str(), instance, expected));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String endpointDoesNotHaveAppropriateConstructor$str() {
        return "UT003041: Annotated endpoint %s does not have a no arg constructor, but is using a custom configurator. The custom configurator must create the instance.";
    }
    @Override
    public final InstantiationException endpointDoesNotHaveAppropriateConstructor(final Class<?> endpoint) {
        final InstantiationException result = new InstantiationException(String.format(getLoggingLocale(), endpointDoesNotHaveAppropriateConstructor$str(), endpoint));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String deploymentFailedDueToProgramaticErrors$str() {
        return "UT003042: Deployment failed due to invalid programmatically added endpoints";
    }
    @Override
    public final RuntimeException deploymentFailedDueToProgramaticErrors() {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), deploymentFailedDueToProgramaticErrors$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
