/*
 * Decompiled with CFR 0.152.
 */
package com.telcordia.rmi;

import com.telcordia.MessageQueue;
import com.telcordia.rmi.RMIStackServer;
import com.telcordia.rmi.RMIStackServerImpl;
import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpEvent;
import java.rmi.Naming;
import java.rmi.NoSuchObjectException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;

public class RMIStackClientThread
extends Thread {
    private RMIStackServerImpl _localRMIStackServer = null;
    private MessageQueue _mq = null;

    public RMIStackClientThread(RMIStackServerImpl rMIStackServerImpl, MessageQueue messageQueue) {
        this._localRMIStackServer = rMIStackServerImpl;
        this._mq = messageQueue;
        this.setPriority(1);
        System.out.println("Instantiated RMIStackClientThread");
    }

    public void run() {
        JainMgcpEvent jainMgcpEvent = null;
        RMIStackServer rMIStackServer = null;
        Hashtable<String, RMIStackServer> hashtable = new Hashtable<String, RMIStackServer>();
        block12: while (true) {
            this._mq.waitForSignal();
            jainMgcpEvent = this._mq.dequeue();
            boolean bl = false;
            if (jainMgcpEvent instanceof JainMgcpCommandEvent) {
                bl = true;
            }
            String string = null;
            string = bl ? ((JainMgcpCommandEvent)jainMgcpEvent).getEndpointIdentifier().getDomainName() : this._localRMIStackServer.getDomainName(jainMgcpEvent.getTransactionHandle());
            if (string == null) {
                System.err.println("Can't determine destination address for message with transaction ID " + jainMgcpEvent.getTransactionHandle() + "; message will be ignored");
                break;
            }
            rMIStackServer = (RMIStackServer)hashtable.get(string);
            if (rMIStackServer == null) {
                String string2 = "rmi://" + string + "/RMIStackServer";
                boolean bl2 = false;
                int n = 1;
                while (n <= 10) {
                    try {
                        rMIStackServer = (RMIStackServer)Naming.lookup(string2);
                        bl2 = true;
                        break;
                    }
                    catch (Exception exception) {
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            System.exit(1);
                        }
                        ++n;
                    }
                }
                if (!bl2) {
                    System.err.println("Couldn't bind to remote server object");
                    try {
                        Naming.unbind("RMIStackServer");
                        System.err.println("Successfully unbound local RMI Stack Server from registry.");
                    }
                    catch (Exception exception) {
                        System.err.println("Problem unbinding local RMI Stack Server from registry. " + exception.getMessage());
                    }
                    try {
                        if (UnicastRemoteObject.unexportObject(this._localRMIStackServer, true)) {
                            System.err.println("Unexported local RMI Stack Server successfully.");
                        } else {
                            System.err.println("Couldn't unexport local RMI Stack Server.");
                        }
                    }
                    catch (NoSuchObjectException noSuchObjectException) {
                        System.err.println(noSuchObjectException.getMessage());
                    }
                    System.exit(1);
                } else {
                    hashtable.put(string, rMIStackServer);
                }
            }
            boolean bl3 = false;
            while (true) {
                if (bl3) continue block12;
                try {
                    rMIStackServer.sendRequest(jainMgcpEvent);
                    bl3 = true;
                }
                catch (Exception exception) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        System.exit(1);
                    }
                }
            }
            break;
        }
    }
}

