/*
 * Decompiled with CFR 0.152.
 */
package com.telcordia.rmi;

import com.telcordia.rmi.RMIStackServer;
import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.JainMgcpListener;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import java.rmi.RemoteException;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;

public class RMIStackServerImpl
extends UnicastRemoteObject
implements RMIStackServer {
    private JainMgcpListener _jainMgcpListener = null;
    private Hashtable tranID_to_domainName = new Hashtable();

    public RMIStackServerImpl(int n) throws RemoteException {
        super(n);
    }

    public void setJainMgcpListener(JainMgcpListener jainMgcpListener) {
        this._jainMgcpListener = jainMgcpListener;
    }

    public void removeJainMgcpListener() {
        this._jainMgcpListener = null;
    }

    public void sendRequest(JainMgcpEvent jainMgcpEvent) throws RemoteException {
        if (this._jainMgcpListener == null) {
            throw new RemoteException("No Jain Mgcp Listener registered!");
        }
        if (jainMgcpEvent instanceof JainMgcpCommandEvent) {
            String string = null;
            try {
                string = RemoteServer.getClientHost();
            }
            catch (ServerNotActiveException serverNotActiveException) {
                System.err.println(serverNotActiveException.getMessage());
                System.exit(1);
            }
            this.tranID_to_domainName.put(new Integer(jainMgcpEvent.getTransactionHandle()), string);
            this._jainMgcpListener.processMgcpCommandEvent((JainMgcpCommandEvent)jainMgcpEvent);
        } else {
            this._jainMgcpListener.processMgcpResponseEvent((JainMgcpResponseEvent)jainMgcpEvent);
        }
    }

    public String getDomainName(int n) {
        Integer n2 = new Integer(n);
        String string = (String)this.tranID_to_domainName.get(n2);
        this.tranID_to_domainName.remove(n2);
        return string;
    }
}

