/*
 * Decompiled with CFR 0.152.
 */
package jain.protocol.ip.mgcp.message;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.EventName;
import jain.protocol.ip.mgcp.message.parms.NotifiedEntity;
import jain.protocol.ip.mgcp.message.parms.RequestIdentifier;

public final class Notify
extends JainMgcpCommandEvent {
    private NotifiedEntity notifiedEntity = null;
    private EventName[] observedEvents = null;
    private RequestIdentifier requestIdentifier = null;

    public Notify(Object source, EndpointIdentifier endpointIdentifier, RequestIdentifier requestIdentifier, EventName[] observedEvents) throws IllegalArgumentException {
        super(source, endpointIdentifier, 108);
        this.setRequestIdentifier(requestIdentifier);
        this.setObservedEvents(observedEvents);
    }

    public void setNotifiedEntity(NotifiedEntity notifiedEntity) {
        this.notifiedEntity = notifiedEntity;
    }

    public void setRequestIdentifier(RequestIdentifier requestIdentifier) throws IllegalArgumentException {
        if (requestIdentifier == null) {
            throw new IllegalArgumentException("Request identifier cannot be null-valued!");
        }
        this.requestIdentifier = requestIdentifier;
    }

    public void setObservedEvents(EventName[] observedEvents) throws IllegalArgumentException {
        if (observedEvents == null) {
            throw new IllegalArgumentException("List of observed events cannot be null-valued!");
        }
        int i = 0;
        while (i < observedEvents.length) {
            if (observedEvents[i] == null) {
                throw new IllegalArgumentException("Entry " + i + " in the list of observed events is null-valued!  " + "Must be non-null!");
            }
            ++i;
        }
        this.observedEvents = observedEvents;
    }

    public NotifiedEntity getNotifiedEntity() {
        return this.notifiedEntity;
    }

    public RequestIdentifier getRequestIdentifier() {
        return this.requestIdentifier;
    }

    public EventName[] getObservedEvents() {
        return this.observedEvents;
    }

    public String toString() {
        String text = super.BuildCommandHeader("NTFY");
        if (this.notifiedEntity != null) {
            text = text + "N: " + this.notifiedEntity.toString() + "\n";
        }
        if (this.observedEvents != null) {
            text = text + super.BuildListParmLine("O", this.observedEvents);
        }
        if (this.requestIdentifier != null) {
            text = text + "X: " + this.requestIdentifier.toString() + "\n";
        }
        return text;
    }
}

