/*
 * Decompiled with CFR 0.152.
 */
package jain.protocol.ip.mgcp.message.parms;

import jain.protocol.ip.mgcp.message.parms.LocalOptionValue;
import java.io.Serializable;

public final class EncryptionMethod
extends LocalOptionValue
implements Serializable {
    private static final String[] methodName = new String[]{"clear", "base64", "uri"};
    private int encryptionMethod = 0;
    private String encryptionKey = null;
    public static final int CLEAR = 1;
    public static final int BASE64 = 2;
    public static final int URI = 3;

    public EncryptionMethod(int encryptionMethod, String encryptionKey) throws IllegalArgumentException {
        super(10);
        if (encryptionMethod != 1 && encryptionMethod != 2 && encryptionMethod != 3) {
            throw new IllegalArgumentException("Only CLEAR, BASE64, and URI are permissible encryption methods!");
        }
        this.encryptionMethod = encryptionMethod;
        this.encryptionKey = encryptionKey;
    }

    public int getEncryptionMethod() {
        return this.encryptionMethod;
    }

    public String getEncryptionKey() {
        return this.encryptionKey;
    }

    public String toString() {
        return "k:" + methodName[this.encryptionMethod] + ":" + this.encryptionKey + "\n";
    }
}

