/*
 * Decompiled with CFR 0.152.
 */
package jain.protocol.ip.mgcp.message.parms;

import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.pkg.MgcpEvent;
import jain.protocol.ip.mgcp.pkg.PackageName;
import java.io.Serializable;

public final class EventName
implements Serializable {
    private PackageName packageName = null;
    private MgcpEvent event = null;
    private ConnectionIdentifier connectionIdentifier = null;

    public EventName(PackageName packageName, MgcpEvent event, ConnectionIdentifier connectionIdentifier) throws IllegalArgumentException {
        if (packageName == null) {
            throw new IllegalArgumentException("Package name cannot be null-valued!");
        }
        if (event == null) {
            throw new IllegalArgumentException("Event parameter cannot be null-valued!");
        }
        this.packageName = packageName;
        this.event = event;
        this.connectionIdentifier = connectionIdentifier;
    }

    public EventName(PackageName packageName, MgcpEvent event) {
        this(packageName, event, null);
    }

    public PackageName getPackageName() {
        return this.packageName;
    }

    public MgcpEvent getEventIdentifier() {
        return this.event;
    }

    public ConnectionIdentifier getConnectionIdentifier() {
        return this.connectionIdentifier;
    }

    public String toString() {
        String text = this.packageName != null ? this.packageName.toString() + "/" : "";
        text = text + this.event.toString();
        if (this.connectionIdentifier != null) {
            text = text + "@" + this.connectionIdentifier.toString();
        }
        return text;
    }
}

