/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config;

import java.util.Locale;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.Version;
import org.jboss.cache.config.BuddyReplicationConfig;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.ConfigurationComponent;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.Dynamic;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.RuntimeConfig;
import org.jboss.cache.factories.XmlConfigurationParser;
import org.jboss.cache.lock.IsolationLevel;
import org.w3c.dom.Element;

public class Configuration
extends ConfigurationComponent
implements Cloneable {
    private static final long serialVersionUID = 5553791890144997466L;
    private int numberOfNotifierThreads = 25;
    public static final short DEFAULT_REPLICATION_VERSION = Version.getVersionShort();
    private String clusterName = "JBossCache-Cluster";
    private String clusterConfig = null;
    private boolean useReplQueue = false;
    @Dynamic
    private int replQueueMaxElements = 1000;
    @Dynamic
    private long replQueueInterval = 5000L;
    private boolean exposeManagementStatistics = true;
    @Dynamic
    private boolean fetchInMemoryState = true;
    private short replicationVersion = DEFAULT_REPLICATION_VERSION;
    @Dynamic
    private long lockAcquisitionTimeout = 10000L;
    @Dynamic
    private long syncReplTimeout = 15000L;
    private CacheMode cacheMode = CacheMode.LOCAL;
    private boolean inactiveOnStartup = false;
    @Dynamic
    private long stateRetrievalTimeout = 10000L;
    private IsolationLevel isolationLevel = IsolationLevel.REPEATABLE_READ;
    @Dynamic
    private boolean lockParentForChildInsertRemove = false;
    @Dynamic
    private EvictionConfig evictionConfig = null;
    private boolean useRegionBasedMarshalling = false;
    private String transactionManagerLookupClass = null;
    private CacheLoaderConfig cacheLoaderConfig = null;
    @Dynamic
    private boolean syncCommitPhase = false;
    @Dynamic
    private boolean syncRollbackPhase = false;
    private BuddyReplicationConfig buddyReplicationConfig;
    private boolean nodeLockingOptimistic = false;
    private NodeLockingScheme nodeLockingScheme = NodeLockingScheme.PESSIMISTIC;
    private String muxStackName = null;
    private boolean usingMultiplexer = false;
    private transient RuntimeConfig runtimeConfig;
    private String marshallerClass = "org.jboss.cache.marshall.VersionAwareMarshaller";

    public static CacheMode legacyModeToCacheMode(int legacyMode) {
        switch (legacyMode) {
            case 1: {
                return CacheMode.LOCAL;
            }
            case 2: {
                return CacheMode.REPL_ASYNC;
            }
            case 3: {
                return CacheMode.REPL_SYNC;
            }
            case 4: {
                return CacheMode.INVALIDATION_ASYNC;
            }
            case 5: {
                return CacheMode.INVALIDATION_SYNC;
            }
        }
        throw new IllegalArgumentException("Unknown legacy cache mode " + legacyMode);
    }

    public Configuration(CacheImpl cache) {
        this.setCacheImpl(cache);
    }

    public Configuration() {
    }

    public void setClusterConfig(Element config) {
        this.setClusterConfig(XmlConfigurationParser.parseClusterConfigXml(config));
    }

    public void setClusterName(String clusterName) {
        this.testImmutability("clusterName");
        this.clusterName = clusterName;
    }

    public void setClusterConfig(String clusterConfig) {
        this.testImmutability("clusterConfig");
        this.clusterConfig = clusterConfig;
    }

    public void setReplQueueMaxElements(int replQueueMaxElements) {
        this.testImmutability("replQueueMaxElements");
        this.replQueueMaxElements = replQueueMaxElements;
    }

    public void setReplQueueInterval(long replQueueInterval) {
        this.testImmutability("replQueueInterval");
        this.replQueueInterval = replQueueInterval;
    }

    public void setExposeManagementStatistics(boolean useMbean) {
        this.testImmutability("exposeManagementStatistics");
        this.exposeManagementStatistics = useMbean;
    }

    public void setFetchInMemoryState(boolean fetchInMemoryState) {
        this.testImmutability("fetchInMemoryState");
        this.fetchInMemoryState = fetchInMemoryState;
    }

    public void setReplicationVersion(short replicationVersion) {
        this.testImmutability("replicationVersion");
        this.replicationVersion = replicationVersion;
    }

    public void setReplVersionString(String replVersionString) {
        this.setReplicationVersion(replVersionString == null ? (short)0 : Version.getVersionShort(replVersionString));
    }

    public void setLockAcquisitionTimeout(long lockAcquisitionTimeout) {
        this.testImmutability("lockAcquisitionTimeout");
        this.lockAcquisitionTimeout = lockAcquisitionTimeout;
    }

    public void setSyncReplTimeout(long syncReplTimeout) {
        this.testImmutability("syncReplTimeout");
        this.syncReplTimeout = syncReplTimeout;
    }

    public void setCacheMode(CacheMode cacheModeInt) {
        this.testImmutability("cacheMode");
        this.cacheMode = cacheModeInt;
    }

    public void setCacheMode(String cacheMode) {
        this.testImmutability("cacheMode");
        if (cacheMode == null) {
            throw new ConfigurationException("Cache mode cannot be null", "CacheMode");
        }
        this.cacheMode = CacheMode.valueOf(Configuration.uc(cacheMode));
        if (this.cacheMode == null) {
            this.log.warn((Object)("Unknown cache mode '" + cacheMode + "', using defaults."));
            this.cacheMode = CacheMode.LOCAL;
        }
    }

    public String getCacheModeString() {
        return this.cacheMode == null ? null : this.cacheMode.toString();
    }

    public void setCacheModeString(String cacheMode) {
        this.setCacheMode(cacheMode);
    }

    public void setInactiveOnStartup(boolean inactiveOnStartup) {
        this.testImmutability("inactiveOnStartup");
        this.inactiveOnStartup = inactiveOnStartup;
    }

    public EvictionConfig getEvictionConfig() {
        return this.evictionConfig;
    }

    public void setEvictionConfig(EvictionConfig config) {
        this.testImmutability("evictionConfig");
        this.evictionConfig = config;
    }

    public void setUseRegionBasedMarshalling(boolean useRegionBasedMarshalling) {
        this.testImmutability("useRegionBasedMarshalling");
        this.useRegionBasedMarshalling = useRegionBasedMarshalling;
    }

    public void setTransactionManagerLookupClass(String transactionManagerLookupClass) {
        this.testImmutability("transactionManagerLookupClass");
        this.transactionManagerLookupClass = transactionManagerLookupClass;
    }

    public void setCacheLoaderConfig(CacheLoaderConfig config) {
        this.testImmutability("cacheLoaderConfig");
        this.replaceChildConfig(this.cacheLoaderConfig, config);
        this.cacheLoaderConfig = config;
    }

    public void setSyncCommitPhase(boolean syncCommitPhase) {
        this.testImmutability("syncCommitPhase");
        this.syncCommitPhase = syncCommitPhase;
    }

    public void setSyncRollbackPhase(boolean syncRollbackPhase) {
        this.testImmutability("syncRollbackPhase");
        this.syncRollbackPhase = syncRollbackPhase;
    }

    public void setBuddyReplicationConfig(BuddyReplicationConfig config) {
        this.testImmutability("buddyReplicationConfig");
        this.replaceChildConfig(this.buddyReplicationConfig, config);
        this.buddyReplicationConfig = config;
    }

    public void setNodeLockingScheme(NodeLockingScheme nodeLockingScheme) {
        this.testImmutability("nodeLockingScheme");
        this.testImmutability("nodeLockingOptimistic");
        this.nodeLockingScheme = nodeLockingScheme;
        this.nodeLockingOptimistic = nodeLockingScheme == NodeLockingScheme.OPTIMISTIC;
    }

    public void setUseReplQueue(boolean useReplQueue) {
        this.testImmutability("useReplQueue");
        this.useReplQueue = useReplQueue;
    }

    public void setIsolationLevel(IsolationLevel isolationLevel) {
        this.testImmutability("isolationLevel");
        this.isolationLevel = isolationLevel;
    }

    public void setNodeLockingOptimistic(boolean nodeLockingOptimistic) {
        this.testImmutability("nodeLockingOptimistic");
        this.nodeLockingOptimistic = nodeLockingOptimistic;
    }

    @Deprecated
    public void setInitialStateRetrievalTimeout(long stateRetrievalTimeout) {
        this.log.info((Object)"Do not use InitialStateRetrievalTimeout - this is deprecated and may disappear in future releases.  Use StateRetrievalTimeout instead.");
        this.setStateRetrievalTimeout(stateRetrievalTimeout);
    }

    public void setStateRetrievalTimeout(long stateRetrievalTimeout) {
        this.testImmutability("stateRetrievalTimeout");
        this.stateRetrievalTimeout = stateRetrievalTimeout;
    }

    public void setNodeLockingScheme(String nodeLockingScheme) {
        this.testImmutability("nodeLockingScheme");
        this.testImmutability("nodeLockingOptimistic");
        if (nodeLockingScheme == null) {
            throw new ConfigurationException("Node locking scheme cannot be null", "NodeLockingScheme");
        }
        this.nodeLockingScheme = NodeLockingScheme.valueOf(Configuration.uc(nodeLockingScheme));
        if (this.nodeLockingScheme == null) {
            this.log.warn((Object)("Unknown node locking scheme '" + nodeLockingScheme + "', using defaults."));
            this.nodeLockingScheme = NodeLockingScheme.PESSIMISTIC;
        }
        this.nodeLockingOptimistic = this.nodeLockingScheme == NodeLockingScheme.OPTIMISTIC;
    }

    public String getNodeLockingSchemeString() {
        return this.nodeLockingScheme == null ? null : this.nodeLockingScheme.toString();
    }

    public void setNodeLockingSchemeString(String nodeLockingScheme) {
        this.setNodeLockingScheme(nodeLockingScheme);
    }

    private static String uc(String s) {
        return s.toUpperCase(Locale.ENGLISH);
    }

    public void setIsolationLevel(String isolationLevel) {
        this.testImmutability("isolationLevel");
        if (isolationLevel == null) {
            throw new ConfigurationException("Isolation level cannot be null", "IsolationLevel");
        }
        this.isolationLevel = IsolationLevel.valueOf(Configuration.uc(isolationLevel));
        if (this.isolationLevel == null) {
            this.log.warn((Object)("Unknown isolation level '" + isolationLevel + "', using defaults."));
            this.isolationLevel = IsolationLevel.REPEATABLE_READ;
        }
    }

    public String getIsolationLevelString() {
        return this.isolationLevel == null ? null : this.isolationLevel.toString();
    }

    public void setIsolationLevelString(String isolationLevel) {
        this.setIsolationLevel(isolationLevel);
    }

    public void setLockParentForChildInsertRemove(boolean lockParentForChildInsertRemove) {
        this.testImmutability("lockParentForChildInsertRemove");
        this.lockParentForChildInsertRemove = lockParentForChildInsertRemove;
    }

    public void setMultiplexerStack(String stackName) {
        this.testImmutability("muxStackName");
        this.muxStackName = stackName;
    }

    public boolean isUsingMultiplexer() {
        return this.usingMultiplexer;
    }

    public void setUsingMultiplexer(boolean usingMultiplexer) {
        this.testImmutability("usingMultiplexer");
        this.usingMultiplexer = usingMultiplexer;
    }

    public boolean isNodeLockingOptimistic() {
        return this.nodeLockingOptimistic;
    }

    public boolean isUseReplQueue() {
        return this.useReplQueue;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getClusterConfig() {
        return this.clusterConfig;
    }

    public int getReplQueueMaxElements() {
        return this.replQueueMaxElements;
    }

    public long getReplQueueInterval() {
        return this.replQueueInterval;
    }

    public boolean getExposeManagementStatistics() {
        return this.exposeManagementStatistics;
    }

    public boolean isFetchInMemoryState() {
        return this.fetchInMemoryState;
    }

    public short getReplicationVersion() {
        return this.replicationVersion;
    }

    public String getReplVersionString() {
        return Version.getVersionString(this.replicationVersion);
    }

    public long getLockAcquisitionTimeout() {
        return this.lockAcquisitionTimeout;
    }

    public long getSyncReplTimeout() {
        return this.syncReplTimeout;
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public boolean isInactiveOnStartup() {
        return this.inactiveOnStartup;
    }

    public IsolationLevel getIsolationLevel() {
        return this.isolationLevel;
    }

    public boolean isLockParentForChildInsertRemove() {
        return this.lockParentForChildInsertRemove;
    }

    public boolean isUseRegionBasedMarshalling() {
        return this.useRegionBasedMarshalling;
    }

    public String getTransactionManagerLookupClass() {
        return this.transactionManagerLookupClass;
    }

    public CacheLoaderConfig getCacheLoaderConfig() {
        return this.cacheLoaderConfig;
    }

    public boolean isSyncCommitPhase() {
        return this.syncCommitPhase;
    }

    public boolean isSyncRollbackPhase() {
        return this.syncRollbackPhase;
    }

    public BuddyReplicationConfig getBuddyReplicationConfig() {
        return this.buddyReplicationConfig;
    }

    public NodeLockingScheme getNodeLockingScheme() {
        return this.nodeLockingScheme;
    }

    @Deprecated
    public long getInitialStateRetrievalTimeout() {
        return this.getStateRetrievalTimeout();
    }

    public long getStateRetrievalTimeout() {
        return this.stateRetrievalTimeout;
    }

    public String getMultiplexerStack() {
        return this.muxStackName;
    }

    public synchronized RuntimeConfig getRuntimeConfig() {
        if (this.runtimeConfig == null) {
            this.setRuntimeConfig(new RuntimeConfig(), false);
        }
        return this.runtimeConfig;
    }

    public void setRuntimeConfig(RuntimeConfig runtimeConfig) {
        this.setRuntimeConfig(runtimeConfig, true);
    }

    private void setRuntimeConfig(RuntimeConfig runtimeConfig, boolean testImmutability) {
        if (testImmutability) {
            this.testImmutability("runtimeConfig");
        }
        this.runtimeConfig = runtimeConfig;
    }

    public String getMarshallerClass() {
        return this.marshallerClass;
    }

    public void setMarshallerClass(String marshallerClass) {
        this.marshallerClass = marshallerClass;
    }

    public int getNumberOfNotifierThreads() {
        return this.numberOfNotifierThreads;
    }

    public void setNumberOfNotifierThreads(int numberOfNotifierThreads) {
        this.numberOfNotifierThreads = numberOfNotifierThreads;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Configuration that = (Configuration)o;
        if (this.fetchInMemoryState != that.fetchInMemoryState) {
            return false;
        }
        if (this.inactiveOnStartup != that.inactiveOnStartup) {
            return false;
        }
        if (this.stateRetrievalTimeout != that.stateRetrievalTimeout) {
            return false;
        }
        if (this.lockAcquisitionTimeout != that.lockAcquisitionTimeout) {
            return false;
        }
        if (this.nodeLockingOptimistic != that.nodeLockingOptimistic) {
            return false;
        }
        if (this.replQueueInterval != that.replQueueInterval) {
            return false;
        }
        if (this.replQueueMaxElements != that.replQueueMaxElements) {
            return false;
        }
        if (this.replicationVersion != that.replicationVersion) {
            return false;
        }
        if (this.syncCommitPhase != that.syncCommitPhase) {
            return false;
        }
        if (this.syncReplTimeout != that.syncReplTimeout) {
            return false;
        }
        if (this.syncRollbackPhase != that.syncRollbackPhase) {
            return false;
        }
        if (this.exposeManagementStatistics != that.exposeManagementStatistics) {
            return false;
        }
        if (this.useRegionBasedMarshalling != that.useRegionBasedMarshalling) {
            return false;
        }
        if (this.useReplQueue != that.useReplQueue) {
            return false;
        }
        if (this.buddyReplicationConfig != null ? !this.buddyReplicationConfig.equals(that.buddyReplicationConfig) : that.buddyReplicationConfig != null) {
            return false;
        }
        if (this.cacheLoaderConfig != null ? !this.cacheLoaderConfig.equals(that.cacheLoaderConfig) : that.cacheLoaderConfig != null) {
            return false;
        }
        if (this.cacheMode != that.cacheMode) {
            return false;
        }
        if (this.clusterConfig != null ? !this.clusterConfig.equals(that.clusterConfig) : that.clusterConfig != null) {
            return false;
        }
        if (this.clusterName != null ? !this.clusterName.equals(that.clusterName) : that.clusterName != null) {
            return false;
        }
        if (this.evictionConfig != null ? !this.evictionConfig.equals(that.evictionConfig) : that.evictionConfig != null) {
            return false;
        }
        if (this.isolationLevel != that.isolationLevel) {
            return false;
        }
        if (this.muxStackName != null ? !this.muxStackName.equals(that.muxStackName) : that.muxStackName != null) {
            return false;
        }
        if (this.nodeLockingScheme != that.nodeLockingScheme) {
            return false;
        }
        if (this.transactionManagerLookupClass != null ? !this.transactionManagerLookupClass.equals(that.transactionManagerLookupClass) : that.transactionManagerLookupClass != null) {
            return false;
        }
        if (!Configuration.safeEquals(this.runtimeConfig, that.runtimeConfig)) {
            return false;
        }
        if (!Configuration.safeEquals(this.marshallerClass, that.marshallerClass)) {
            return false;
        }
        if (this.lockParentForChildInsertRemove != that.lockParentForChildInsertRemove) {
            return false;
        }
        return this.numberOfNotifierThreads == that.numberOfNotifierThreads;
    }

    public int hashCode() {
        int result = 17;
        result = 29 * result + (this.clusterName != null ? this.clusterName.hashCode() : 0);
        result = 29 * result + (this.clusterConfig != null ? this.clusterConfig.hashCode() : 0);
        result = 29 * result + (this.useReplQueue ? 1 : 0);
        result = 29 * result + this.replQueueMaxElements;
        result = 29 * result + (int)(this.replQueueInterval ^ this.replQueueInterval >>> 32);
        result = 29 * result + (this.exposeManagementStatistics ? 1 : 0);
        result = 29 * result + (this.fetchInMemoryState ? 1 : 0);
        result = 29 * result + this.replicationVersion;
        result = 29 * result + (int)(this.lockAcquisitionTimeout ^ this.lockAcquisitionTimeout >>> 32);
        result = 29 * result + (int)(this.syncReplTimeout ^ this.syncReplTimeout >>> 32);
        result = 29 * result + (this.cacheMode != null ? this.cacheMode.hashCode() : 0);
        result = 29 * result + (this.inactiveOnStartup ? 1 : 0);
        result = 29 * result + (int)(this.stateRetrievalTimeout ^ this.stateRetrievalTimeout >>> 32);
        result = 29 * result + (this.isolationLevel != null ? this.isolationLevel.hashCode() : 0);
        result = 29 * result + (this.evictionConfig != null ? this.evictionConfig.hashCode() : 0);
        result = 29 * result + (this.useRegionBasedMarshalling ? 1 : 0);
        result = 29 * result + (this.transactionManagerLookupClass != null ? this.transactionManagerLookupClass.hashCode() : 0);
        result = 29 * result + (this.cacheLoaderConfig != null ? this.cacheLoaderConfig.hashCode() : 0);
        result = 29 * result + (this.syncCommitPhase ? 1 : 0);
        result = 29 * result + (this.syncRollbackPhase ? 1 : 0);
        result = 29 * result + (this.buddyReplicationConfig != null ? this.buddyReplicationConfig.hashCode() : 0);
        result = 29 * result + (this.nodeLockingOptimistic ? 1 : 0);
        result = 29 * result + (this.nodeLockingScheme != null ? this.nodeLockingScheme.hashCode() : 0);
        result = 29 * result + (this.muxStackName != null ? this.muxStackName.hashCode() : 0);
        result = 29 * result + (this.runtimeConfig != null ? this.runtimeConfig.hashCode() : 0);
        result = 29 * result + (this.marshallerClass != null ? this.marshallerClass.hashCode() : 0);
        result = 29 * result + (this.lockParentForChildInsertRemove ? 1 : 0);
        result = 29 * result + this.numberOfNotifierThreads;
        return result;
    }

    public Configuration clone() throws CloneNotSupportedException {
        Configuration c = (Configuration)super.clone();
        if (this.buddyReplicationConfig != null) {
            c.setBuddyReplicationConfig((BuddyReplicationConfig)this.buddyReplicationConfig.clone());
        }
        if (this.evictionConfig != null) {
            c.setEvictionConfig((EvictionConfig)this.evictionConfig.clone());
        }
        if (this.cacheLoaderConfig != null) {
            c.setCacheLoaderConfig((CacheLoaderConfig)this.cacheLoaderConfig.clone());
        }
        if (this.runtimeConfig != null) {
            c.setRuntimeConfig((RuntimeConfig)this.runtimeConfig.clone());
            c.getRuntimeConfig().reset();
        }
        return c;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NodeLockingScheme {
        PESSIMISTIC,
        OPTIMISTIC;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CacheMode {
        LOCAL,
        REPL_SYNC,
        REPL_ASYNC,
        INVALIDATION_SYNC,
        INVALIDATION_ASYNC;

    }
}

