/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.factories;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheImpl;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.interceptors.ActivationInterceptor;
import org.jboss.cache.interceptors.CacheLoaderInterceptor;
import org.jboss.cache.interceptors.CacheMgmtInterceptor;
import org.jboss.cache.interceptors.CacheStoreInterceptor;
import org.jboss.cache.interceptors.CallInterceptor;
import org.jboss.cache.interceptors.DataGravitatorInterceptor;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.interceptors.InvalidationInterceptor;
import org.jboss.cache.interceptors.InvocationContextInterceptor;
import org.jboss.cache.interceptors.NotificationInterceptor;
import org.jboss.cache.interceptors.OptimisticCreateIfNotExistsInterceptor;
import org.jboss.cache.interceptors.OptimisticLockingInterceptor;
import org.jboss.cache.interceptors.OptimisticNodeInterceptor;
import org.jboss.cache.interceptors.OptimisticReplicationInterceptor;
import org.jboss.cache.interceptors.OptimisticValidatorInterceptor;
import org.jboss.cache.interceptors.PassivationInterceptor;
import org.jboss.cache.interceptors.PessimisticLockInterceptor;
import org.jboss.cache.interceptors.ReplicationInterceptor;
import org.jboss.cache.interceptors.TxInterceptor;
import org.jboss.cache.interceptors.UnlockInterceptor;
import org.jboss.cache.loader.CacheLoaderManager;
import org.jboss.cache.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorChainFactory {
    private Log log = LogFactory.getLog(InterceptorChainFactory.class);
    private static InterceptorChainFactory singleton;

    private InterceptorChainFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InterceptorChainFactory getInstance() {
        if (singleton != null) return singleton;
        Class<InterceptorChainFactory> clazz = InterceptorChainFactory.class;
        synchronized (InterceptorChainFactory.class) {
            if (singleton != null) return singleton;
            singleton = new InterceptorChainFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    public Interceptor buildInterceptorChain(CacheImpl cache) throws IllegalAccessException, ClassNotFoundException, InstantiationException {
        if (cache.getConfiguration().isNodeLockingOptimistic()) {
            return this.createOptimisticInterceptorChain(cache);
        }
        return this.createPessimisticInterceptorChain(cache);
    }

    public Interceptor setLastInterceptorPointer(Interceptor first, Interceptor last) {
        for (Interceptor i = first; i != null; i = i.getNext()) {
            i.setLast(last);
        }
        return first;
    }

    private Interceptor createInterceptor(String classname, CacheSPI cache) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class clazz = Util.loadClass(classname);
        return this.createInterceptor(clazz, cache);
    }

    private Interceptor createInterceptor(Class<? extends Interceptor> clazz, CacheSPI cache) throws IllegalAccessException, InstantiationException {
        Interceptor i = clazz.newInstance();
        i.setCache(cache);
        i.setStatisticsEnabled(cache.getConfiguration().getExposeManagementStatistics());
        return i;
    }

    private void addInterceptor(Interceptor first, Interceptor i) {
        if (first == null) {
            return;
        }
        while (first.getNext() != null) {
            first = first.getNext();
        }
        first.setNext(i);
    }

    private Interceptor createPessimisticInterceptorChain(CacheImpl cache) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        Interceptor repl_interceptor = null;
        Interceptor cache_loader_interceptor = null;
        Interceptor cache_store_interceptor = null;
        Interceptor passivation_interceptor = null;
        Interceptor activation_interceptor = null;
        Interceptor dataGravitatorInterceptor = null;
        Interceptor invocationCtxInterceptor = this.createInterceptor(InvocationContextInterceptor.class, (CacheSPI)cache);
        Interceptor notificationInterceptor = this.createInterceptor(NotificationInterceptor.class, (CacheSPI)cache);
        Interceptor first = null;
        Interceptor call_interceptor = this.createInterceptor(CallInterceptor.class, (CacheSPI)cache);
        ((CallInterceptor)call_interceptor).setTreeCacheInstance(cache);
        if (cache.getBuddyManager() != null) {
            dataGravitatorInterceptor = this.createInterceptor(DataGravitatorInterceptor.class, (CacheSPI)cache);
        }
        Interceptor lock_interceptor = this.createInterceptor(PessimisticLockInterceptor.class, (CacheSPI)cache);
        Interceptor unlock_interceptor = this.createInterceptor(UnlockInterceptor.class, (CacheSPI)cache);
        Interceptor cacheMgmtInterceptor = this.createInterceptor(CacheMgmtInterceptor.class, (CacheSPI)cache);
        Interceptor txInterceptor = this.createInterceptor(TxInterceptor.class, (CacheSPI)cache);
        switch (cache.getConfiguration().getCacheMode()) {
            case REPL_SYNC: 
            case REPL_ASYNC: {
                repl_interceptor = this.createInterceptor(ReplicationInterceptor.class, (CacheSPI)cache);
                break;
            }
            case INVALIDATION_SYNC: 
            case INVALIDATION_ASYNC: {
                repl_interceptor = this.createInterceptor(InvalidationInterceptor.class, (CacheSPI)cache);
                break;
            }
        }
        CacheLoaderManager cacheLoaderMgr = cache.getCacheLoaderManager();
        if (cacheLoaderMgr != null && cacheLoaderMgr.getCacheLoader() != null) {
            if (cacheLoaderMgr.isPassivation()) {
                activation_interceptor = this.createInterceptor(ActivationInterceptor.class, (CacheSPI)cache);
                passivation_interceptor = this.createInterceptor(PassivationInterceptor.class, (CacheSPI)cache);
            } else {
                cache_loader_interceptor = this.createInterceptor(CacheLoaderInterceptor.class, (CacheSPI)cache);
                cache_store_interceptor = this.createInterceptor(CacheStoreInterceptor.class, (CacheSPI)cache);
            }
        }
        if (first == null) {
            first = invocationCtxInterceptor;
        }
        if (cache.getConfiguration().getExposeManagementStatistics()) {
            if (first == null) {
                first = cacheMgmtInterceptor;
            } else {
                this.addInterceptor(first, cacheMgmtInterceptor);
            }
        }
        if (first == null) {
            first = txInterceptor;
        } else {
            this.addInterceptor(first, txInterceptor);
        }
        if (first == null) {
            first = notificationInterceptor;
        } else {
            this.addInterceptor(first, notificationInterceptor);
        }
        if (repl_interceptor != null) {
            if (first == null) {
                first = repl_interceptor;
            } else {
                this.addInterceptor(first, repl_interceptor);
            }
        }
        if (first == null) {
            first = lock_interceptor;
        } else {
            this.addInterceptor(first, lock_interceptor);
        }
        if (unlock_interceptor != null) {
            if (first == null) {
                first = unlock_interceptor;
            } else {
                this.addInterceptor(first, unlock_interceptor);
            }
        }
        if (activation_interceptor != null) {
            if (first == null) {
                first = activation_interceptor;
            } else {
                this.addInterceptor(first, activation_interceptor);
            }
            if (first == null) {
                first = passivation_interceptor;
            } else {
                this.addInterceptor(first, passivation_interceptor);
            }
        }
        if (cache_loader_interceptor != null) {
            if (first == null) {
                first = cache_loader_interceptor;
            } else {
                this.addInterceptor(first, cache_loader_interceptor);
            }
            if (first == null) {
                first = cache_store_interceptor;
            } else {
                this.addInterceptor(first, cache_store_interceptor);
            }
        }
        if (dataGravitatorInterceptor != null) {
            if (first == null) {
                first = dataGravitatorInterceptor;
            } else {
                this.addInterceptor(first, dataGravitatorInterceptor);
            }
        }
        if (cache.getConfiguration().getEvictionConfig() != null && cache.getConfiguration().getEvictionConfig().isValidConfig()) {
            Interceptor eviction_interceptor = this.createInterceptor(cache.getEvictionInterceptorClass(), (CacheSPI)cache);
            if (first == null) {
                first = eviction_interceptor;
            } else {
                this.addInterceptor(first, eviction_interceptor);
            }
        }
        if (first == null) {
            first = call_interceptor;
        } else {
            this.addInterceptor(first, call_interceptor);
        }
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("interceptor chain is:\n" + this.printInterceptorChain(first)));
        }
        return this.setLastInterceptorPointer(first, call_interceptor);
    }

    private Interceptor createOptimisticInterceptorChain(CacheImpl cache) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        Interceptor replicationInterceptor = null;
        Interceptor activationInterceptor = null;
        Interceptor passivationInterceptor = null;
        Interceptor cacheLoaderInterceptor = null;
        Interceptor cacheStoreInterceptor = null;
        Interceptor first = null;
        Interceptor evictionInterceptor = null;
        Interceptor dataGravitatorInterceptor = null;
        Interceptor invocationCtxInterceptor = this.createInterceptor(InvocationContextInterceptor.class, (CacheSPI)cache);
        Interceptor notificationInterceptor = this.createInterceptor(NotificationInterceptor.class, (CacheSPI)cache);
        CacheLoaderManager cacheLoaderManager = cache.getCacheLoaderManager();
        if (cacheLoaderManager != null && cacheLoaderManager.getCacheLoader() != null) {
            if (cacheLoaderManager.isPassivation()) {
                activationInterceptor = this.createInterceptor(ActivationInterceptor.class, (CacheSPI)cache);
                passivationInterceptor = this.createInterceptor(PassivationInterceptor.class, (CacheSPI)cache);
            } else {
                cacheLoaderInterceptor = this.createInterceptor(CacheLoaderInterceptor.class, (CacheSPI)cache);
                cacheStoreInterceptor = this.createInterceptor(CacheStoreInterceptor.class, (CacheSPI)cache);
            }
        }
        Interceptor txInterceptor = this.createInterceptor(TxInterceptor.class, (CacheSPI)cache);
        if (cache.getBuddyManager() != null) {
            dataGravitatorInterceptor = this.createInterceptor(DataGravitatorInterceptor.class, (CacheSPI)cache);
        }
        switch (cache.getConfiguration().getCacheMode()) {
            case REPL_SYNC: 
            case REPL_ASYNC: {
                replicationInterceptor = this.createInterceptor(OptimisticReplicationInterceptor.class, (CacheSPI)cache);
                break;
            }
            case INVALIDATION_SYNC: 
            case INVALIDATION_ASYNC: {
                replicationInterceptor = this.createInterceptor(InvalidationInterceptor.class, (CacheSPI)cache);
                break;
            }
        }
        Interceptor lockInterceptor = this.createInterceptor(OptimisticLockingInterceptor.class, (CacheSPI)cache);
        Interceptor validationInterceptor = this.createInterceptor(OptimisticValidatorInterceptor.class, (CacheSPI)cache);
        Interceptor createIfNotExistsInterceptor = this.createInterceptor(OptimisticCreateIfNotExistsInterceptor.class, (CacheSPI)cache);
        Interceptor nodeInterceptor = this.createInterceptor(OptimisticNodeInterceptor.class, (CacheSPI)cache);
        Interceptor invokerInterceptor = this.createInterceptor(CallInterceptor.class, (CacheSPI)cache);
        ((CallInterceptor)invokerInterceptor).setTreeCacheInstance(cache);
        if (cache.getConfiguration().getEvictionConfig() != null && cache.getConfiguration().getEvictionConfig().isValidConfig()) {
            evictionInterceptor = this.createInterceptor(cache.getEvictionInterceptorClass(), (CacheSPI)cache);
        }
        if (first == null) {
            first = invocationCtxInterceptor;
        }
        if (cache.getConfiguration().getExposeManagementStatistics()) {
            Interceptor cacheMgmtInterceptor = this.createInterceptor(CacheMgmtInterceptor.class, (CacheSPI)cache);
            if (first == null) {
                first = cacheMgmtInterceptor;
            } else {
                this.addInterceptor(first, cacheMgmtInterceptor);
            }
        }
        if (txInterceptor != null) {
            if (first == null) {
                first = txInterceptor;
            } else {
                this.addInterceptor(first, txInterceptor);
            }
        }
        if (first == null) {
            first = notificationInterceptor;
        } else {
            this.addInterceptor(first, notificationInterceptor);
        }
        if (first == null) {
            first = replicationInterceptor;
        } else {
            this.addInterceptor(first, replicationInterceptor);
        }
        if (passivationInterceptor != null && !cacheLoaderManager.isFetchPersistentState()) {
            if (first == null) {
                first = passivationInterceptor;
            } else {
                this.addInterceptor(first, passivationInterceptor);
            }
        }
        if (cacheStoreInterceptor != null && !cacheLoaderManager.isFetchPersistentState()) {
            if (first == null) {
                first = cacheStoreInterceptor;
            } else {
                this.addInterceptor(first, cacheStoreInterceptor);
            }
        }
        if (activationInterceptor != null) {
            if (first == null) {
                first = activationInterceptor;
            } else {
                this.addInterceptor(first, activationInterceptor);
            }
            if (cacheLoaderManager.isFetchPersistentState()) {
                if (first == null) {
                    first = passivationInterceptor;
                } else {
                    this.addInterceptor(first, passivationInterceptor);
                }
            }
        }
        if (cacheLoaderInterceptor != null) {
            if (first == null) {
                first = cacheLoaderInterceptor;
            } else {
                this.addInterceptor(first, cacheLoaderInterceptor);
            }
            if (cacheLoaderManager.isFetchPersistentState()) {
                if (first == null) {
                    first = cacheStoreInterceptor;
                } else {
                    this.addInterceptor(first, cacheStoreInterceptor);
                }
            }
        }
        if (dataGravitatorInterceptor != null) {
            if (first == null) {
                first = dataGravitatorInterceptor;
            } else {
                this.addInterceptor(first, dataGravitatorInterceptor);
            }
        }
        if (first == null) {
            first = lockInterceptor;
        } else {
            this.addInterceptor(first, lockInterceptor);
        }
        if (first == null) {
            first = validationInterceptor;
        } else {
            this.addInterceptor(first, validationInterceptor);
        }
        if (first == null) {
            first = createIfNotExistsInterceptor;
        } else {
            this.addInterceptor(first, createIfNotExistsInterceptor);
        }
        if (first == null) {
            first = evictionInterceptor;
        } else {
            this.addInterceptor(first, evictionInterceptor);
        }
        if (first == null) {
            first = nodeInterceptor;
        } else {
            this.addInterceptor(first, nodeInterceptor);
        }
        if (first == null) {
            first = invokerInterceptor;
        } else {
            this.addInterceptor(first, invokerInterceptor);
        }
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("interceptor chain is:\n" + this.printInterceptorChain(first)));
        }
        return this.setLastInterceptorPointer(first, invokerInterceptor);
    }

    public String printInterceptorChain(Interceptor i) {
        StringBuffer sb = new StringBuffer();
        if (i != null) {
            if (i.getNext() != null) {
                sb.append(this.printInterceptorChain(i.getNext())).append("\n");
            }
            sb.append(i.getClass());
        }
        return sb.toString();
    }

    public List<Interceptor> asList(Interceptor interceptor) {
        if (interceptor == null) {
            return null;
        }
        int num = 1;
        Interceptor tmp = interceptor;
        while ((tmp = tmp.getNext()) != null) {
            ++num;
        }
        ArrayList<Interceptor> retval = new ArrayList<Interceptor>(num);
        tmp = interceptor;
        num = 0;
        do {
            retval.add(tmp);
        } while ((tmp = tmp.getNext()) != null);
        return retval;
    }

    public Interceptor correctInterceptorChaining(List<Interceptor> interceptors) {
        Interceptor first = null;
        Interceptor last = null;
        for (Interceptor next : interceptors) {
            if (first == null) {
                first = last = next;
                continue;
            }
            last.setNext(next);
            last = next;
        }
        if (last != null) {
            last.setNext(null);
        }
        return this.setLastInterceptorPointer(first, last);
    }

    public void initialiseInterceptors(Interceptor firstInterceptor, CacheSPI cache) {
        for (Interceptor i : this.asList(firstInterceptor)) {
            i.setCache(cache);
        }
    }
}

