/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.transaction.TransactionManager;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Modification;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.interceptors.ActivationInterceptorMBean;
import org.jboss.cache.interceptors.CacheLoaderInterceptor;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.TransactionEntry;
import org.jboss.cache.transaction.TransactionTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivationInterceptor
extends CacheLoaderInterceptor
implements ActivationInterceptorMBean {
    protected TransactionManager tx_mgr = null;
    protected TransactionTable tx_table = null;
    private HashMap m_txActivations = new HashMap();
    private long m_activations = 0L;
    protected ConcurrentHashMap transactions = new ConcurrentHashMap(16);
    protected static final Object NULL = new Object();

    public ActivationInterceptor() {
        this.useCacheStore = false;
        this.isActivation = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(InvocationContext ctx) throws Throwable {
        MethodCall m = ctx.getMethodCall();
        Fqn fqn = null;
        Object[] args = m.getArgs();
        Object retval = super.invoke(ctx);
        boolean removeData = false;
        boolean nodeRemoved = false;
        if (this.tx_mgr != null && this.tx_mgr.getTransaction() != null) {
            GlobalTransaction gtx = ctx.getGlobalTransaction();
            switch (m.getMethodId()) {
                case 11: {
                    if (!this.hasModifications(args)) break;
                    this.loader.commit(gtx);
                    if (!this.configuration.getExposeManagementStatistics() || !this.getStatisticsEnabled()) break;
                    Integer acts = (Integer)this.m_txActivations.get(gtx);
                    if (acts != null) {
                        this.m_activations += (long)acts.intValue();
                    }
                    this.m_txActivations.remove(gtx);
                    break;
                }
                case 12: {
                    if (!this.hasModifications(args)) break;
                    this.loader.rollback(gtx);
                    if (!this.configuration.getExposeManagementStatistics() || !this.getStatisticsEnabled()) break;
                    this.m_txActivations.remove(gtx);
                    break;
                }
                case 10: 
                case 18: {
                    this.prepareCacheLoader(ctx);
                }
            }
        }
        switch (m.getMethodId()) {
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 15: 
            case 45: {
                fqn = (Fqn)args[1];
                break;
            }
            case 17: 
            case 23: 
            case 25: 
            case 26: 
            case 31: 
            case 32: {
                fqn = (Fqn)args[0];
                break;
            }
            case 5: {
                nodeRemoved = true;
                fqn = (Fqn)args[1];
                break;
            }
            case 7: {
                removeData = true;
                fqn = (Fqn)args[1];
            }
        }
        ActivationInterceptor activationInterceptor = this;
        synchronized (activationInterceptor) {
            if (fqn != null) {
                NodeSPI n;
                if (nodeRemoved) {
                    this.log.trace((Object)"This is a remove operation; removing the node from the loader, no activation processing needed.");
                    this.loader.remove(fqn);
                } else if (removeData) {
                    this.log.trace((Object)"This is a remove data operation; removing the data from the loader, no activation processing needed.");
                    this.loader.removeData(fqn);
                } else if (this.cache.peek(fqn, false) != null && this.loader.exists(fqn) && (n = this.getNode(fqn)) != null && n.getDataLoaded()) {
                    if (!n.getChildrenDirect().isEmpty()) {
                        if (this.allInitialized(n)) {
                            this.log.debug((Object)"children all initialized");
                            this.remove(ctx, fqn);
                        }
                    } else if (this.loaderNoChildren(fqn)) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("no children " + n));
                        }
                        this.remove(ctx, fqn);
                    }
                }
            }
        }
        return retval;
    }

    private void remove(InvocationContext ctx, Fqn fqn) throws Exception {
        this.cache.getNotifier().notifyNodeActivated(fqn, true, Collections.emptyMap(), ctx);
        this.loader.remove(fqn);
        if (this.configuration.getExposeManagementStatistics() && this.getStatisticsEnabled()) {
            ++this.m_activations;
        }
    }

    private boolean allInitialized(NodeSPI<?, ?> n) {
        if (!n.getChildrenLoaded()) {
            return false;
        }
        for (NodeSPI<?, ?> child : n.getChildrenDirect()) {
            if (child.getDataLoaded()) continue;
            return false;
        }
        return true;
    }

    private boolean loaderNoChildren(Fqn fqn) {
        try {
            Set<?> children_names = this.loader.getChildrenNames(fqn);
            return children_names == null;
        }
        catch (Exception e) {
            this.log.error((Object)("failed getting the children names for " + fqn + " from the cache loader"), (Throwable)e);
            return false;
        }
    }

    @Override
    public long getActivations() {
        return this.m_activations;
    }

    @Override
    public void resetStatistics() {
        super.resetStatistics();
        this.m_activations = 0L;
    }

    @Override
    public Map<String, Object> dumpStatistics() {
        Map<String, Object> retval = super.dumpStatistics();
        if (retval == null) {
            retval = new HashMap<String, Object>();
        }
        retval.put("Activations", this.m_activations);
        return retval;
    }

    protected boolean hasModifications(Object[] args) {
        int hint = 1;
        if (args[hint] instanceof Boolean) {
            return (Boolean)args[hint];
        }
        for (Object arg : args) {
            if (!(arg instanceof Boolean)) continue;
            return (Boolean)arg;
        }
        return false;
    }

    private void prepareCacheLoader(InvocationContext ctx) throws Exception {
        int txActs = 0;
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        TransactionEntry entry = this.tx_table.get(gtx);
        if (entry == null) {
            throw new Exception("entry for transaction " + gtx + " not found in transaction table");
        }
        List<MethodCall> modifications = entry.getCacheLoaderModifications();
        if (modifications.size() == 0) {
            return;
        }
        ArrayList<Modification> cache_loader_modifications = new ArrayList<Modification>();
        for (MethodCall methodCall : modifications) {
            Method method = methodCall.getMethod();
            if (method == null) {
                throw new Exception("method call has no method: " + (Object)((Object)methodCall));
            }
            Object[] args = methodCall.getArgs();
            switch (methodCall.getMethodId()) {
                case 5: {
                    Modification mod = new Modification(Modification.ModificationType.REMOVE_NODE, (Fqn)args[1]);
                    cache_loader_modifications.add(mod);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    NodeSPI n;
                    Fqn fqn = (Fqn)args[1];
                    if (fqn == null || this.cache.peek(fqn, false) == null || !this.loader.exists(fqn) || (n = this.getNode(fqn)) == null || !n.getDataLoaded()) break;
                    if (!n.getChildrenDirect().isEmpty() && this.allInitialized(n)) {
                        this.addRemoveMod(ctx, cache_loader_modifications, fqn, n.getDataDirect());
                        ++txActs;
                        break;
                    }
                    if (!this.loaderNoChildren(fqn)) break;
                    this.addRemoveMod(ctx, cache_loader_modifications, fqn, n.getDataDirect());
                    ++txActs;
                }
            }
        }
        if (cache_loader_modifications.size() > 0) {
            this.loader.prepare(gtx, cache_loader_modifications, false);
            if (this.configuration.getExposeManagementStatistics() && this.getStatisticsEnabled() && txActs > 0) {
                this.m_txActivations.put(gtx, txActs);
            }
        }
    }

    private void addRemoveMod(InvocationContext ctx, List l, Fqn fqn, Map data) {
        Modification mod = new Modification(Modification.ModificationType.REMOVE_NODE, fqn);
        l.add(mod);
        this.cache.getNotifier().notifyNodeActivated(fqn, false, data, ctx);
    }
}

