/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.ArrayList;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeFactory;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.interceptors.OptimisticInterceptor;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.marshall.MethodDeclarations;
import org.jboss.cache.notifications.Notifier;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jboss.cache.transaction.GlobalTransaction;

public class OptimisticCreateIfNotExistsInterceptor
extends OptimisticInterceptor {
    private NodeFactory nodeFactory;

    public void setCache(CacheSPI cache) {
        super.setCache(cache);
        this.nodeFactory = cache.getConfiguration().getRuntimeConfig().getNodeFactory();
    }

    public Object invoke(InvocationContext ctx) throws Throwable {
        MethodCall m = ctx.getMethodCall();
        if (MethodDeclarations.isPutMethod(m.getMethodId())) {
            Object[] args = m.getArgs();
            Fqn fqn = (Fqn)(args != null ? args[1] : null);
            if (this.cache.peek(fqn, false) == null) {
                this.createNode(ctx, fqn, false);
            }
        } else if (m.getMethodId() == 36) {
            Object[] args = m.getArgs();
            this.move(ctx, (Fqn)args[0], (Fqn)args[1]);
        }
        return super.invoke(ctx);
    }

    private void move(InvocationContext ctx, Fqn nodeFqn, Fqn newParent) {
        ArrayList<Fqn> fqns = new ArrayList<Fqn>();
        fqns.add(newParent);
        NodeSPI node = this.cache.peek(nodeFqn, true);
        this.greedyGetFqns(fqns, node, newParent);
        if (this.trace) {
            this.log.trace((Object)("Adding Fqns " + fqns + " for a move() operation."));
        }
        for (Fqn f : fqns) {
            if (this.cache.peek(f, false) != null) continue;
            this.createNode(ctx, f, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNode(InvocationContext ctx, Fqn targetFqn, boolean suppressNotification) throws CacheException {
        if (targetFqn == null) {
            return;
        }
        boolean debug = this.log.isDebugEnabled();
        GlobalTransaction gtx = this.getGlobalTransaction(ctx);
        TransactionWorkspace workspace = this.getTransactionWorkspace(gtx);
        ArrayList<Fqn> nodesCreated = new ArrayList<Fqn>();
        TransactionWorkspace transactionWorkspace = workspace;
        synchronized (transactionWorkspace) {
            DataVersion version = null;
            if (ctx.getOptionOverrides() != null && ctx.getOptionOverrides().getDataVersion() != null) {
                version = ctx.getOptionOverrides().getDataVersion();
                workspace.setVersioningImplicit(false);
            }
            WorkspaceNode workspaceNode = workspace.getNode(Fqn.ROOT);
            if (debug) {
                this.log.debug((Object)("GlobalTransaction: " + gtx + "; Root: " + workspaceNode));
            }
            if (workspaceNode == null) {
                NodeSPI node = this.cache.getRoot();
                workspaceNode = this.nodeFactory.createWorkspaceNode(node, workspace);
                workspace.addNode(workspaceNode);
                this.log.debug((Object)"Created root node in workspace.");
            } else {
                this.log.debug((Object)"Found root node in workspace.");
            }
            Fqn currentFqn = Fqn.ROOT;
            int targetFqnSize = targetFqn.size();
            int currentDepth = 1;
            for (Object childName : targetFqn.peekElements()) {
                NodeSPI currentNode;
                boolean isTargetFqn = currentDepth == targetFqnSize;
                ++currentDepth;
                if (debug) {
                    this.log.debug((Object)("Attempting to get child " + childName));
                }
                if ((currentNode = workspaceNode.getChild(childName)) == null) {
                    if (this.trace) {
                        this.log.trace((Object)"Creating new child, since it doesn't exist in the cache.");
                    }
                    if (workspaceNode.isDeleted()) {
                        if (this.trace) {
                            this.log.trace((Object)"Parent node doesn't exist in workspace or has been deleted.  Adding to workspace.");
                        }
                        workspace.addNode(workspaceNode);
                        if (!(workspaceNode.getVersion() instanceof DefaultDataVersion)) {
                            workspaceNode.setVersioningImplicit(false);
                        }
                    } else if (this.trace) {
                        this.log.trace((Object)("Parent node exists: " + workspaceNode));
                    }
                    DataVersion versionToPassIn = null;
                    if (isTargetFqn && !workspace.isVersioningImplicit()) {
                        versionToPassIn = version;
                    }
                    NodeSPI newUnderlyingChildNode = workspaceNode.createChild(childName, workspaceNode.getNode(), this.cache, versionToPassIn);
                    workspaceNode = this.nodeFactory.createWorkspaceNode(newUnderlyingChildNode, workspace);
                    workspaceNode.setVersioningImplicit(versionToPassIn == null || !isTargetFqn);
                    if (this.trace) {
                        this.log.trace((Object)("setting versioning of " + workspaceNode.getFqn() + " to be " + (workspaceNode.isVersioningImplicit() ? "implicit" : "explicit")));
                    }
                    workspace.addNode(workspaceNode);
                    workspaceNode.markAsCreated();
                    nodesCreated.add(workspaceNode.getFqn());
                    continue;
                }
                workspaceNode = workspace.getNode(currentNode.getFqn());
                if (workspaceNode == null || workspaceNode.isDeleted()) {
                    if (this.trace) {
                        this.log.trace((Object)("Child node " + currentNode.getFqn() + " doesn't exist in workspace or has been deleted.  Adding to workspace in gtx " + gtx));
                    }
                    workspaceNode = this.nodeFactory.createWorkspaceNode(currentNode, workspace);
                    if (isTargetFqn && !workspace.isVersioningImplicit()) {
                        workspaceNode.setVersion(version);
                        workspaceNode.setVersioningImplicit(false);
                    } else {
                        workspaceNode.setVersioningImplicit(true);
                    }
                    if (this.trace) {
                        this.log.trace((Object)("setting versioning of " + workspaceNode.getFqn() + " to be " + (workspaceNode.isVersioningImplicit() ? "implicit" : "explicit")));
                    }
                    workspace.addNode(workspaceNode);
                    continue;
                }
                if (!this.trace) continue;
                this.log.trace((Object)("Found child node in the workspace: " + currentNode));
            }
        }
        if (!suppressNotification && nodesCreated.size() > 0) {
            Notifier n = this.cache.getNotifier();
            for (Fqn temp : nodesCreated) {
                n.notifyNodeCreated(temp, true, ctx);
                n.notifyNodeCreated(temp, false, ctx);
                if (!this.trace) continue;
                this.log.trace((Object)("Notifying cache of node created in workspace " + temp));
            }
        }
    }
}

