/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.List;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.transaction.GlobalTransaction;
import org.jboss.cache.transaction.OptimisticTransactionEntry;
import org.jboss.cache.transaction.TransactionTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptimisticInterceptor
extends Interceptor {
    protected TransactionManager txManager = null;
    protected TransactionTable txTable = null;
    protected boolean trace;

    @Override
    public void setCache(CacheSPI cache) {
        super.setCache(cache);
        this.txManager = cache.getTransactionManager();
        this.txTable = cache.getTransactionTable();
        this.trace = this.log != null && this.log.isTraceEnabled();
    }

    protected TransactionWorkspace getTransactionWorkspace(GlobalTransaction gtx) throws CacheException {
        OptimisticTransactionEntry transactionEntry = (OptimisticTransactionEntry)this.txTable.get(gtx);
        if (transactionEntry == null) {
            throw new CacheException("Unable to map global transaction " + gtx + " to transaction entry when trying to retrieve transaction workspace.");
        }
        return transactionEntry.getTransactionWorkSpace();
    }

    protected void greedyGetFqns(List<Fqn> list, NodeSPI<?, ?> n, Fqn newBase) {
        list.add(n.getFqn());
        Fqn<Object> newFqn = new Fqn<Object>(newBase, n.getFqn().getLastElement());
        list.add(newFqn);
        for (NodeSPI<?, ?> child : n.getChildrenDirect()) {
            this.greedyGetFqns(list, child, newFqn);
        }
    }

    protected GlobalTransaction getGlobalTransaction(InvocationContext ctx) throws CacheException {
        Transaction tx = ctx.getTransaction();
        if (tx == null) {
            throw new CacheException("Transaction associated with the current invocation is null!");
        }
        GlobalTransaction gtx = ctx.getGlobalTransaction();
        if (gtx == null) {
            throw new CacheException("GlobalTransaction associated with the current invocation is null!");
        }
        return gtx;
    }
}

