/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.interceptors.OptimisticInterceptor;
import org.jboss.cache.marshall.MethodCall;
import org.jboss.cache.optimistic.DataVersioningException;
import org.jboss.cache.optimistic.DefaultDataVersion;
import org.jboss.cache.optimistic.TransactionWorkspace;
import org.jboss.cache.optimistic.WorkspaceNode;
import org.jboss.cache.transaction.GlobalTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptimisticValidatorInterceptor
extends OptimisticInterceptor {
    @Override
    public Object invoke(InvocationContext ctx) throws Throwable {
        MethodCall m = ctx.getMethodCall();
        Object retval = null;
        switch (m.getMethodId()) {
            case 18: {
                this.validateNodes(this.getGlobalTransaction(ctx));
                break;
            }
            case 11: {
                this.commit(this.getGlobalTransaction(ctx));
                break;
            }
            case 12: {
                this.rollBack(this.getGlobalTransaction(ctx));
                break;
            }
            default: {
                retval = super.invoke(ctx);
            }
        }
        return retval;
    }

    private void validateNodes(GlobalTransaction gtx) throws CacheException {
        TransactionWorkspace workspace = this.getTransactionWorkspace(gtx);
        Collection<WorkspaceNode> nodes = workspace.getNodes().values();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Validating " + nodes.size() + " nodes."));
        }
        this.simpleValidate(nodes);
        this.log.debug((Object)"Successfully validated nodes");
    }

    private void simpleValidate(Collection<WorkspaceNode> nodes) throws DataVersioningException {
        for (WorkspaceNode workspaceNode : nodes) {
            NodeSPI underlyingNode;
            Fqn fqn = workspaceNode.getFqn();
            if (this.trace) {
                this.log.trace((Object)("Validating version for node " + fqn));
            }
            if ((underlyingNode = this.cache.peek(fqn, true)) == null && !workspaceNode.isCreated()) {
                throw new DataVersioningException("Underlying node for " + fqn + " is null, and this node wasn't newly created in this transaction!  We have a concurrent deletion event.");
            }
            if (underlyingNode != null && workspaceNode.isCreated() && workspaceNode.isDirty()) {
                throw new DataVersioningException("Transaction attempted to create " + fqn + " anew.  It has already been created since this transaction started, by another (possibly remote) transaction.  We have a concurrent creation event.");
            }
            if (workspaceNode.isCreated() || !workspaceNode.isDeleted() && !workspaceNode.isDirty() || !underlyingNode.getVersion().newerThan(workspaceNode.getVersion())) continue;
            throw new DataVersioningException("Version mismatch for node " + fqn + ": underlying node with version " + workspaceNode.getNode().getVersion() + " is newer than workspace node, with version " + workspaceNode.getVersion());
        }
    }

    private void commit(GlobalTransaction gtx) {
        TransactionWorkspace workspace;
        try {
            workspace = this.getTransactionWorkspace(gtx);
        }
        catch (CacheException e) {
            this.log.warn((Object)"we can't rollback", (Throwable)e);
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Commiting successfully validated changes for GlobalTransaction " + gtx));
        }
        Collection workspaceNodes = workspace.getNodes().values();
        for (WorkspaceNode workspaceNode : workspaceNodes) {
            NodeSPI underlyingNode = workspaceNode.getNode();
            if (workspaceNode.isDeleted()) {
                if (this.trace) {
                    this.log.trace((Object)("Workspace node " + workspaceNode.getFqn() + " deleted; removing"));
                }
                if (underlyingNode.getFqn().isRoot()) {
                    throw new CacheException("An illegal attempt to delete the root node!");
                }
                NodeSPI parent = underlyingNode.getParent();
                if (parent == null) {
                    throw new CacheException("Underlying node " + underlyingNode + " has no parent");
                }
                parent.removeChildDirect(underlyingNode.getFqn().getLastElement());
                continue;
            }
            boolean updateVersion = false;
            if (workspaceNode.isChildrenModified()) {
                this.log.trace((Object)"Updating children since node has modified children");
                List<Set<Fqn>> deltas = workspaceNode.getMergedChildren();
                if (this.trace) {
                    this.log.trace((Object)("Applying children deltas to parent node " + underlyingNode.getFqn()));
                }
                for (Fqn child : deltas.get(0)) {
                    underlyingNode.addChildDirect(workspaceNode.getChild(child.getLastElement()));
                }
                for (Fqn child : deltas.get(1)) {
                    underlyingNode.removeChildDirect(child.getLastElement());
                }
                updateVersion = this.cache.getConfiguration().isLockParentForChildInsertRemove();
            }
            if (workspaceNode.isDirty()) {
                this.log.trace((Object)"Merging data since node is dirty");
                Map mergedData = workspaceNode.getMergedData();
                underlyingNode.clearDataDirect();
                underlyingNode.putAllDirect(mergedData);
                updateVersion = true;
            }
            if (updateVersion) {
                if (workspaceNode.isVersioningImplicit()) {
                    if (this.trace) {
                        this.log.trace((Object)"Versioning is implicit; incrementing.");
                    }
                    underlyingNode.setVersion(((DefaultDataVersion)workspaceNode.getVersion()).increment());
                } else {
                    if (this.trace) {
                        this.log.trace((Object)"Versioning is explicit; not attempting an increment.");
                    }
                    underlyingNode.setVersion(workspaceNode.getVersion());
                }
                if (!this.trace) continue;
                this.log.trace((Object)("Setting version of node " + underlyingNode.getFqn() + " from " + workspaceNode.getVersion() + " to " + underlyingNode.getVersion()));
                continue;
            }
            if (!this.trace) continue;
            this.log.trace((Object)("Version update on " + workspaceNode.getFqn() + " not necessary since the node is not dirty or LockParentForChildInsertRemove is set to false"));
        }
    }

    private void rollBack(GlobalTransaction gtx) {
        TransactionWorkspace workspace = this.getTransactionWorkspace(gtx);
        workspace.clearNodes();
    }
}

