/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.loader.AbstractCacheLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DelegatingCacheLoader
extends AbstractCacheLoader {
    Log log = LogFactory.getLog(this.getClass());
    HashMap<Object, List<Modification>> transactions = new HashMap();
    public static final int delegateGetChildrenNames = 1;
    public static final int delegateGetKey = 2;
    public static final int delegateGet = 3;
    public static final int delegateExists = 4;
    public static final int delegatePutKeyVal = 5;
    public static final int delegatePut = 6;
    public static final int delegateRemoveKey = 7;
    public static final int delegateRemove = 8;
    public static final int delegateRemoveData = 9;
    public static final int delegateLoadEntireState = 10;
    public static final int delegateStoreEntireState = 11;
    public static final int putList = 12;

    public Set<String> getChildrenNames(Fqn fqn) throws Exception {
        Set retval = this.delegateGetChildrenNames(fqn);
        return retval == null ? null : (retval.size() == 0 ? null : retval);
    }

    public Map get(Fqn name) throws Exception {
        return this.delegateGet(name);
    }

    @Override
    public boolean exists(Fqn name) throws Exception {
        return this.delegateExists(name);
    }

    @Override
    public Object put(Fqn name, Object key, Object value) throws Exception {
        return this.delegatePut(name, key, value);
    }

    public void put(Fqn name, Map attributes) throws Exception {
        this.delegatePut(name, attributes);
    }

    public void put(Fqn fqn, Map attributes, boolean erase) throws Exception {
        if (erase) {
            this.removeData(fqn);
        }
        this.put(fqn, attributes);
    }

    @Override
    public Object remove(Fqn name, Object key) throws Exception {
        return this.delegateRemove(name, key);
    }

    @Override
    public void remove(Fqn name) throws Exception {
        this.delegateRemove(name);
    }

    @Override
    public void removeData(Fqn name) throws Exception {
        this.delegateRemoveData(name);
    }

    @Override
    public void prepare(Object tx, List<Modification> modifications, boolean one_phase) throws Exception {
        if (one_phase) {
            this.put(modifications);
        } else {
            this.transactions.put(tx, modifications);
        }
    }

    @Override
    public void commit(Object tx) throws Exception {
        List<Modification> modifications = this.transactions.get(tx);
        if (modifications == null) {
            throw new Exception("transaction " + tx + " not found in transaction table");
        }
        this.put(modifications);
    }

    @Override
    public void rollback(Object tx) {
        this.transactions.remove(tx);
    }

    @Override
    public void loadEntireState(ObjectOutputStream os) throws Exception {
        this.delegateLoadEntireState(os);
    }

    @Override
    public void loadState(Fqn subtree, ObjectOutputStream os) throws Exception {
        this.delegateLoadState(subtree, os);
    }

    @Override
    public void storeEntireState(ObjectInputStream is) throws Exception {
        this.delegateStoreEntireState(is);
    }

    @Override
    public void storeState(Fqn subtree, ObjectInputStream is) throws Exception {
        this.delegateStoreState(subtree, is);
    }

    @Override
    public void create() throws Exception {
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() {
    }

    @Override
    public void destroy() {
    }

    protected abstract Set delegateGetChildrenNames(Fqn var1) throws Exception;

    protected abstract Map delegateGet(Fqn var1) throws Exception;

    protected abstract boolean delegateExists(Fqn var1) throws Exception;

    protected abstract Object delegatePut(Fqn var1, Object var2, Object var3) throws Exception;

    protected abstract void delegatePut(Fqn var1, Map var2) throws Exception;

    protected abstract Object delegateRemove(Fqn var1, Object var2) throws Exception;

    protected abstract void delegateRemove(Fqn var1) throws Exception;

    protected abstract void delegateRemoveData(Fqn var1) throws Exception;

    protected abstract void delegateLoadEntireState(ObjectOutputStream var1) throws Exception;

    protected abstract void delegateLoadState(Fqn var1, ObjectOutputStream var2) throws Exception;

    protected abstract void delegateStoreEntireState(ObjectInputStream var1) throws Exception;

    protected abstract void delegateStoreState(Fqn var1, ObjectInputStream var2) throws Exception;
}

