/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.loader;

import java.io.ObjectInputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.Modification;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.loader.AbstractDelegatingCacheLoader;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.CacheStarted;
import org.jboss.cache.notifications.annotation.CacheStopped;
import org.jboss.cache.notifications.annotation.ViewChanged;
import org.jboss.cache.notifications.event.Event;
import org.jboss.cache.notifications.event.ViewChangedEvent;
import org.jgroups.Address;
import org.jgroups.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonStoreCacheLoader
extends AbstractDelegatingCacheLoader {
    private static final Log log = LogFactory.getLog(SingletonStoreCacheLoader.class);
    private Address localAddress;
    private boolean active;
    private boolean pushStateWhenCoordinator;
    private Thread pushStateThread;
    private Object cacheListener;

    public SingletonStoreCacheLoader(CacheLoader cacheLoader, boolean pushConfiguration) {
        super(cacheLoader);
        this.pushStateWhenCoordinator = pushConfiguration;
        this.cacheListener = new SingletonStoreListener();
    }

    public Object getCacheListener() {
        return this.cacheListener;
    }

    protected void activeStatusChanged(boolean newActiveState) {
        this.active = newActiveState;
        log.debug((Object)("changed mode: " + this));
        if (this.active && this.pushStateWhenCoordinator) {
            if (this.pushStateThread == null || !this.pushStateThread.isAlive()) {
                this.pushStateThread = this.createPushStateThread();
                this.pushStateThread.setName("InMemoryToCacheLoaderPusher");
                this.pushStateThread.start();
            } else {
                try {
                    log.debug((Object)"joining currently running state push thread");
                    this.pushStateThread.join();
                }
                catch (InterruptedException e) {
                    log.error((Object)"joining existing push state thread was interrupted", (Throwable)e);
                }
            }
        }
    }

    protected Thread createPushStateThread() {
        Thread t = new Thread(new Runnable(){

            public void run() {
                log.debug((Object)"start pushing in-memory state to cache cacheLoader");
                try {
                    SingletonStoreCacheLoader.this.pushState(SingletonStoreCacheLoader.this.cache.getRoot());
                    log.debug((Object)"in-memory state passed to cache cacheLoader successfully");
                }
                catch (Exception e) {
                    log.error((Object)"unable to finish pushing the state", (Throwable)e);
                }
            }
        });
        t.setDaemon(true);
        return t;
    }

    private boolean isCoordinator(View newView) {
        if (newView != null && this.localAddress != null) {
            Vector mbrs = newView.getMembers();
            return mbrs != null && mbrs.size() > 0 && this.localAddress.equals(mbrs.firstElement());
        }
        return this.active;
    }

    private void pushState(NodeSPI node) throws Exception {
        Set keys = node.getKeysDirect();
        Fqn fqn = node.getFqn();
        for (Object aKey : keys) {
            Object v = this.cache.get(fqn, aKey);
            this.put(fqn, aKey, v);
        }
        Set children = node.getChildrenDirect();
        for (NodeSPI nodeSPI : children) {
            this.pushState(nodeSPI);
        }
    }

    @Override
    public Object put(Fqn name, Object key, Object value) throws Exception {
        if (this.active) {
            return super.put(name, key, value);
        }
        return null;
    }

    @Override
    public void put(Fqn name, Map attributes) throws Exception {
        if (this.active) {
            super.put(name, attributes);
        }
    }

    @Override
    public void put(List<Modification> modifications) throws Exception {
        if (this.active) {
            super.put(modifications);
        }
    }

    @Override
    public Object remove(Fqn fqn, Object key) throws Exception {
        if (this.active) {
            return super.remove(fqn, key);
        }
        return null;
    }

    @Override
    public void remove(Fqn fqn) throws Exception {
        if (this.active) {
            super.remove(fqn);
        }
    }

    @Override
    public void removeData(Fqn fqn) throws Exception {
        if (this.active) {
            super.removeData(fqn);
        }
    }

    @Override
    public void prepare(Object tx, List<Modification> modifications, boolean one_phase) throws Exception {
        if (this.active) {
            super.prepare(tx, modifications, one_phase);
        }
    }

    @Override
    public void commit(Object tx) throws Exception {
        if (this.active) {
            super.commit(tx);
        }
    }

    @Override
    public void rollback(Object tx) {
        if (this.active) {
            super.rollback(tx);
        }
    }

    @Override
    public void storeEntireState(ObjectInputStream is) throws Exception {
        if (this.active) {
            super.storeEntireState(is);
        }
    }

    @Override
    public void storeState(Fqn subtree, ObjectInputStream is) throws Exception {
        if (this.active) {
            super.storeState(subtree, is);
        }
    }

    public Thread getPushStateThread() {
        return this.pushStateThread;
    }

    public String toString() {
        return "loc_addr=" + this.localAddress + ", active=" + this.active;
    }

    @CacheListener
    public class SingletonStoreListener {
        @CacheStarted
        public void cacheStarted(Event e) {
            SingletonStoreCacheLoader.this.localAddress = SingletonStoreCacheLoader.this.cache.getLocalAddress();
            SingletonStoreCacheLoader.this.active = SingletonStoreCacheLoader.this.cache.getRPCManager().isCoordinator();
            if (log.isDebugEnabled()) {
                log.debug((Object)("cache started: " + this));
            }
        }

        @CacheStopped
        public void cacheStopped(Event e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("cache stopped: " + this));
            }
        }

        @ViewChanged
        public void viewChange(ViewChangedEvent event) {
            boolean tmp = SingletonStoreCacheLoader.this.isCoordinator(event.getNewView());
            if (SingletonStoreCacheLoader.this.active != tmp) {
                SingletonStoreCacheLoader.this.activeStatusChanged(tmp);
            }
        }
    }
}

