/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.transaction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.SequencedCollection;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.transaction.Transaction;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Option;
import org.jboss.cache.lock.IdentityLock;
import org.jboss.cache.lock.NodeLock;
import org.jboss.cache.marshall.MethodCall;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class TransactionEntry {
    private static Log log = LogFactory.getLog(TransactionEntry.class);
    private Transaction ltx = null;
    private Option option;
    private boolean forceAsyncReplication = false;
    private List<MethodCall> modification_list = new LinkedList<MethodCall>();
    private List<MethodCall> cl_mod_list = new CopyOnWriteArrayList<MethodCall>();
    private final List<MethodCall> undo_list = new LinkedList<MethodCall>();
    private LinkedHashSet<NodeLock> locks = new LinkedHashSet();
    private List<Fqn> dummyNodesCreatedByCacheLoader;
    private List<Fqn> removedNodes = new LinkedList<Fqn>();

    public void addModification(MethodCall m) {
        if (m == null) {
            return;
        }
        this.modification_list.add(m);
    }

    public void addCacheLoaderModification(MethodCall m) {
        if (m != null) {
            this.cl_mod_list.add(m);
        }
    }

    public List<MethodCall> getModifications() {
        return this.modification_list;
    }

    public List<MethodCall> getCacheLoaderModifications() {
        return Collections.unmodifiableList(this.cl_mod_list);
    }

    public void addUndoOperation(MethodCall m) {
        this.undo_list.add(m);
    }

    public void addRemovedNode(Fqn fqn) {
        this.removedNodes.add(fqn);
    }

    public List<Fqn> getRemovedNodes() {
        return new ArrayList<Fqn>(this.removedNodes);
    }

    public List<MethodCall> getUndoOperations() {
        return this.undo_list;
    }

    public void setTransaction(Transaction tx) {
        this.ltx = tx;
    }

    public Transaction getTransaction() {
        return this.ltx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLock(NodeLock l) {
        if (l != null) {
            LinkedHashSet<NodeLock> linkedHashSet = this.locks;
            synchronized (linkedHashSet) {
                this.locks.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocks(Collection<NodeLock> newLocks) {
        if (newLocks != null) {
            LinkedHashSet<NodeLock> linkedHashSet = this.locks;
            synchronized (linkedHashSet) {
                this.locks.addAll(newLocks);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NodeLock> getLocks() {
        LinkedHashSet<NodeLock> linkedHashSet = this.locks;
        synchronized (linkedHashSet) {
            return new ArrayList<NodeLock>(this.locks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAllLocksLIFO(Object owner) {
        boolean trace = log.isTraceEnabled();
        LinkedHashSet<NodeLock> linkedHashSet = this.locks;
        synchronized (linkedHashSet) {
            IdentityLock[] lockArray = this.locks.toArray(new IdentityLock[this.locks.size()]);
            for (int i = lockArray.length - 1; i >= 0; --i) {
                if (trace) {
                    log.trace((Object)("releasing lock for " + lockArray[i].getFqn() + " (" + lockArray[i] + ")"));
                }
                lockArray[i].release(owner);
            }
            this.locks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAllLocksFIFO(Object owner) {
        LinkedHashSet<NodeLock> linkedHashSet = this.locks;
        synchronized (linkedHashSet) {
            for (NodeLock lock : this.locks) {
                lock.release(owner);
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)("releasing lock for " + ((IdentityLock)lock).getFqn() + " (" + lock + ")"));
            }
        }
    }

    public boolean isForceAsyncReplication() {
        return this.forceAsyncReplication;
    }

    public void setForceAsyncReplication(boolean forceAsyncReplication) {
        this.forceAsyncReplication = forceAsyncReplication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undoOperations(CacheSPI cache) {
        ArrayList<MethodCall> l;
        if (log.isTraceEnabled()) {
            log.trace((Object)("undoOperations " + this.undo_list));
        }
        List<MethodCall> list = this.undo_list;
        synchronized (list) {
            l = new ArrayList<MethodCall>(this.undo_list);
        }
        ListIterator<MethodCall> i = l.listIterator(l.size());
        while (i.hasPrevious()) {
            MethodCall undo_op = i.previous();
            this.undo(undo_op, cache);
        }
    }

    private void undo(MethodCall undo_op, CacheSPI cache) {
        try {
            Object retval = undo_op.invoke(cache);
            if (retval instanceof Throwable) {
                throw (Throwable)retval;
            }
        }
        catch (Throwable t) {
            log.error((Object)("undo operation failed, error=" + t));
            log.trace((Object)t, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("TransactionEntry\nmodification_list: ").append(this.modification_list);
        SequencedCollection<Object> sequencedCollection = this.undo_list;
        synchronized (sequencedCollection) {
            sb.append("\nundo_list: ").append(this.undo_list);
        }
        sequencedCollection = this.locks;
        synchronized (sequencedCollection) {
            sb.append("\nlocks: ").append(this.locks);
        }
        return sb.toString();
    }

    public void loadUninitialisedNode(Fqn fqn) {
        if (this.dummyNodesCreatedByCacheLoader == null) {
            this.dummyNodesCreatedByCacheLoader = new LinkedList<Fqn>();
        }
        this.dummyNodesCreatedByCacheLoader.add(fqn);
    }

    public List<Fqn> getDummyNodesCreatedByCacheLoader() {
        return this.dummyNodesCreatedByCacheLoader;
    }

    public void setOption(Option o) {
        this.option = o;
    }

    public Option getOption() {
        return this.option;
    }
}

