/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.jdk.handlers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Formatter;
import org.jboss.lang.JBossStringBuilder;
import org.jboss.logging.jdk.handlers.WriterHandler;

public class FileHandler
extends WriterHandler {
    protected boolean fileAppend = true;
    protected String fileName = null;

    public FileHandler() {
    }

    public FileHandler(Formatter layout, String filename, boolean append, boolean bufferedIO, int bufferSize) throws IOException {
        super.setFormatter(layout);
        this.setFile(filename, append, bufferedIO, bufferSize);
    }

    public FileHandler(Formatter layout, String filename, boolean append) throws IOException {
        this(layout, filename, append, true, 2048);
    }

    public FileHandler(Formatter layout, String filename) throws IOException {
        this(layout, filename, true);
    }

    public void setFile(String file) {
        String val;
        this.fileName = val = file.trim();
    }

    public boolean getAppend() {
        return this.fileAppend;
    }

    public String getFile() {
        return this.fileName;
    }

    public void activateOptions() {
        if (this.fileName != null) {
            try {
                this.setFile(this.fileName, this.fileAppend, this.bufferedIO, this.bufferSize);
            }
            catch (IOException e) {
                this.reportError(new JBossStringBuilder().append("setFile(").append(this.fileName).append(",").append(this.fileAppend).append(") call failed.").toString(), e, 4);
            }
        } else {
            this.reportError(new JBossStringBuilder().append("File option not set for appender [").append(this.name).append("].").append(" Are you using FileHandler instead of ConsoleAppender?").toString(), null, 4);
        }
    }

    public void setAppend(boolean flag) {
        this.fileAppend = flag;
    }

    public synchronized void setFile(String fileName, boolean append, boolean bufferedIO, int bufferSize) throws IOException {
        super.setBufferedIO(bufferedIO);
        super.setBufferSize(bufferSize);
        FileOutputStream ostream = null;
        try {
            ostream = new FileOutputStream(fileName, append);
        }
        catch (FileNotFoundException ex) {
            String parentName = new File(fileName).getParent();
            if (parentName != null) {
                File parentDir = new File(parentName);
                if (!parentDir.exists() && parentDir.mkdirs()) {
                    ostream = new FileOutputStream(fileName, append);
                }
                throw ex;
            }
            throw ex;
        }
        super.setOutputStream(ostream);
        this.fileName = fileName;
        this.fileAppend = append;
    }
}

