/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.jdk.handlers;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.jboss.lang.JBossStringBuilder;
import org.jboss.logging.jdk.handlers.HandlerSkeleton;

public class WriterHandler
extends HandlerSkeleton {
    protected boolean immediateFlush = true;
    protected boolean bufferedIO = false;
    protected int bufferSize = 8192;
    private OutputStream msgOutput;
    private Writer msgWriter;
    private boolean wroteHeader;

    public WriterHandler() {
    }

    public WriterHandler(OutputStream output, Formatter formatter) {
        this.setFormatter(formatter);
        this.setOutputStream(output);
    }

    public void setImmediateFlush(boolean value) {
        this.immediateFlush = value;
    }

    public boolean getImmediateFlush() {
        return this.immediateFlush;
    }

    public boolean isBufferedIO() {
        return this.bufferedIO;
    }

    public void setBufferedIO(boolean bufferedIO) {
        this.bufferedIO = bufferedIO;
        if (bufferedIO) {
            this.immediateFlush = false;
        }
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setEncoding(String encoding) throws SecurityException, UnsupportedEncodingException {
        super.setEncoding(encoding);
        if (this.msgOutput == null) {
            return;
        }
        this.flush();
        this.msgWriter = encoding == null ? new OutputStreamWriter(this.msgOutput) : new OutputStreamWriter(this.msgOutput, encoding);
    }

    public synchronized void flush() {
        if (this.msgWriter != null) {
            try {
                this.msgWriter.flush();
            }
            catch (IOException e) {
                this.reportError("Failed to flush writer", e, 2);
            }
        }
    }

    public synchronized void close() {
        if (this.msgWriter != null) {
            try {
                if (!this.wroteHeader) {
                    this.msgWriter.write(this.getFormatter().getHead(this));
                    this.wroteHeader = true;
                }
                this.msgWriter.write(this.getFormatter().getTail(this));
                this.msgWriter.flush();
                this.msgWriter.close();
            }
            catch (Exception ex) {
                this.reportError(null, ex, 3);
            }
            this.msgWriter = null;
            this.msgOutput = null;
        }
    }

    public void publish(LogRecord record) {
        if (!this.checkEntryConditions(record)) {
            return;
        }
        this.subPublish(record);
    }

    protected boolean checkEntryConditions(LogRecord record) {
        boolean canWrite = super.isLoggable(record);
        if (canWrite) {
            canWrite = this.msgWriter != null;
        }
        return canWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void subPublish(LogRecord record) {
        Formatter fmt = this.getFormatter();
        String msg = fmt.format(record);
        WriterHandler writerHandler = this;
        synchronized (writerHandler) {
            try {
                this.msgWriter.write(msg);
            }
            catch (IOException e) {
                this.reportError("Failed to publish recored", e, 1);
            }
            if (this.immediateFlush) {
                this.flush();
            }
        }
    }

    protected synchronized void setOutputStream(OutputStream out) {
        if (out == null) {
            throw new NullPointerException("The out argument cannot be null");
        }
        this.close();
        this.msgOutput = out;
        this.wroteHeader = false;
        String encoding = this.getEncoding();
        if (encoding == null) {
            this.msgWriter = new OutputStreamWriter(this.msgOutput);
        } else {
            try {
                this.msgWriter = new OutputStreamWriter(this.msgOutput, encoding);
            }
            catch (UnsupportedEncodingException ex) {
                throw new Error(new JBossStringBuilder().append("Unexpected exception ").append((Object)ex).toString());
            }
        }
        if (this.bufferedIO) {
            this.msgWriter = new BufferedWriter(this.msgWriter, this.bufferSize);
        }
    }
}

