/*
 * Decompiled with CFR 0.152.
 */
package org.mc4j.ems.impl.jmx.connection;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mc4j.ems.connection.ConnectionTracker;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.EmsException;
import org.mc4j.ems.connection.EmsMalformedObjectNameException;
import org.mc4j.ems.connection.EmsUnsupportedTypeException;
import org.mc4j.ems.connection.MBeanRegistrationEvent;
import org.mc4j.ems.connection.MBeanRegistrationListener;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.support.ConnectionProvider;
import org.mc4j.ems.impl.jmx.connection.bean.DAdvancedBean;
import org.mc4j.ems.impl.jmx.connection.bean.DMBean;
import org.mc4j.ems.impl.jmx.connection.support.providers.AbstractConnectionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DConnection
implements EmsConnection {
    private static Log log = LogFactory.getLog(DConnection.class);
    protected String connectionName;
    protected AbstractConnectionProvider connectionProvider;
    protected SortedMap<DObjectName, EmsBean> beanMap;
    protected boolean loaded;
    protected List<MBeanRegistrationListener> registrationListeners = new ArrayList<MBeanRegistrationListener>();
    static boolean isJMX12 = false;

    public DConnection(String connectionName, ConnectionProvider connectionProvider) {
        this.connectionName = connectionName;
        this.connectionProvider = (AbstractConnectionProvider)connectionProvider;
        this.beanMap = new TreeMap<DObjectName, EmsBean>(new DObjectNameComparator());
    }

    public void setConnectionProvider(AbstractConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    public ConnectionTracker getTracker() {
        return null;
    }

    public void refresh() {
        try {
            this.loadSynchronous(false);
        }
        catch (Exception e) {
            log.warn((Object)("Could not refresh connection [" + this.connectionProvider.getConnectionSettings().getServerUrl() + "] " + e.toString()), (Throwable)e);
        }
    }

    public void close() {
        this.connectionProvider.disconnect();
        LogFactory.release((ClassLoader)this.connectionProvider.getClass().getClassLoader());
    }

    public synchronized void loadSynchronous(boolean deep) {
        if (!this.connectionProvider.isConnected()) {
            this.connectionProvider.connect();
        }
        log.info((Object)"Querying MBeanServer for all MBeans");
        Set<ObjectName> objectNames = null;
        try {
            objectNames = this.connectionProvider.getMBeanServer().queryNames(new ObjectName("*:*"), null);
        }
        catch (MalformedObjectNameException e) {
            // empty catch block
        }
        TreeMap<ObjectName, DMBean> retrievedBeansMap = new TreeMap<ObjectName, DMBean>(new ObjectNameComparator());
        if (!this.loaded) {
            log.info((Object)("Found " + objectNames.size() + " MBeans, starting load"));
        }
        HashSet<DObjectName> currentKeys = new HashSet<DObjectName>(this.beanMap.keySet());
        for (ObjectName objectName : objectNames) {
            DMBean bean = this.mapBean(this.connectionProvider, objectName, deep);
            retrievedBeansMap.put(objectName, bean);
        }
        HashSet<EmsBean> newBeans = new HashSet<EmsBean>();
        HashSet<EmsBean> removedBeans = new HashSet<EmsBean>();
        for (Map.Entry entry : retrievedBeansMap.entrySet()) {
            if (currentKeys.contains(entry.getKey())) continue;
            newBeans.add((EmsBean)entry.getValue());
        }
        for (DObjectName name : currentKeys) {
            if (retrievedBeansMap.containsKey(name.getObjectName())) continue;
            removedBeans.add((EmsBean)this.beanMap.remove(name));
        }
        this.loaded = true;
        this.fireRegistrationEvent(newBeans, removedBeans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DMBean mapBean(ConnectionProvider provider, ObjectName objectName, boolean loadSynchronous) {
        DMBean bean = null;
        DObjectName dObjectName = new DObjectName(objectName);
        DConnection dConnection = this;
        synchronized (dConnection) {
            if (!this.beanMap.keySet().contains(dObjectName)) {
                bean = isJMX12 ? new DAdvancedBean(this.connectionProvider, objectName) : new DMBean(this.connectionProvider, objectName);
                this.beanMap.put(dObjectName, bean);
            }
        }
        if (bean != null && loadSynchronous) {
            try {
                bean.loadSynchronous();
            }
            catch (EmsUnsupportedTypeException e) {
                log.info((Object)("Bean metadata not loaded, unsupported type on [" + objectName.toString() + "]"), (Throwable)e);
            }
        }
        if (bean == null) {
            return (DMBean)this.beanMap.get(dObjectName);
        }
        return bean;
    }

    private void fireRegistrationEvent(Set<EmsBean> added, Set<EmsBean> removed) {
        if (!this.registrationListeners.isEmpty()) {
            MBeanRegistrationEvent event = new MBeanRegistrationEvent(added, removed);
            for (MBeanRegistrationListener listener : this.registrationListeners) {
                listener.registrationChanged(event);
            }
        }
    }

    public synchronized void addRegistrationListener(MBeanRegistrationListener registrationListener) {
        this.registrationListeners.add(registrationListener);
    }

    public synchronized void removeRegistrationListener(MBeanRegistrationListener registrationListener) {
        this.registrationListeners.remove(registrationListener);
    }

    public void createMBean(String className, String objectName) throws EmsException {
        ObjectName on = null;
        try {
            on = new ObjectName(objectName);
            this.connectionProvider.getMBeanServer().createMBean(className, on);
        }
        catch (Exception e) {
            throw new EmsException("Could not create MBean", (Throwable)e);
        }
    }

    public void removeMBean(String objectName) throws EmsException {
        ObjectName on = null;
        try {
            on = new ObjectName(objectName);
            this.connectionProvider.getMBeanServer().unregisterMBean(on);
        }
        catch (Exception e) {
            throw new EmsException("Could not remove MBean", (Throwable)e);
        }
    }

    public synchronized SortedSet<EmsBean> getBeans() {
        if (!this.loaded) {
            this.refresh();
        }
        return new TreeSet<EmsBean>(this.beanMap.values());
    }

    protected EmsBean getBean(ObjectName objectName) {
        return (EmsBean)this.beanMap.get(new DObjectName(objectName));
    }

    public EmsBean getBean(String objectName) {
        try {
            ObjectName name = new ObjectName(objectName);
            return this.getBean(name);
        }
        catch (MalformedObjectNameException e) {
            throw new EmsMalformedObjectNameException("Invalid ObjectName [" + objectName + "]", (Throwable)e);
        }
    }

    public List<EmsBean> queryBeans(ObjectName objectName, QueryExp query) {
        Set<ObjectName> objectNames = this.connectionProvider.getMBeanServer().queryNames(objectName, query);
        ArrayList<EmsBean> results = new ArrayList<EmsBean>();
        for (ObjectName name : objectNames) {
            results.add(this.mapBean(this.connectionProvider, name, false));
        }
        return results;
    }

    public List<EmsBean> queryBeans(String objectName) {
        try {
            ObjectName name = null;
            if (objectName != null) {
                name = new ObjectName(objectName);
            }
            return this.queryBeans(name, null);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Illegal ObjectName " + objectName, e);
        }
    }

    public EmsBean registerBean(String className, String objectName) {
        try {
            ObjectName objName = new ObjectName(objectName);
            ObjectInstance instance = this.connectionProvider.getMBeanServer().createMBean(className, objName);
            return this.mapBean(this.connectionProvider, instance.getObjectName(), false);
        }
        catch (MBeanException e) {
            e.printStackTrace();
            throw new EmsException("Couldn't create MBean", (Throwable)e);
        }
        catch (OperationsException e) {
            throw new EmsException("Couldn't create MBean", (Throwable)e);
        }
        catch (ReflectionException e) {
            throw new EmsException("Couldn't create MBean", (Throwable)e);
        }
    }

    public EmsBean registerBean(String className, String objectName, Object[] params, String[] signature) {
        try {
            ObjectName objName = new ObjectName(objectName);
            ObjectInstance instance = this.connectionProvider.getMBeanServer().createMBean(className, objName, params, signature);
            return this.mapBean(this.connectionProvider, instance.getObjectName(), false);
        }
        catch (MBeanException e) {
            e.printStackTrace();
            throw new EmsException("Couldn't create MBean", (Throwable)e);
        }
        catch (OperationsException e) {
            throw new EmsException("Couldn't create MBean", (Throwable)e);
        }
        catch (ReflectionException e) {
            throw new EmsException("Couldn't create MBean", (Throwable)e);
        }
    }

    public long getRoundTrips() {
        return this.connectionProvider.getRoundTrips();
    }

    public long getFailures() {
        return this.connectionProvider.getFailures();
    }

    public Object buildObjectName(String objectName) throws EmsMalformedObjectNameException {
        try {
            return new ObjectName(objectName);
        }
        catch (MalformedObjectNameException e) {
            throw new EmsMalformedObjectNameException("Object Name not valid [" + objectName + "]", (Throwable)e);
        }
    }

    public ConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    static {
        try {
            Class.forName("javax.management.MBeanServerInvocationHandler");
            isJMX12 = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DObjectNameComparator
    implements Comparator<DObjectName> {
        @Override
        public int compare(DObjectName o1, DObjectName o2) {
            return o1.getObjectName().getCanonicalName().compareTo(o2.getObjectName().getCanonicalName());
        }
    }

    public static class DObjectName {
        private ObjectName objectName;

        public DObjectName(ObjectName objectName) {
            this.objectName = objectName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DObjectName that = (DObjectName)o;
            return this.objectName.getCanonicalName().equals(that.objectName.getCanonicalName());
        }

        public int hashCode() {
            return this.objectName.getCanonicalName().hashCode();
        }

        public int compareTo(DObjectName o) {
            return this.toString().compareTo(o.toString());
        }

        public String toString() {
            return this.objectName.toString();
        }

        public ObjectName getObjectName() {
            return this.objectName;
        }
    }

    private static class ObjectNameComparator
    implements Comparator {
        private ObjectNameComparator() {
        }

        public int compare(Object o1, Object o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }
}

