/*
 * Decompiled with CFR 0.152.
 */
package org.mc4j.ems.impl.jmx.connection.support.providers;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.j2ee.Management;
import javax.naming.Context;
import javax.naming.NamingException;
import org.mc4j.ems.impl.jmx.connection.support.providers.AbstractConnectionProvider;
import org.mc4j.ems.impl.jmx.connection.support.providers.proxy.GenericMBeanServerProxy;

public class WebsphereConnectionProvider
extends AbstractConnectionProvider {
    protected GenericMBeanServerProxy statsProxy;
    protected MBeanServer mbeanServer;
    private Management mejb;
    private static final String MEJB_JNDI = "ejb/mgmt/MEJB";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doConnect() throws Exception {
        Object ctx = null;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            boolean security;
            Class<?> adminClientClass = Class.forName("com.ibm.websphere.management.AdminClient", true, this.getClass().getClassLoader());
            Class<?> adminClientFactoryClass = Class.forName("com.ibm.websphere.management.AdminClientFactory");
            Properties props = new Properties();
            URI serverUrl = new URI(this.connectionSettings.getServerUrl());
            if (serverUrl.getScheme().equalsIgnoreCase("http") || serverUrl.getScheme().equalsIgnoreCase("https")) {
                System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
                props.put(this.getConstant(adminClientClass, "CONNECTOR_TYPE"), this.getConstant(adminClientClass, "CONNECTOR_TYPE_SOAP"));
            } else {
                props.put(this.getConstant(adminClientClass, "CONNECTOR_TYPE"), this.getConstant(adminClientClass, "CONNECTOR_TYPE_RMI"));
            }
            String username = this.connectionSettings.getPrincipal();
            String password = this.connectionSettings.getCredentials();
            boolean bl = security = username != null && !"".equals(username);
            if (security) {
                props.setProperty(this.getConstant(adminClientClass, "CONNECTOR_SECURITY_ENABLED"), "true");
                props.setProperty(this.getConstant(adminClientClass, "USERNAME"), username);
                props.setProperty(this.getConstant(adminClientClass, "PASSWORD"), password);
            } else {
                props.setProperty(this.getConstant(adminClientClass, "CONNECTOR_SECURITY_ENABLED"), "false");
            }
            props.put(this.getConstant(adminClientClass, "CONNECTOR_HOST"), serverUrl.getHost());
            props.put(this.getConstant(adminClientClass, "CONNECTOR_PORT"), String.valueOf(serverUrl.getPort()));
            Method createMethod = adminClientFactoryClass.getMethod("createAdminClient", Properties.class);
            Object adminClient = createMethod.invoke(null, props);
            this.statsProxy = new GenericMBeanServerProxy(adminClient);
            this.mbeanServer = this.statsProxy.buildServerProxy();
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public String getConstant(Class clazz, String name) throws Exception {
        Field field = clazz.getField(name);
        return (String)field.get(null);
    }

    private Management retrieveMEJB(Context ic) {
        try {
            Object objref = ic.lookup(MEJB_JNDI);
            return this.mejb;
        }
        catch (NamingException ne) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    public long getRoundTrips() {
        return this.statsProxy.getRoundTrips();
    }

    public long getFailures() {
        return this.statsProxy.getFailures();
    }
}

