package org.mc4j.ems.impl.jmx.connection.bean;

import org.mc4j.ems.connection.bean.EmsBeanName;
import org.mc4j.ems.connection.EmsMalformedObjectNameException;

import javax.management.ObjectName;
import javax.management.MalformedObjectNameException;
import java.util.Map;

/**
 * Created by IntelliJ IDEA.
 * User: ghinkle
 * Date: Oct 25, 2005
 * Time: 1:18:47 AM
 * To change this template use File | Settings | File Templates.
 */
public class DBeanName implements EmsBeanName {

    private ObjectName objectName;

    public DBeanName(ObjectName objectName) {
        this.objectName = objectName;
    }

    public ObjectName getObjectName() {
        return objectName;
    }


    public String getDomain() {
        return objectName.getDomain();
    }

    public String getCanonicalName() {
        return objectName.getCanonicalName();
    }

    public Map<String,String> getKeyProperties() {
        // TODO: Build an ordered map out of the properties?

        return (Map<String, String>) objectName.getKeyPropertyList();
    }

    public String getKeyProperty(String key) {
        return objectName.getKeyProperty(key);
    }

    public boolean apply(String objectNameFilterString) {
        try {
            return this.objectName.apply(new ObjectName(objectNameFilterString));
        } catch (MalformedObjectNameException e) {
            throw new EmsMalformedObjectNameException("Invalid object name filter [" + objectNameFilterString + "]",e);
        }
    }

    /**
     * Output the generalized objectname string in input format
     * @return
     */
    public String toString() {
        return this.objectName.toString();
    }

    public int compareTo(Object o) {
        if (this == o) return 0;

        return toString().compareTo(((EmsBeanName) o).toString());
    }


    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        final DBeanName dBeanName = (DBeanName) o;

        return objectName.equals(dBeanName.objectName);

    }

    public int hashCode() {
        return objectName.hashCode();
    }
}
