/*
 * Decompiled with CFR 0.152.
 */
package org.mc4j.ems.impl.jmx.connection.support.providers;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnector;
import javax.management.remote.rmi.RMIServer;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import org.mc4j.ems.connection.EmsConnectException;
import org.mc4j.ems.connection.EmsException;
import org.mc4j.ems.impl.jmx.connection.support.providers.AbstractConnectionProvider;
import org.mc4j.ems.impl.jmx.connection.support.providers.proxy.JMXRemotingMBeanServerProxy;
import org.mc4j.ems.impl.jmx.connection.support.providers.proxy.JSR77ManagementMBeanServerProxy;
import org.mc4j.ems.impl.jmx.connection.support.providers.proxy.StatsProxy;

public class JMXRemotingConnectionProvider
extends AbstractConnectionProvider {
    private JMXConnector jmxConnector;
    private MBeanServerConnection serverConnection;
    private MBeanServer mbeanServer;
    private Object mejb;
    private static final String MEJB_JNDI = "ejb/mgmt/MEJB";
    RMIServer sslStub;
    boolean ssl = false;

    protected void doConnect() {
        try {
            ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            JMXServiceURL url = new JMXServiceURL(this.connectionSettings.getServerUrl());
            Hashtable<String, Object> env = new Hashtable<String, Object>();
            if (this.connectionSettings.getInitialContextName() != null && this.connectionSettings.getInitialContextName().trim().length() > 0) {
                env.put("java.naming.factory.initial", this.connectionSettings.getInitialContextName());
            } else {
                env.put("java.naming.factory.initial", "com.sun.jndi.rmi.registry.RegistryContextFactory");
            }
            if (this.connectionSettings.getPrincipal() != null) {
                env.put("java.naming.security.principal", this.connectionSettings.getPrincipal());
            }
            if (this.connectionSettings.getCredentials() != null) {
                env.put("java.naming.security.credentials", this.connectionSettings.getCredentials());
            }
            if (this.connectionSettings.getConnectionType().isUseManagementHome()) {
                InitialContext ctx = new InitialContext(env);
                this.mejb = this.retrieveMEJB(ctx);
            }
            if (this.connectionSettings.getAdvancedProperties() != null) {
                Set<Map.Entry<Object, Object>> entries = this.connectionSettings.getAdvancedProperties().entrySet();
                Iterator<Map.Entry<Object, Object>> i$ = entries.iterator();
                while (i$.hasNext()) {
                    Map.Entry<Object, Object> entry = i$.next();
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    env.put(key, value);
                }
            }
            String[] credentials = new String[]{this.connectionSettings.getPrincipal(), this.connectionSettings.getCredentials()};
            env.put("jmx.remote.credentials", credentials);
            if (this.ssl) {
                this.jmxConnector = new RMIConnector(this.sslStub, null);
            } else {
                this.jmxConnector = JMXConnectorFactory.connect(url, env);
                this.serverConnection = this.jmxConnector.getMBeanServerConnection();
            }
            StatsProxy proxy = null;
            proxy = this.connectionSettings.getConnectionType().isUseManagementHome() ? new JSR77ManagementMBeanServerProxy(this.mejb) : new JMXRemotingMBeanServerProxy(this.serverConnection);
            this.setStatsProxy(proxy);
            this.mbeanServer = proxy.buildServerProxy();
        }
        catch (MalformedURLException e) {
            throw new EmsConnectException("Malformed url", (Throwable)e);
        }
        catch (IOException e) {
            throw new EmsConnectException("IOException: Check service availability", (Throwable)e);
        }
        catch (NamingException e) {
            throw new EmsConnectException("Naming failure", (Throwable)e);
        }
    }

    public boolean isConnected() {
        try {
            this.mbeanServer.queryNames(new ObjectName("*:*"), null);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean testSsl() {
        JMXServiceURL url = null;
        String host = null;
        int port = 0;
        String start = "/jndi/rmi://";
        String end = "/jmxrmi";
        try {
            url = new JMXServiceURL(this.connectionSettings.getServerUrl());
            String path = url.getURLPath();
            if (path.startsWith(start)) {
                String hostAndPort = path.substring(start.length(), path.length() - end.length());
                String[] hp = hostAndPort.split(":");
                host = hp[0];
                port = Integer.parseInt(hp[1]);
            }
            Registry registry = LocateRegistry.getRegistry(host, port, new SslRMIClientSocketFactory());
            this.sslStub = (RMIServer)registry.lookup("jmxrmi");
            this.ssl = true;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                Registry registry = LocateRegistry.getRegistry(url.getHost(), url.getPort());
                this.sslStub = (RMIServer)registry.lookup("jmxrmi");
            }
            catch (RemoteException e1) {
                e1.printStackTrace();
            }
            catch (NotBoundException e1) {
                e1.printStackTrace();
            }
        }
        catch (NotBoundException e) {
            e.printStackTrace();
        }
        return this.ssl;
    }

    public void doDisconnect() throws IOException {
        this.jmxConnector.close();
    }

    private Object retrieveMEJB(Context ic) {
        try {
            Object objref = ic.lookup(MEJB_JNDI);
            Class<?> managementHomeClass = Class.forName("javax.management.j2ee.ManagementHome.class");
            Object managementHome = PortableRemoteObject.narrow((Object)objref, managementHomeClass);
            Method m = managementHomeClass.getMethod("create", new Class[0]);
            Object managementEjb = m.invoke(managementHome, new Object[0]);
            return managementEjb;
        }
        catch (NamingException ne) {
            throw new EmsException("", (Throwable)ne);
        }
        catch (Exception ce) {
            throw new EmsException("", (Throwable)ce);
        }
    }

    public MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }
}

