/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.licenses;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import me.snowdrop.licenses.LicenseSummaryFactory;
import me.snowdrop.licenses.LicensesFileManager;
import me.snowdrop.licenses.LicensesGeneratorException;
import me.snowdrop.licenses.maven.MavenEmbedderFactory;
import me.snowdrop.licenses.maven.MavenProjectFactory;
import me.snowdrop.licenses.maven.ProjectBuildingRequestFactory;
import me.snowdrop.licenses.maven.SnowdropMavenEmbedder;
import me.snowdrop.licenses.properties.GeneratorProperties;
import me.snowdrop.licenses.sanitiser.AliasLicenseSanitiser;
import me.snowdrop.licenses.sanitiser.ExceptionLicenseSanitiser;
import me.snowdrop.licenses.sanitiser.LicenseSanitiser;
import me.snowdrop.licenses.sanitiser.LicenseServiceSanitiser;
import me.snowdrop.licenses.sanitiser.NoopLicenseSanitiser;
import me.snowdrop.licenses.utils.Gav;
import me.snowdrop.licenses.xml.LicenseSummary;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

public class LicensesGenerator {
    private static final String LICENSE_NAMES_FILE = "rh-license-names.json";
    private static final String LICENSE_EXCEPTIONS_FILE = "rh-license-exceptions.json";
    private final ArtifactFactory artifactFactory;
    private final MavenProjectFactory mavenProjectFactory;
    private final LicenseSummaryFactory licenseSummaryFactory;
    private final LicensesFileManager licensesFileManager;

    public LicensesGenerator() throws LicensesGeneratorException {
        this(new GeneratorProperties());
    }

    public LicensesGenerator(GeneratorProperties generatorProperties) throws LicensesGeneratorException {
        MavenEmbedderFactory mavenEmbedderFactory = new MavenEmbedderFactory();
        SnowdropMavenEmbedder mavenEmbedder = mavenEmbedderFactory.getSnowdropMavenEmbedder();
        ProjectBuildingRequestFactory projectBuildingRequestFactory = new ProjectBuildingRequestFactory(generatorProperties, mavenEmbedder);
        PlexusContainer container = mavenEmbedder.getPlexusContainer();
        try {
            ProjectBuilder projectBuilder = (ProjectBuilder)container.lookup(ProjectBuilder.class);
            this.mavenProjectFactory = new MavenProjectFactory(projectBuilder, projectBuildingRequestFactory);
            this.artifactFactory = (ArtifactFactory)container.lookup(ArtifactFactory.class);
        }
        catch (ComponentLookupException e) {
            throw new LicensesGeneratorException(e.getMessage(), e);
        }
        this.licenseSummaryFactory = LicensesGenerator.createLicenseSummaryFactory(generatorProperties);
        this.licensesFileManager = new LicensesFileManager();
    }

    public void generateLicensesForPom(String pomPath, String resultPath) throws LicensesGeneratorException {
        List<MavenProject> mavenProjects = this.mavenProjectFactory.getMavenProjects(new File(pomPath), true);
        Set<Artifact> artifacts = mavenProjects.stream().map(MavenProject::getArtifacts).flatMap(Collection::stream).collect(Collectors.toSet());
        this.generateLicensesForArtifacts(artifacts, resultPath);
    }

    public void generateLicensesForGavs(Collection<Gav> gavs, String resultPath) throws LicensesGeneratorException {
        Set<Artifact> artifacts = gavs.parallelStream().map(this::gavToArtifact).collect(Collectors.toSet());
        this.generateLicensesForArtifacts(artifacts, resultPath);
    }

    private void generateLicensesForArtifacts(Collection<Artifact> artifacts, String resultPath) throws LicensesGeneratorException {
        Set<MavenProject> mavenProjects = artifacts.parallelStream().map(a -> this.mavenProjectFactory.getMavenProject((Artifact)a, false)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        LicenseSummary licenseSummary = this.licenseSummaryFactory.getLicenseSummary(mavenProjects);
        this.licensesFileManager.createLicensesXml(licenseSummary, resultPath);
        this.licensesFileManager.createLicensesHtml(licenseSummary, resultPath);
    }

    private Artifact gavToArtifact(Gav gav) {
        return this.artifactFactory.createArtifact(gav.getGroupId(), gav.getArtifactId(), gav.getVersion(), null, gav.getType());
    }

    protected static LicenseSummaryFactory createLicenseSummaryFactory(GeneratorProperties generatorProperties) {
        NoopLicenseSanitiser noopLicenseSanitiser = new NoopLicenseSanitiser();
        AliasLicenseSanitiser aliasLicenseSanitiser = new AliasLicenseSanitiser(LICENSE_NAMES_FILE, noopLicenseSanitiser);
        Optional<LicenseSanitiser> maybeExternalLicenseSanitiser = generatorProperties.getLicenseServiceUrl().map(url -> new LicenseServiceSanitiser((String)url, aliasLicenseSanitiser));
        LicenseSanitiser secondSanitiser = maybeExternalLicenseSanitiser.orElse(aliasLicenseSanitiser);
        ExceptionLicenseSanitiser exceptionLicenseSanitiser = new ExceptionLicenseSanitiser(LICENSE_EXCEPTIONS_FILE, secondSanitiser);
        return new LicenseSummaryFactory(exceptionLicenseSanitiser);
    }
}

