/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.licenses.sanitiser;

import java.util.Optional;
import java.util.Set;
import me.snowdrop.licenses.sanitiser.LicenseSanitiser;
import me.snowdrop.licenses.sanitiser.RedHatLicense;
import me.snowdrop.licenses.utils.JsonUtils;
import me.snowdrop.licenses.xml.DependencyElement;
import me.snowdrop.licenses.xml.LicenseElement;

public class AliasLicenseSanitiser
implements LicenseSanitiser {
    private final Set<RedHatLicense> redHatLicenses;
    private final LicenseSanitiser next;

    public AliasLicenseSanitiser(String namesFilePath, LicenseSanitiser next) {
        this.redHatLicenses = JsonUtils.loadJsonToSet(namesFilePath, RedHatLicense::new);
        this.next = next;
    }

    @Override
    public DependencyElement fix(DependencyElement originalDependencyElement) {
        boolean shouldCallNext = false;
        DependencyElement dependencyElement = new DependencyElement(originalDependencyElement);
        for (LicenseElement licenseElement : dependencyElement.getLicenses()) {
            Optional<RedHatLicense> redHatLicenseOptional = this.getRedHatLicenseByUrl(licenseElement.getUrl());
            if (!redHatLicenseOptional.isPresent()) {
                redHatLicenseOptional = this.getRedHatLicenseByName(licenseElement.getName());
            }
            if (redHatLicenseOptional.isPresent()) {
                RedHatLicense redHatLicense = redHatLicenseOptional.get();
                licenseElement.setName(redHatLicense.getName());
                licenseElement.setUrl(redHatLicense.getUrl());
            } else {
                shouldCallNext = true;
            }
            if (licenseElement.getTextUrl() != null) continue;
            licenseElement.setTextUrl(licenseElement.getUrl());
        }
        if (shouldCallNext) {
            return this.next.fix(dependencyElement);
        }
        return dependencyElement;
    }

    private Optional<RedHatLicense> getRedHatLicenseByUrl(String url) {
        if (url == null) {
            return Optional.empty();
        }
        return this.redHatLicenses.stream().filter(l -> l.getUrlAliases().contains(url.toLowerCase())).findFirst();
    }

    private Optional<RedHatLicense> getRedHatLicenseByName(String name) {
        if (name == null) {
            return Optional.empty();
        }
        return this.redHatLicenses.stream().filter(l -> l.getAliases().contains(name.toLowerCase())).findFirst();
    }
}

