/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.licenses.sanitiser;

import java.util.Set;
import java.util.stream.Collectors;
import javax.json.JsonObject;
import javax.json.JsonString;
import me.snowdrop.licenses.xml.LicenseElement;

public class RedHatLicense {
    private String name;
    private String url;
    private Set<String> aliases;
    private Set<String> urlAliases;

    public RedHatLicense(JsonObject jsonObject) {
        this.name = jsonObject.getString("name");
        this.url = jsonObject.getString("url");
        this.aliases = jsonObject.getJsonArray("aliases").getValuesAs(JsonString.class).stream().map(JsonString::getString).map(String::toLowerCase).map(String::trim).collect(Collectors.toSet());
        this.urlAliases = jsonObject.getJsonArray("urlAliases").getValuesAs(JsonString.class).stream().map(JsonString::getString).map(String::toLowerCase).map(String::trim).collect(Collectors.toSet());
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public Set<String> getAliases() {
        return this.aliases;
    }

    public Set<String> getUrlAliases() {
        return this.urlAliases;
    }

    public LicenseElement toLicenseElement() {
        return new LicenseElement(this.name, this.url);
    }
}

