/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.licenses.sanitiser.provider;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import me.snowdrop.licenses.LicensesGeneratorException;
import me.snowdrop.licenses.sanitiser.provider.ExternalLicenseDto;
import me.snowdrop.licenses.sanitiser.provider.ExternalLicensesDto;
import me.snowdrop.licenses.xml.LicenseElement;

public class ExternalLicenseProvider {
    private final Logger logger = Logger.getLogger(ExternalLicenseProvider.class.getSimpleName());
    private final WebTarget webTarget;

    public ExternalLicenseProvider(String licenseServiceUrl) {
        this.webTarget = ClientBuilder.newClient().target(licenseServiceUrl);
    }

    public Set<LicenseElement> getLicenses(String gav) {
        block6: {
            try (Response response = this.webTarget.queryParam("gav", new Object[]{gav}).request().get();){
                Set<LicenseElement> licenses;
                if (response.getStatus() != 200) {
                    this.logger.warning("Unable to get license information for " + gav);
                    break block6;
                }
                String content = (String)response.readEntity(String.class);
                Set<LicenseElement> set = licenses = this.parseLicenses(content).stream().flatMap(dto -> dto.getLicenses().stream()).map(ExternalLicenseDto::toLicenseElement).collect(Collectors.toSet());
                return set;
            }
        }
        return Collections.emptySet();
    }

    private List<ExternalLicensesDto> parseLicenses(String content) throws LicensesGeneratorException {
        ObjectMapper mapper = new ObjectMapper();
        TypeFactory typeFactory = mapper.getTypeFactory();
        CollectionType licenseList = typeFactory.constructCollectionType(List.class, ExternalLicensesDto.class);
        try {
            return (List)mapper.readValue(content, (JavaType)licenseList);
        }
        catch (IOException e) {
            throw new LicensesGeneratorException("Unable to parse EAP licenses: " + content, e);
        }
    }
}

