/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.licenses.sanitiser;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import me.snowdrop.licenses.maven.MavenProjectFactory;
import me.snowdrop.licenses.sanitiser.LicenseSanitiser;
import me.snowdrop.licenses.xml.DependencyElement;
import me.snowdrop.licenses.xml.LicenseElement;
import org.apache.maven.project.MavenProject;

public class MavenSanitiser
implements LicenseSanitiser {
    private final MavenProjectFactory mavenProjectFactory;
    private final LicenseSanitiser next;

    public MavenSanitiser(MavenProjectFactory mavenProjectFactory, LicenseSanitiser next) {
        this.mavenProjectFactory = mavenProjectFactory;
        this.next = next;
    }

    @Override
    public DependencyElement fix(DependencyElement dependencyElement) {
        DependencyElement result;
        Set<LicenseElement> licenses = dependencyElement.getLicenses();
        if (licenses == null || licenses.isEmpty()) {
            Optional<MavenProject> mavenProject = this.mavenProjectFactory.getMavenProject(dependencyElement.getArtifact(), false);
            Set<LicenseElement> licensesFromPom = mavenProject.orElseThrow(() -> new RuntimeException("Unable to find licenses neither through maven or previous sanitisers for " + dependencyElement)).getLicenses().stream().map(LicenseElement::new).collect(Collectors.toSet());
            result = new DependencyElement(dependencyElement, licensesFromPom);
        } else {
            result = dependencyElement;
        }
        return this.next.fix(result);
    }
}

