/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.licenses.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonValue;

public interface JsonUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> Set<T> loadJsonToSet(String resourceLocation, Function<JsonObject, T> mapper) {
        try (InputStream fileInputStream = JsonUtils.class.getClassLoader().getResourceAsStream(resourceLocation);){
            Set set = Json.createReader((InputStream)fileInputStream).readArray().stream().map(JsonValue::asJsonObject).map(mapper).collect(Collectors.toSet());
            return set;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read the resource: " + resourceLocation, e);
        }
    }
}

