/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.activemq.artemis.rest.integration;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

import org.apache.activemq.artemis.rest.MessageServiceManager;
import org.jboss.resteasy.spi.Registry;

public class RestMessagingBootstrapListener implements ServletContextListener {

   MessageServiceManager manager;

   public void contextInitialized(ServletContextEvent contextEvent) {
      ServletContext context = contextEvent.getServletContext();
      String configfile = context.getInitParameter("rest.messaging.config.file");
      Registry registry = (Registry) context.getAttribute(Registry.class.getName());
      if (registry == null) {
         throw new RuntimeException("You must install RESTEasy as a Bootstrap Listener and it must be listed before this class");
      }
      manager = new MessageServiceManager();

      if (configfile != null) {
         manager.setConfigResourcePath(configfile);
      }
      try {
         manager.start();
         registry.addSingletonResource(manager.getQueueManager().getDestination());
         registry.addSingletonResource(manager.getTopicManager().getDestination());
      }
      catch (Exception e) {
         throw new RuntimeException(e);
      }
   }

   public void contextDestroyed(ServletContextEvent servletContextEvent) {
      if (manager != null) {
         manager.stop();
      }
   }
}