/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server;

import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.filter.FilterUtils;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.cursor.PageSubscription;

public final class QueueConfig {
    private final long id;
    private final SimpleString address;
    private final SimpleString name;
    private final Filter filter;
    private final PageSubscription pageSubscription;
    private final SimpleString user;
    private final boolean durable;
    private final boolean temporary;
    private final boolean autoCreated;

    public static Builder builderWith(long id, SimpleString name) {
        return new Builder(id, name);
    }

    public static Builder builderWith(long id, SimpleString name, SimpleString address) {
        return new Builder(id, name, address);
    }

    private QueueConfig(long id, SimpleString address, SimpleString name, Filter filter, PageSubscription pageSubscription, SimpleString user, boolean durable, boolean temporary, boolean autoCreated) {
        this.id = id;
        this.address = address;
        this.name = name;
        this.filter = filter;
        this.pageSubscription = pageSubscription;
        this.user = user;
        this.durable = durable;
        this.temporary = temporary;
        this.autoCreated = autoCreated;
    }

    public long id() {
        return this.id;
    }

    public SimpleString address() {
        return this.address;
    }

    public SimpleString name() {
        return this.name;
    }

    public Filter filter() {
        return this.filter;
    }

    public PageSubscription pageSubscription() {
        return this.pageSubscription;
    }

    public SimpleString user() {
        return this.user;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public boolean isAutoCreated() {
        return this.autoCreated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueueConfig that = (QueueConfig)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.durable != that.durable) {
            return false;
        }
        if (this.temporary != that.temporary) {
            return false;
        }
        if (this.autoCreated != that.autoCreated) {
            return false;
        }
        if (this.address != null ? !this.address.equals((Object)that.address) : that.address != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals((Object)that.name) : that.name != null) {
            return false;
        }
        if (this.filter != null ? !this.filter.equals(that.filter) : that.filter != null) {
            return false;
        }
        if (this.pageSubscription != null ? !this.pageSubscription.equals(that.pageSubscription) : that.pageSubscription != null) {
            return false;
        }
        return this.user != null ? this.user.equals((Object)that.user) : that.user == null;
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
        result = 31 * result + (this.pageSubscription != null ? this.pageSubscription.hashCode() : 0);
        result = 31 * result + (this.user != null ? this.user.hashCode() : 0);
        result = 31 * result + (this.durable ? 1 : 0);
        result = 31 * result + (this.temporary ? 1 : 0);
        result = 31 * result + (this.autoCreated ? 1 : 0);
        return result;
    }

    public String toString() {
        return "QueueConfig{id=" + this.id + ", address=" + this.address + ", name=" + this.name + ", filter=" + this.filter + ", pageSubscription=" + this.pageSubscription + ", user=" + this.user + ", durable=" + this.durable + ", temporary=" + this.temporary + ", autoCreated=" + this.autoCreated + '}';
    }

    public static final class Builder {
        private final long id;
        private final SimpleString address;
        private final SimpleString name;
        private Filter filter;
        private PagingManager pagingManager;
        private SimpleString user;
        private boolean durable;
        private boolean temporary;
        private boolean autoCreated;

        private Builder(long id, SimpleString name) {
            this(id, name, name);
        }

        private Builder(long id, SimpleString name, SimpleString address) {
            this.id = id;
            this.name = name;
            this.address = address;
            this.filter = null;
            this.pagingManager = null;
            this.user = null;
            this.durable = true;
            this.temporary = false;
            this.autoCreated = true;
            this.validateState();
        }

        private static boolean isEmptyOrNull(SimpleString value) {
            return value == null || value.length() == 0;
        }

        private void validateState() {
            if (Builder.isEmptyOrNull(this.name)) {
                throw new IllegalStateException("name can't be null or empty!");
            }
            if (Builder.isEmptyOrNull(this.address)) {
                throw new IllegalStateException("address can't be null or empty!");
            }
        }

        public Builder filter(Filter filter) {
            this.filter = filter;
            return this;
        }

        public Builder pagingManager(PagingManager pagingManager) {
            this.pagingManager = pagingManager;
            return this;
        }

        public Builder user(SimpleString user) {
            this.user = user;
            return this;
        }

        public Builder durable(boolean durable) {
            this.durable = durable;
            return this;
        }

        public Builder temporary(boolean temporary) {
            this.temporary = temporary;
            return this;
        }

        public Builder autoCreated(boolean autoCreated) {
            this.autoCreated = autoCreated;
            return this;
        }

        public QueueConfig build() {
            PageSubscription pageSubscription;
            if (this.pagingManager != null && !FilterUtils.isTopicIdentification(this.filter)) {
                try {
                    pageSubscription = this.pagingManager.getPageStore(this.address).getCursorProvider().createSubscription(this.id, this.filter, this.durable);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            } else {
                pageSubscription = null;
            }
            return new QueueConfig(this.id, this.address, this.name, this.filter, pageSubscription, this.user, this.durable, this.temporary, this.autoCreated);
        }
    }
}

