/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.util.Average;
import org.jgroups.util.Tuple;

public class CreditMap {
    protected final long max_credits;
    protected final Map<Address, Long> credits = new HashMap<Address, Long>();
    protected long min_credits;
    protected long accumulated_credits;
    protected final Lock lock = new ReentrantLock();
    protected final Condition credits_available = this.lock.newCondition();
    protected int num_blockings;
    protected final Average avg_block_time = new Average();

    public CreditMap(long max_credits) {
        this.max_credits = max_credits;
        this.min_credits = max_credits;
    }

    public long getAccumulatedCredits() {
        return this.accumulated_credits;
    }

    public long getMinCredits() {
        return this.min_credits;
    }

    public int getNumBlockings() {
        return this.num_blockings;
    }

    public double getAverageBlockTime() {
        return this.avg_block_time.getAverage() / 1000000.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Address> keys() {
        this.lock.lock();
        try {
            Set<Address> set = this.credits.keySet();
            return set;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long get(Address member) {
        this.lock.lock();
        try {
            Long l = this.credits.get(member);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long remove(Address key) {
        this.lock.lock();
        try {
            Long retval = this.credits.remove(key);
            this.flushAccumulatedCredits();
            long new_min = this.computeLowestCredit();
            if (new_min > this.min_credits) {
                this.min_credits = new_min;
                this.credits_available.signalAll();
            }
            Long l = retval;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long putIfAbsent(Address key) {
        this.lock.lock();
        try {
            this.flushAccumulatedCredits();
            Long val = this.credits.get(key);
            Long l = val != null ? val : this.credits.put(key, this.max_credits);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Address> getMembersWithInsufficientCredits(long credit_needed) {
        LinkedList<Address> retval = new LinkedList<Address>();
        this.lock.lock();
        try {
            if (credit_needed > this.min_credits) {
                this.flushAccumulatedCredits();
                for (Map.Entry<Address, Long> entry : this.credits.entrySet()) {
                    if (entry.getValue() >= credit_needed) continue;
                    retval.add(entry.getKey());
                }
            }
            LinkedList<Address> linkedList = retval;
            return linkedList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Tuple<Address, Long>> getMembersWithCreditsLessThan(long min_credits) {
        LinkedList<Tuple<Address, Long>> retval = new LinkedList<Tuple<Address, Long>>();
        this.lock.lock();
        try {
            this.flushAccumulatedCredits();
            for (Map.Entry<Address, Long> entry : this.credits.entrySet()) {
                if (entry.getValue() > min_credits) continue;
                retval.add(new Tuple<Address, Long>(entry.getKey(), entry.getValue()));
            }
            LinkedList<Tuple<Address, Long>> linkedList = retval;
            return linkedList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean decrement(long credits, long timeout) {
        this.lock.lock();
        try {
            if (this.decrement(credits)) {
                boolean bl = true;
                return bl;
            }
            if (timeout <= 0L) {
                boolean bl = false;
                return bl;
            }
            long start = System.nanoTime();
            try {
                this.credits_available.await(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
            }
            finally {
                ++this.num_blockings;
                this.avg_block_time.add(System.nanoTime() - start);
            }
            boolean bl = this.decrement(credits);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replenish(Address sender, long new_credits) {
        if (sender == null) {
            return;
        }
        this.lock.lock();
        try {
            long new_min;
            Long val = this.credits.get(sender);
            if (val == null) {
                return;
            }
            boolean potential_update = val - this.accumulated_credits <= this.min_credits;
            this.decrementAndAdd(sender, new_credits);
            if (potential_update && (new_min = this.computeLowestCredit()) > this.min_credits) {
                this.min_credits = new_min;
                this.credits_available.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replenishAll() {
        this.lock.lock();
        try {
            this.flushAccumulatedCredits();
            for (Map.Entry<Address, Long> entry : this.credits.entrySet()) {
                entry.setValue(this.max_credits);
            }
            this.min_credits = this.computeLowestCredit();
            this.credits_available.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.lock.lock();
        try {
            this.num_blockings = 0;
            this.avg_block_time.clear();
            this.credits.clear();
            this.credits_available.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.lock.lock();
        try {
            this.num_blockings = 0;
            this.avg_block_time.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.lock.lock();
        try {
            for (Map.Entry<Address, Long> entry : this.credits.entrySet()) {
                sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
            }
            sb.append("min_credits=" + this.min_credits + ", accumulated=" + this.accumulated_credits);
        }
        finally {
            this.lock.unlock();
        }
        return sb.toString();
    }

    protected boolean decrement(long credits) {
        if (credits <= this.min_credits) {
            this.accumulated_credits += credits;
            this.min_credits -= credits;
            return true;
        }
        return false;
    }

    protected long computeLowestCredit() {
        long lowest = this.max_credits;
        for (long cred : this.credits.values()) {
            lowest = Math.min(cred, lowest);
        }
        return lowest;
    }

    public long computeLowestCreditWithAccumulated() {
        long lowest = this.max_credits;
        for (long cred : this.credits.values()) {
            lowest = Math.min(cred, lowest);
        }
        return lowest - this.accumulated_credits;
    }

    protected void decrementAndAdd(Address member, long new_credits) {
        Long val;
        boolean replenish;
        boolean bl = replenish = member != null && new_credits > 0L;
        if (this.accumulated_credits > 0L) {
            for (Map.Entry<Address, Long> entry : this.credits.entrySet()) {
                Address tmp;
                entry.setValue(Math.max(0L, entry.getValue() - this.accumulated_credits));
                if (!replenish || !(tmp = entry.getKey()).equals(member)) continue;
                entry.setValue(Math.min(this.max_credits, entry.getValue() + new_credits));
            }
            this.accumulated_credits = 0L;
        } else if (replenish && (val = this.credits.get(member)) != null) {
            this.credits.put(member, Math.min(this.max_credits, val + new_credits));
        }
    }

    protected void flushAccumulatedCredits() {
        if (this.accumulated_credits > 0L) {
            for (Map.Entry<Address, Long> entry : this.credits.entrySet()) {
                entry.setValue(Math.max(0L, entry.getValue() - this.accumulated_credits));
            }
            this.accumulated_credits = 0L;
        }
    }
}

