/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.openwire.amq;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.client.impl.ClientConsumerImpl;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireMessageConverter;
import org.apache.activemq.artemis.core.protocol.openwire.amq.AMQSession;
import org.apache.activemq.artemis.core.protocol.openwire.util.OpenWireUtil;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.QueueQueryResult;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerMessage;
import org.apache.activemq.artemis.core.server.SlowConsumerDetectionListener;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConsumerControl;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.MessagePull;
import org.apache.activemq.wireformat.WireFormat;

public class AMQConsumer {
    private AMQSession session;
    private ActiveMQDestination openwireDestination;
    private ConsumerInfo info;
    private final ScheduledExecutorService scheduledPool;
    private ServerConsumer serverConsumer;
    private int prefetchSize;
    private AtomicInteger currentWindow;
    private long messagePullSequence = 0L;
    private MessagePullHandler messagePullHandler;

    public AMQConsumer(AMQSession amqSession, ActiveMQDestination d, ConsumerInfo info, ScheduledExecutorService scheduledPool) {
        this.session = amqSession;
        this.openwireDestination = d;
        this.info = info;
        this.scheduledPool = scheduledPool;
        this.prefetchSize = info.getPrefetchSize();
        this.currentWindow = new AtomicInteger(this.prefetchSize);
        if (this.prefetchSize == 0) {
            this.messagePullHandler = new MessagePullHandler();
        }
    }

    public void init(SlowConsumerDetectionListener slowConsumerDetectionListener, long nativeId) throws Exception {
        SimpleString selector = this.info.getSelector() == null ? null : new SimpleString(this.info.getSelector());
        String physicalName = OpenWireUtil.convertWildcard(this.openwireDestination.getPhysicalName());
        if (this.openwireDestination.isTopic()) {
            SimpleString address = this.openwireDestination.isTemporary() ? new SimpleString("jms.temptopic." + physicalName) : new SimpleString("jms.topic." + physicalName);
            SimpleString queueName = this.createTopicSubscription(this.info.isDurable(), this.info.getClientId(), physicalName, this.info.getSubscriptionName(), selector, address);
            this.serverConsumer = this.session.getCoreSession().createConsumer(nativeId, queueName, null, this.info.isBrowser(), false, Integer.valueOf(-1));
            this.serverConsumer.setlowConsumerDetection(slowConsumerDetectionListener);
        } else {
            SimpleString queueName = OpenWireUtil.toCoreAddress(this.openwireDestination);
            this.session.getCoreServer().getJMSDestinationCreator().create(queueName);
            this.serverConsumer = this.session.getCoreSession().createConsumer(nativeId, queueName, selector, this.info.isBrowser(), false, Integer.valueOf(-1));
            this.serverConsumer.setlowConsumerDetection(slowConsumerDetectionListener);
            AddressSettings addrSettings = (AddressSettings)this.session.getCoreServer().getAddressSettingsRepository().getMatch(queueName.toString());
            if (addrSettings != null && this.info.getPrefetchSize() != 0 && addrSettings.getQueuePrefetch() == 0) {
                ConsumerControl cc = new ConsumerControl();
                cc.setConsumerId(this.info.getConsumerId());
                cc.setPrefetch(0);
                this.session.getConnection().dispatch((Command)cc);
            }
        }
        this.serverConsumer.setProtocolData((Object)this);
    }

    private SimpleString createTopicSubscription(boolean isDurable, String clientID, String physicalName, String subscriptionName, SimpleString selector, SimpleString address) throws Exception {
        SimpleString queueName;
        if (isDurable) {
            queueName = new SimpleString(org.apache.activemq.artemis.jms.client.ActiveMQDestination.createQueueNameForDurableSubscription((boolean)true, (String)clientID, (String)subscriptionName));
            QueueQueryResult result = this.session.getCoreSession().executeQueueQuery(queueName);
            if (result.isExists()) {
                boolean topicChanged;
                if (result.getConsumerCount() > 0) {
                    throw new IllegalStateException("Cannot create a subscriber on the durable subscription since it already has subscriber(s)");
                }
                SimpleString oldFilterString = result.getFilterString();
                boolean selectorChanged = selector == null && oldFilterString != null || oldFilterString == null && selector != null || oldFilterString != null && selector != null && !oldFilterString.equals((Object)selector);
                SimpleString oldTopicName = result.getAddress();
                boolean bl = topicChanged = !oldTopicName.equals((Object)address);
                if (selectorChanged || topicChanged) {
                    this.session.getCoreSession().deleteQueue(queueName);
                    this.session.getCoreSession().createQueue(address, queueName, selector, false, true);
                }
            } else {
                this.session.getCoreSession().createQueue(address, queueName, selector, false, true);
            }
        } else {
            queueName = new SimpleString(UUID.randomUUID().toString());
            this.session.getCoreSession().createQueue(address, queueName, selector, true, false);
        }
        return queueName;
    }

    public ConsumerId getId() {
        return this.info.getConsumerId();
    }

    public WireFormat getMarshaller() {
        return this.session.getMarshaller();
    }

    public void acquireCredit(int n) throws Exception {
        boolean promptDelivery;
        if (this.messagePullHandler != null) {
            return;
        }
        int oldwindow = this.currentWindow.getAndAdd(n);
        boolean bl = promptDelivery = oldwindow < this.prefetchSize;
        if (promptDelivery) {
            this.serverConsumer.promptDelivery();
        }
    }

    public int handleDeliver(MessageReference reference, ServerMessage message, int deliveryCount) {
        try {
            if (this.messagePullHandler != null && !this.messagePullHandler.checkForcedConsumer(message)) {
                return 0;
            }
            MessageDispatch dispatch = OpenWireMessageConverter.createMessageDispatch(reference, message, this);
            int size = dispatch.getMessage().getSize();
            reference.setProtocolData((Object)dispatch.getMessage().getMessageId());
            this.session.deliverMessage(dispatch);
            this.currentWindow.decrementAndGet();
            return size;
        }
        catch (IOException e) {
            ActiveMQServerLogger.LOGGER.warn((Object)"Error during message dispatch", (Throwable)e);
            return 0;
        }
        catch (Throwable t) {
            ActiveMQServerLogger.LOGGER.warn((Object)"Error during message dispatch", t);
            return 0;
        }
    }

    public void handleDeliverNullDispatch() {
        MessageDispatch md = new MessageDispatch();
        md.setConsumerId(this.getId());
        md.setDestination(this.openwireDestination);
        this.session.deliverMessage(md);
    }

    public void acknowledge(MessageAck ack) throws Exception {
        boolean removeReferences;
        MessageId first = ack.getFirstMessageId();
        MessageId last = ack.getLastMessageId();
        if (first == null) {
            first = last;
        }
        boolean bl = removeReferences = !this.serverConsumer.isBrowseOnly();
        if (ack.isRedeliveredAck() || ack.isDeliveredAck() || ack.isExpiredAck()) {
            removeReferences = false;
        }
        List ackList = this.serverConsumer.getDeliveringReferencesBasedOnProtocol(removeReferences, (Object)first, (Object)last);
        this.acquireCredit(ack.getMessageCount());
        if (removeReferences) {
            Transaction originalTX = this.session.getCoreSession().getCurrentTransaction();
            Transaction transaction = originalTX == null ? this.session.getCoreSession().newTransaction() : originalTX;
            if (ack.isIndividualAck() || ack.isStandardAck()) {
                for (MessageReference ref : ackList) {
                    ref.acknowledge(transaction);
                }
            } else if (ack.isPoisonAck()) {
                for (MessageReference ref : ackList) {
                    Throwable poisonCause = ack.getPoisonCause();
                    if (poisonCause != null) {
                        ref.getMessage().putStringProperty("__HDR_dlqDeliveryFailureCause", poisonCause.toString());
                    }
                    ref.getQueue().sendToDeadLetterAddress(transaction, ref);
                }
            }
            if (originalTX == null) {
                transaction.commit(true);
            }
        }
        if (ack.isExpiredAck()) {
            this.serverConsumer.getQueue().decDelivering(ackList.size());
        }
    }

    public void browseFinished() {
        MessageDispatch md = new MessageDispatch();
        md.setConsumerId(this.info.getConsumerId());
        md.setMessage(null);
        md.setDestination(null);
        this.session.deliverMessage(md);
    }

    public ConsumerInfo getInfo() {
        return this.info;
    }

    public boolean hasCredits() {
        return this.currentWindow.get() > 0;
    }

    public void processMessagePull(MessagePull messagePull) throws Exception {
        this.currentWindow.incrementAndGet();
        if (this.messagePullHandler != null) {
            this.messagePullHandler.nextSequence(this.messagePullSequence++, messagePull.getTimeout());
        }
    }

    public void removeConsumer() throws Exception {
        this.serverConsumer.close(false);
    }

    public ActiveMQDestination getOpenwireDestination() {
        return this.openwireDestination;
    }

    public void setPrefetchSize(int prefetchSize) {
        this.prefetchSize = prefetchSize;
        this.currentWindow.set(prefetchSize);
        this.info.setPrefetchSize(prefetchSize);
        if (this.prefetchSize > 0) {
            this.serverConsumer.promptDelivery();
        }
    }

    public boolean updateDeliveryCountAfterCancel(MessageReference ref) {
        long seqId = ref.getMessage().getMessageID();
        long lastDelSeqId = this.info.getLastDeliveredSequenceId();
        if (this.info.isDurable() && this.getOpenwireDestination().isTopic()) {
            return true;
        }
        ref.decrementDeliveryCount();
        if (lastDelSeqId == -2L) {
            ref.incrementDeliveryCount();
        }
        return true;
    }

    private class MessagePullHandler {
        private long next = -1L;
        private long timeout;
        private CountDownLatch latch = new CountDownLatch(1);
        private ScheduledFuture<?> messagePullFuture;

        private MessagePullHandler() {
        }

        public void nextSequence(long next, long timeout) throws Exception {
            this.next = next;
            this.timeout = timeout;
            this.latch = new CountDownLatch(1);
            AMQConsumer.this.serverConsumer.forceDelivery(AMQConsumer.this.messagePullSequence);
            if (timeout <= 0L) {
                this.latch.await(10L, TimeUnit.SECONDS);
                if (this.next >= 0L) {
                    AMQConsumer.this.handleDeliverNullDispatch();
                }
            }
        }

        public boolean checkForcedConsumer(ServerMessage message) {
            if (message.containsProperty(ClientConsumerImpl.FORCED_DELIVERY_MESSAGE)) {
                if (this.next >= 0L) {
                    if (this.timeout <= 0L) {
                        this.latch.countDown();
                    } else {
                        this.messagePullFuture = AMQConsumer.this.scheduledPool.schedule(new Runnable(){

                            @Override
                            public void run() {
                                if (MessagePullHandler.this.next >= 0L) {
                                    AMQConsumer.this.handleDeliverNullDispatch();
                                }
                            }
                        }, this.timeout, TimeUnit.MILLISECONDS);
                    }
                }
                return false;
            }
            this.next = -1L;
            if (this.messagePullFuture != null) {
                this.messagePullFuture.cancel(true);
            }
            this.latch.countDown();
            return true;
        }
    }
}

