/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.rest.integration;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.activemq.artemis.jms.server.embedded.EmbeddedJMS;
import org.apache.activemq.artemis.rest.integration.ServletContextBindingRegistry;
import org.apache.activemq.artemis.spi.core.naming.BindingRegistry;

public class ActiveMQBootstrapListener
implements ServletContextListener {
    private EmbeddedJMS jms;

    public void contextInitialized(ServletContextEvent contextEvent) {
        ServletContext context = contextEvent.getServletContext();
        this.jms = new EmbeddedJMS();
        this.jms.setRegistry((BindingRegistry)new ServletContextBindingRegistry(context));
        try {
            this.jms.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        try {
            if (this.jms != null) {
                this.jms.stop();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

