/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.rest.queue;

import java.net.URI;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.rest.ActiveMQRestLogger;
import org.apache.activemq.artemis.rest.queue.DestinationServiceManager;
import org.apache.activemq.artemis.rest.util.HttpMessageHelper;
import org.apache.activemq.artemis.utils.UUID;
import org.apache.activemq.artemis.utils.UUIDGenerator;

public class PostMessage {
    protected ClientSessionFactory sessionFactory;
    protected String destination;
    protected boolean defaultDurable = false;
    protected DestinationServiceManager serviceManager;
    private AtomicLong counter = new AtomicLong(1L);
    private final String startupTime = Long.toString(System.currentTimeMillis());
    protected long producerTimeToLive;
    protected ArrayBlockingQueue<Pooled> pool;
    protected int poolSize = 10;

    protected String generateDupId() {
        return this.startupTime + Long.toString(this.counter.incrementAndGet());
    }

    public void publish(HttpHeaders headers, byte[] body, String dup, boolean durable, Long ttl, Long expiration, Integer priority) throws Exception {
        Pooled pooled = this.getPooled();
        try {
            ClientProducer producer = pooled.producer;
            ClientMessage message = this.createActiveMQMessage(headers, body, durable, ttl, expiration, priority, pooled.session);
            message.putStringProperty(Message.HDR_DUPLICATE_DETECTION_ID.toString(), dup);
            producer.send((Message)message);
            ActiveMQRestLogger.LOGGER.debug("Sent message: " + message);
            this.pool.add(pooled);
        }
        catch (Exception ex) {
            try {
                pooled.session.close();
            }
            catch (ActiveMQException activeMQException) {
                // empty catch block
            }
            this.addPooled();
            throw ex;
        }
    }

    @PUT
    @Path(value="{id}")
    public Response putWithId(@PathParam(value="id") String dupId, @QueryParam(value="durable") Boolean durable, @QueryParam(value="ttl") Long ttl, @QueryParam(value="expiration") Long expiration, @QueryParam(value="priority") Integer priority, @Context HttpHeaders headers, @Context UriInfo uriInfo, byte[] body) {
        ActiveMQRestLogger.LOGGER.debug("Handling PUT request for \"" + uriInfo.getRequestUri() + "\"");
        return this.internalPostWithId(dupId, durable, ttl, expiration, priority, headers, uriInfo, body);
    }

    @POST
    @Path(value="{id}")
    public Response postWithId(@PathParam(value="id") String dupId, @QueryParam(value="durable") Boolean durable, @QueryParam(value="ttl") Long ttl, @QueryParam(value="expiration") Long expiration, @QueryParam(value="priority") Integer priority, @Context HttpHeaders headers, @Context UriInfo uriInfo, byte[] body) {
        ActiveMQRestLogger.LOGGER.debug("Handling POST request for \"" + uriInfo.getRequestUri() + "\"");
        return this.internalPostWithId(dupId, durable, ttl, expiration, priority, headers, uriInfo, body);
    }

    private Response internalPostWithId(String dupId, Boolean durable, Long ttl, Long expiration, Integer priority, HttpHeaders headers, UriInfo uriInfo, byte[] body) {
        String matched = (String)uriInfo.getMatchedURIs().get(1);
        UriBuilder nextBuilder = uriInfo.getBaseUriBuilder();
        String nextId = this.generateDupId();
        nextBuilder.path(matched).path(nextId);
        URI next = nextBuilder.build(new Object[0]);
        boolean isDurable = this.defaultDurable;
        if (durable != null) {
            isDurable = durable;
        }
        try {
            this.publish(headers, body, dupId, isDurable, ttl, expiration, priority);
        }
        catch (Exception e) {
            Response error = Response.serverError().entity((Object)("Problem posting message: " + e.getMessage())).type("text/plain").build();
            throw new WebApplicationException((Throwable)e, error);
        }
        Response.ResponseBuilder builder = Response.status((int)201);
        this.serviceManager.getLinkStrategy().setLinkHeader(builder, "create-next", "create-next", next.toString(), "*/*");
        return builder.build();
    }

    public long getProducerTimeToLive() {
        return this.producerTimeToLive;
    }

    public void setProducerTimeToLive(long producerTimeToLive) {
        this.producerTimeToLive = producerTimeToLive;
    }

    public DestinationServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public void setServiceManager(DestinationServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    public ClientSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(ClientSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public boolean isDefaultDurable() {
        return this.defaultDurable;
    }

    public void setDefaultDurable(boolean defaultDurable) {
        this.defaultDurable = defaultDurable;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public void init() throws Exception {
        this.pool = new ArrayBlockingQueue(this.poolSize);
        for (int i = 0; i < this.poolSize; ++i) {
            this.addPooled();
        }
    }

    protected void addPooled() throws ActiveMQException {
        ClientSession session = this.sessionFactory.createSession();
        ClientProducer producer = session.createProducer(this.destination);
        session.start();
        this.pool.add(new Pooled(session, producer));
    }

    protected Pooled getPooled() throws InterruptedException {
        Pooled pooled = this.pool.poll(1L, TimeUnit.SECONDS);
        if (pooled == null) {
            throw new WebApplicationException(Response.status((int)503).entity((Object)"Timed out waiting for available producer.").type("text/plain").build());
        }
        return pooled;
    }

    public void cleanup() {
        for (Pooled pooled : this.pool) {
            try {
                pooled.session.close();
            }
            catch (ActiveMQException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected ClientMessage createActiveMQMessage(HttpHeaders headers, byte[] body, boolean durable, Long ttl, Long expiration, Integer priority, ClientSession session) throws Exception {
        byte p;
        ClientMessage message = session.createMessage((byte)4, durable);
        UUID uid = UUIDGenerator.getInstance().generateUUID();
        message.setUserID(uid);
        if (expiration != null) {
            message.setExpiration(expiration.longValue());
        } else if (ttl != null) {
            message.setExpiration(System.currentTimeMillis() + ttl);
        } else if (this.producerTimeToLive > 0L) {
            message.setExpiration(System.currentTimeMillis() + this.producerTimeToLive);
        }
        if (priority != null && (p = priority.byteValue()) >= 0 && p <= 9) {
            message.setPriority(p);
        }
        HttpMessageHelper.writeHttpMessage(headers, body, message);
        return message;
    }

    protected static class Pooled {
        public ClientSession session;
        public ClientProducer producer;

        private Pooled(ClientSession session, ClientProducer producer) {
            this.session = session;
            this.producer = producer;
        }
    }
}

