/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.rest.queue.push;

import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.rest.ActiveMQRestLogger;
import org.apache.activemq.artemis.rest.queue.push.PushConsumer;

public class PushConsumerMessageHandler
implements MessageHandler {
    private ClientSession session;
    private PushConsumer pushConsumer;

    PushConsumerMessageHandler(PushConsumer pushConsumer, ClientSession session) {
        this.pushConsumer = pushConsumer;
        this.session = session;
    }

    public void onMessage(ClientMessage clientMessage) {
        ActiveMQRestLogger.LOGGER.debug(this + ": receiving " + clientMessage);
        try {
            clientMessage.acknowledge();
            ActiveMQRestLogger.LOGGER.debug(this + ": acknowledged " + clientMessage);
        }
        catch (ActiveMQException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        ActiveMQRestLogger.LOGGER.debug(this + ": pushing " + clientMessage + " via " + this.pushConsumer.getStrategy());
        boolean acknowledge = this.pushConsumer.getStrategy().push(clientMessage);
        if (acknowledge) {
            try {
                ActiveMQRestLogger.LOGGER.debug("Acknowledging: " + clientMessage.getMessageID());
                this.session.commit();
                return;
            }
            catch (ActiveMQException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            this.session.rollback();
        }
        catch (ActiveMQException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (this.pushConsumer.getRegistration().isDisableOnFailure()) {
            ActiveMQRestLogger.LOGGER.errorPushingMessage(this.pushConsumer.getRegistration().getTarget());
            this.pushConsumer.disableFromFailure();
            return;
        }
    }
}

