/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2;

import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Queue;
import org.eclipse.jetty.http2.FlowControlStrategy;
import org.eclipse.jetty.http2.HTTP2Session;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.frames.Frame;
import org.eclipse.jetty.http2.frames.WindowUpdateFrame;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HTTP2Flusher
extends IteratingCallback {
    private static final Logger LOG = Log.getLogger(HTTP2Flusher.class);
    private final Queue<WindowEntry> windows = new ArrayDeque<WindowEntry>();
    private final Deque<Entry> frames = new ArrayDeque<Entry>();
    private final Queue<Entry> entries = new ArrayDeque<Entry>();
    private final List<Entry> actives = new ArrayList<Entry>();
    private final HTTP2Session session;
    private final ByteBufferPool.Lease lease;
    private Entry stalled;
    private boolean terminated;

    public HTTP2Flusher(HTTP2Session session) {
        this.session = session;
        this.lease = new ByteBufferPool.Lease(session.getGenerator().getByteBufferPool());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void window(IStream stream, WindowUpdateFrame frame) {
        boolean closed;
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            closed = this.terminated;
            if (!closed) {
                this.windows.offer(new WindowEntry(stream, frame));
            }
        }
        if (!closed) {
            this.iterate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean prepend(Entry entry) {
        boolean closed;
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            closed = this.terminated;
            if (!closed) {
                this.frames.offerFirst(entry);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Prepended {}, frames={}", entry, this.frames.size());
                }
            }
        }
        if (closed) {
            this.closed(entry, new ClosedChannelException());
        }
        return !closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean append(Entry entry) {
        boolean closed;
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            closed = this.terminated;
            if (!closed) {
                this.frames.offer(entry);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Appended {}, frames={}", entry, this.frames.size());
                }
            }
        }
        if (closed) {
            this.closed(entry, new ClosedChannelException());
        }
        return !closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getQueueSize() {
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            return this.frames.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IteratingCallback.Action process() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Flushing {}", this.session);
        }
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            if (this.terminated) {
                throw new ClosedChannelException();
            }
            while (!this.windows.isEmpty()) {
                WindowEntry entry = this.windows.poll();
                entry.perform();
            }
            if (!this.frames.isEmpty()) {
                for (Entry entry : this.frames) {
                    this.entries.offer(entry);
                    this.actives.add(entry);
                }
                this.frames.clear();
            }
        }
        if (this.entries.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Flushed {}", this.session);
            }
            return IteratingCallback.Action.IDLE;
        }
        while (!this.entries.isEmpty()) {
            Entry entry = this.entries.poll();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing {}", entry);
            }
            if (entry.reset()) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Resetting {}", entry);
                continue;
            }
            try {
                if (entry.generate(this.lease)) {
                    if (entry.dataRemaining() <= 0) continue;
                    this.entries.offer(entry);
                    continue;
                }
                if (this.stalled != null) continue;
                this.stalled = entry;
            }
            catch (Throwable failure) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Failure generating frame " + entry.frame, failure);
                }
                this.failed(failure);
                return IteratingCallback.Action.SUCCEEDED;
            }
        }
        List<ByteBuffer> byteBuffers = this.lease.getByteBuffers();
        if (byteBuffers.isEmpty()) {
            this.complete();
            return IteratingCallback.Action.IDLE;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Writing {} buffers ({} bytes) for {} frames {}", byteBuffers.size(), this.lease.getTotalLength(), this.actives.size(), this.actives);
        }
        this.session.getEndPoint().write(this, byteBuffers.toArray(new ByteBuffer[byteBuffers.size()]));
        return IteratingCallback.Action.SCHEDULED;
    }

    @Override
    public void succeeded() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Written {} frames for {}", this.actives.size(), this.actives);
        }
        this.complete();
        super.succeeded();
    }

    private void complete() {
        this.lease.recycle();
        this.actives.forEach(rec$ -> ((Entry)rec$).complete());
        if (this.stalled != null) {
            Entry entry;
            int index;
            int i;
            for (i = index = this.actives.indexOf(this.stalled); i < this.actives.size(); ++i) {
                entry = this.actives.get(i);
                if (entry.dataRemaining() <= 0) continue;
                this.append(entry);
            }
            for (i = 0; i < index; ++i) {
                entry = this.actives.get(i);
                if (entry.dataRemaining() <= 0) continue;
                this.append(entry);
            }
            this.stalled = null;
        }
        this.actives.clear();
    }

    @Override
    protected void onCompleteSuccess() {
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onCompleteFailure(Throwable x) {
        boolean closed;
        this.lease.recycle();
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            closed = this.terminated;
            this.terminated = true;
            if (LOG.isDebugEnabled()) {
                LOG.debug("{}, active/queued={}/{}", closed ? "Closing" : "Failing", this.actives.size(), this.frames.size());
            }
            this.actives.addAll(this.frames);
            this.frames.clear();
        }
        this.actives.forEach(entry -> entry.failed(x));
        this.actives.clear();
        if (!closed) {
            this.session.abort(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminate() {
        boolean closed;
        HTTP2Flusher hTTP2Flusher = this;
        synchronized (hTTP2Flusher) {
            closed = this.terminated;
            this.terminated = true;
            if (LOG.isDebugEnabled()) {
                LOG.debug("{}", closed ? "Terminated" : "Terminating");
            }
        }
        if (!closed) {
            this.iterate();
        }
    }

    private void closed(Entry entry, Throwable failure) {
        entry.failed(failure);
    }

    private class WindowEntry {
        private final IStream stream;
        private final WindowUpdateFrame frame;

        public WindowEntry(IStream stream, WindowUpdateFrame frame) {
            this.stream = stream;
            this.frame = frame;
        }

        public void perform() {
            FlowControlStrategy flowControl = HTTP2Flusher.this.session.getFlowControlStrategy();
            flowControl.onWindowUpdate(HTTP2Flusher.this.session, this.stream, this.frame);
        }
    }

    public static abstract class Entry
    extends Callback.Nested {
        protected final Frame frame;
        protected final IStream stream;
        private boolean reset;

        protected Entry(Frame frame, IStream stream, Callback callback) {
            super(callback);
            this.frame = frame;
            this.stream = stream;
        }

        public int dataRemaining() {
            return 0;
        }

        protected abstract boolean generate(ByteBufferPool.Lease var1);

        private void complete() {
            if (this.reset) {
                this.failed(new EofException("reset"));
            } else {
                this.succeeded();
            }
        }

        @Override
        public void failed(Throwable x) {
            if (this.stream != null) {
                this.stream.close();
                this.stream.getSession().removeStream(this.stream);
            }
            super.failed(x);
        }

        private boolean reset() {
            this.reset = this.stream != null && this.stream.isReset() && !this.isProtocol();
            return this.reset;
        }

        private boolean isProtocol() {
            switch (this.frame.getType()) {
                case PRIORITY: 
                case RST_STREAM: 
                case GO_AWAY: 
                case WINDOW_UPDATE: 
                case DISCONNECT: {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return this.frame.toString();
        }
    }
}

