/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;

public class MappedByteBufferPool
implements ByteBufferPool {
    private final ConcurrentMap<Integer, ByteBufferPool.Bucket> directBuffers = new ConcurrentHashMap<Integer, ByteBufferPool.Bucket>();
    private final ConcurrentMap<Integer, ByteBufferPool.Bucket> heapBuffers = new ConcurrentHashMap<Integer, ByteBufferPool.Bucket>();
    private final int _factor;
    private final int _maxQueue;

    public MappedByteBufferPool() {
        this(-1);
    }

    public MappedByteBufferPool(int factor) {
        this(factor, -1);
    }

    public MappedByteBufferPool(int factor, int maxQueue) {
        this._factor = factor <= 0 ? 1024 : factor;
        this._maxQueue = maxQueue;
    }

    @Override
    public ByteBuffer acquire(int size, boolean direct) {
        int b = this.bucketFor(size);
        ConcurrentMap<Integer, ByteBufferPool.Bucket> buffers = this.bucketsFor(direct);
        ByteBufferPool.Bucket bucket = (ByteBufferPool.Bucket)buffers.get(b);
        if (bucket == null) {
            return this.newByteBuffer(b * this._factor, direct);
        }
        return bucket.acquire(direct);
    }

    protected ByteBuffer newByteBuffer(int capacity, boolean direct) {
        return direct ? BufferUtil.allocateDirect(capacity) : BufferUtil.allocate(capacity);
    }

    @Override
    public void release(ByteBuffer buffer) {
        if (buffer == null) {
            return;
        }
        assert (buffer.capacity() % this._factor == 0);
        int b = this.bucketFor(buffer.capacity());
        ConcurrentMap<Integer, ByteBufferPool.Bucket> buckets = this.bucketsFor(buffer.isDirect());
        ByteBufferPool.Bucket bucket = buckets.computeIfAbsent(b, bi -> new ByteBufferPool.Bucket(b * this._factor, this._maxQueue));
        bucket.release(buffer);
    }

    public void clear() {
        this.directBuffers.clear();
        this.heapBuffers.clear();
    }

    private int bucketFor(int size) {
        int bucket = size / this._factor;
        if (size % this._factor > 0) {
            ++bucket;
        }
        return bucket;
    }

    ConcurrentMap<Integer, ByteBufferPool.Bucket> bucketsFor(boolean direct) {
        return direct ? this.directBuffers : this.heapBuffers;
    }

    public static class Tagged
    extends MappedByteBufferPool {
        private final AtomicInteger tag = new AtomicInteger();

        @Override
        protected ByteBuffer newByteBuffer(int capacity, boolean direct) {
            ByteBuffer buffer = super.newByteBuffer(capacity + 4, direct);
            buffer.limit(buffer.capacity());
            buffer.putInt(this.tag.incrementAndGet());
            ByteBuffer slice = buffer.slice();
            BufferUtil.clear(slice);
            return slice;
        }
    }
}

