/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quickstart;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;

public class AttributeNormalizer {
    private static final Logger LOG = Log.getLogger(AttributeNormalizer.class);
    private static final Pattern __propertyPattern = Pattern.compile("(?<=[^$]|^)\\$\\{([^}]*)\\}");
    private URI warURI;
    private List<PathAttribute> attributes = new ArrayList<PathAttribute>();

    public static String uriSeparators(String path) {
        StringBuilder ret = new StringBuilder();
        for (char c : path.toCharArray()) {
            if (c == '/' || c == '\\') {
                ret.append('/');
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    public AttributeNormalizer(Resource baseResource) {
        URI uRI = this.warURI = baseResource == null ? null : baseResource.getURI();
        if (!this.warURI.isAbsolute()) {
            throw new IllegalArgumentException("WAR URI is not absolute: " + this.warURI);
        }
        try {
            this.attributes.add(new PathAttribute("jetty.base", "jetty.base").weight(9));
            this.attributes.add(new PathAttribute("jetty.home", "jetty.home").weight(8));
            this.attributes.add(new PathAttribute("user.home", "user.home").weight(7));
            this.attributes.add(new PathAttribute("user.dir", "user.dir").weight(6));
            Collections.sort(this.attributes, new PathAttributeComparator());
            if (LOG.isDebugEnabled()) {
                int i = 0;
                for (PathAttribute attr : this.attributes) {
                    LOG.debug(" [{}] {}", i++, attr);
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String normalize(Object o) {
        try {
            URI uri = null;
            if (o instanceof URI) {
                uri = (URI)o;
            } else if (o instanceof URL) {
                uri = ((URL)o).toURI();
            } else if (o instanceof File) {
                uri = ((File)o).toURI();
            } else {
                String s = o.toString();
                uri = new URI(s);
                if (uri.getScheme() == null) {
                    return s;
                }
            }
            if ("jar".equalsIgnoreCase(uri.getScheme())) {
                String raw = uri.getRawSchemeSpecificPart();
                int bang = raw.indexOf("!/");
                String normal = this.normalize(raw.substring(0, bang));
                String suffix = raw.substring(bang);
                return "jar:" + normal + suffix;
            }
            if ("file".equalsIgnoreCase(uri.getScheme())) {
                return "file:" + this.normalizePath(new File(uri.getRawSchemeSpecificPart()).toPath());
            }
            if (uri.isAbsolute()) {
                return this.normalizeUri(uri);
            }
        }
        catch (Exception e) {
            LOG.warn(e);
        }
        return String.valueOf(o);
    }

    public String normalizeUri(URI uri) {
        String warStr;
        String uriStr = uri.toASCIIString();
        if (uriStr.startsWith(warStr = this.warURI.toASCIIString())) {
            return "${WAR}" + uriStr.substring(warStr.length());
        }
        return uriStr;
    }

    public String normalizePath(Path path) {
        for (PathAttribute attr : this.attributes) {
            if (attr.path == null) continue;
            try {
                if (!path.startsWith(attr.path) && !path.equals(attr.path) && !Files.isSameFile(path, attr.path)) continue;
                return AttributeNormalizer.uriSeparators(URIUtil.addPaths("${" + attr.key + "}", attr.path.relativize(path).toString()));
            }
            catch (IOException ignore) {
                LOG.ignore(ignore);
            }
        }
        return AttributeNormalizer.uriSeparators(path.toString());
    }

    public String expand(String str) {
        return this.expand(str, new Stack<String>());
    }

    public String expand(String str, Stack<String> seenStack) {
        if (str == null) {
            return str;
        }
        if (str.indexOf("${") < 0) {
            return str;
        }
        Matcher mat = __propertyPattern.matcher(str);
        StringBuilder expanded = new StringBuilder();
        int offset = 0;
        while (mat.find(offset)) {
            String property = mat.group(1);
            if (seenStack.contains(property)) {
                int idx;
                StringBuilder err = new StringBuilder();
                err.append("Property expansion loop detected: ");
                for (int i = idx = seenStack.lastIndexOf(property); i < seenStack.size(); ++i) {
                    err.append((String)seenStack.get(i));
                    err.append(" -> ");
                }
                err.append(property);
                throw new RuntimeException(err.toString());
            }
            seenStack.push(property);
            expanded.append(str.subSequence(offset, mat.start()));
            String value = this.getString(property);
            if (value == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Unable to expand: {}", property);
                }
                expanded.append(mat.group());
            } else {
                value = this.expand(value, seenStack);
                expanded.append(value);
            }
            offset = mat.end();
        }
        expanded.append(str.substring(offset));
        if (expanded.indexOf("$$") >= 0) {
            return expanded.toString().replaceAll("\\$\\$", "\\$");
        }
        return expanded.toString();
    }

    private String getString(String property) {
        if (property == null) {
            return null;
        }
        if ("WAR".equalsIgnoreCase(property)) {
            return this.warURI.toASCIIString();
        }
        for (PathAttribute attr : this.attributes) {
            if (!attr.key.equalsIgnoreCase(property)) continue;
            return AttributeNormalizer.uriSeparators(attr.path.toString());
        }
        return System.getProperty(property);
    }

    private static class PathAttributeComparator
    implements Comparator<PathAttribute> {
        private PathAttributeComparator() {
        }

        @Override
        public int compare(PathAttribute o1, PathAttribute o2) {
            if (o1.path == null && o2.path != null) {
                return -1;
            }
            if (o1.path != null && o2.path == null) {
                return 1;
            }
            if (o1.path == null && o2.path == null) {
                return 0;
            }
            int diff = o2.path.getNameCount() - o1.path.getNameCount();
            if (diff != 0) {
                return diff;
            }
            diff = o2.path.compareTo(o1.path);
            if (diff != 0) {
                return diff;
            }
            return o2.weight - o1.weight;
        }
    }

    private static class PathAttribute {
        public final Path path;
        public final String key;
        private int weight = -1;

        public PathAttribute(String key, Path path) throws IOException {
            this.key = key;
            this.path = PathAttribute.toCanonicalPath(path);
        }

        public PathAttribute(String key, String systemPropertyKey) throws IOException {
            this(key, PathAttribute.toCanonicalPath(System.getProperty(systemPropertyKey)));
        }

        private static Path toCanonicalPath(String path) throws IOException {
            if (path == null) {
                return null;
            }
            return PathAttribute.toCanonicalPath(FileSystems.getDefault().getPath(path, new String[0]));
        }

        private static Path toCanonicalPath(Path path) throws IOException {
            if (path == null) {
                return null;
            }
            if (Files.exists(path, new LinkOption[0])) {
                return path.toRealPath(new LinkOption[0]);
            }
            return path.toAbsolutePath();
        }

        public PathAttribute weight(int newweight) {
            this.weight = newweight;
            return this;
        }

        public String toString() {
            return String.format("PathAttribute[%s=>%s,%d]", this.key, this.path, this.weight);
        }
    }
}

