/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.util.tracker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.Version;
import org.osgi.util.tracker.BundleTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleTrackerFactory {
    private static ConcurrentHashMap<String, List<BundleTracker>> btMap = new ConcurrentHashMap();

    public static List<BundleTracker> getBundleTrackerList(String bundleScope) {
        return btMap.get(bundleScope);
    }

    public static List<BundleTracker> getBundleTrackerList(String symbolicName, Version version) {
        return btMap.get(symbolicName + "_" + version.toString());
    }

    public static Collection<List<BundleTracker>> getAllBundleTracker() {
        return btMap.values();
    }

    public static void registerBundleTracker(String bundleScope, BundleTracker bt) {
        List<BundleTracker> list = btMap.get(bundleScope);
        if (list == null) {
            list = new ArrayList<BundleTracker>();
        }
        list.add(bt);
        btMap.putIfAbsent(bundleScope, list);
    }

    public static void unregisterAndCloseBundleTracker(String bundleScope) {
        List<BundleTracker> list = btMap.get(bundleScope);
        if (list == null) {
            return;
        }
        for (BundleTracker bt : list) {
            bt.close();
        }
        btMap.remove(bundleScope);
    }
}

