/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.demos.archivepkg;

import java.io.InputStream;
import java.util.Map;
import org.artificer.atom.archive.ArtificerArchive;
import org.artificer.client.ArtificerAtomApiClient;
import org.artificer.client.query.QueryResultSet;
import org.artificer.common.ArtificerModelUtils;
import org.artificer.common.query.ArtifactSummary;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.WsdlDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XsdDocument;

public class ArchivePackageDemo {
    private static final String DEFAULT_ENDPOINT = "http://localhost:8080/artificer-server";
    private static final String DEFAULT_USER = "admin";
    private static final String DEFAULT_PASSWORD = "artificer1!";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        System.out.println("\n*** Running Artificer Archive Package Demo ***\n");
        String endpoint = System.getProperty("artificer.endpoint");
        String username = System.getProperty("artificer.auth.username");
        String password = System.getProperty("artificer.auth.password");
        if (endpoint == null || endpoint.trim().length() == 0) {
            endpoint = DEFAULT_ENDPOINT;
        }
        if (username == null || username.trim().length() == 0) {
            username = DEFAULT_USER;
        }
        if (password == null || password.trim().length() == 0) {
            password = DEFAULT_PASSWORD;
        }
        System.out.println("Artificer Endpoint: " + endpoint);
        System.out.println("Artificer User: " + username);
        ArtificerAtomApiClient client = new ArtificerAtomApiClient(endpoint, username, password, true);
        QueryResultSet rs = client.buildQuery("/s-ramp[@from-demo = ?]").parameter(ArchivePackageDemo.class.getSimpleName()).count(1).query();
        if (rs.size() > 0L) {
            System.out.println("It looks like you already ran this demo!");
            System.out.println("I'm going to quit, because I don't want to clutter up");
            System.out.println("your repository with duplicate stuff.");
            System.exit(1);
        }
        System.out.println("Creating the S-RAMP package...");
        ArtificerArchive archive = new ArtificerArchive();
        try {
            InputStream contentStream = ArchivePackageDemo.class.getResourceAsStream("wss-wssecurity-utility-1.0.xsd");
            XsdDocument metaData = new XsdDocument();
            metaData.setName("wss-wssecurity-utility-1.0.xsd");
            metaData.setDescription("WS-Security: utility.xsd");
            metaData.setVersion("1.0");
            ArtificerModelUtils.setCustomProperty((BaseArtifactType)metaData, (String)"from-demo", (String)ArchivePackageDemo.class.getSimpleName());
            System.out.print("\tAdding " + metaData.getName() + " to the archive...");
            archive.addEntry("ws-security/schemas/wss-wssecurity-utility-1.0.xsd", (BaseArtifactType)metaData, contentStream);
            contentStream.close();
            System.out.println("added.");
            contentStream = ArchivePackageDemo.class.getResourceAsStream("wss-wssecurity-secext-1.0.xsd");
            metaData = new XsdDocument();
            metaData.setName("wss-wssecurity-secext-1.0.xsd");
            metaData.setDescription("WS-Security: secext.xsd");
            metaData.setVersion("1.0");
            ArtificerModelUtils.setCustomProperty((BaseArtifactType)metaData, (String)"from-demo", (String)ArchivePackageDemo.class.getSimpleName());
            System.out.print("\tAdding " + metaData.getName() + " to the archive...");
            archive.addEntry("ws-security/schemas/wss-wssecurity-secext-1.0.xsd", (BaseArtifactType)metaData, contentStream);
            contentStream.close();
            System.out.println("added.");
            contentStream = ArchivePackageDemo.class.getResourceAsStream("wstx-wsba-1.1-schema-200701.xsd");
            metaData = new XsdDocument();
            metaData.setName("wstx-wsba-1.1-schema-200701.xsd");
            metaData.setDescription("WS-Transaction: ws-tx-schema.xsd");
            metaData.setVersion("1.1");
            ArtificerModelUtils.setCustomProperty((BaseArtifactType)metaData, (String)"from-demo", (String)ArchivePackageDemo.class.getSimpleName());
            System.out.print("\tAdding " + metaData.getName() + " to the archive...");
            archive.addEntry("ws-tx/schemas/wstx-wsba-1.1-schema-200701.xsd", (BaseArtifactType)metaData, contentStream);
            contentStream.close();
            System.out.println("added.");
            contentStream = ArchivePackageDemo.class.getResourceAsStream("wstx-wsba-1.1-wsdl-200702.wsdl");
            metaData = new WsdlDocument();
            metaData.setName("wstx-wsba-1.1-wsdl-200702.wsdl");
            metaData.setDescription("WS-Transaction: ws-tx-wsdl.wsdl");
            metaData.setVersion("1.1");
            ArtificerModelUtils.setCustomProperty((BaseArtifactType)metaData, (String)"from-demo", (String)ArchivePackageDemo.class.getSimpleName());
            System.out.print("\tAdding " + metaData.getName() + " to the archive...");
            archive.addEntry("ws-tx/wsdl/wstx-wsba-1.1-wsdl-200702.wsdl", (BaseArtifactType)metaData, contentStream);
            contentStream.close();
            System.out.println("added.");
            System.out.print("Uploading the S-RAMP package...");
            Map batchResponse = client.uploadBatch(archive);
            System.out.println("uploaded:");
            for (Map.Entry entry : batchResponse.entrySet()) {
                String path = (String)entry.getKey();
                Object resp = entry.getValue();
                if (!(resp instanceof BaseArtifactType)) continue;
                BaseArtifactType arty = (BaseArtifactType)resp;
                System.out.println("\t" + path + " (" + arty.getUuid() + ")");
            }
        }
        finally {
            ArtificerArchive.closeQuietly((ArtificerArchive)archive);
        }
        System.out.print("Querying the Artificer repository for Schemas...");
        QueryResultSet rset = client.query("/s-ramp/xsd/XsdDocument");
        System.out.println("success: " + rset.size() + " Schemas found:");
        for (ArtifactSummary summary : rset) {
            System.out.println("\t * " + summary.getName() + " (" + summary.getUuid() + ")");
        }
        System.out.println("\n*** Demo Completed Successfully ***\n\n");
        Thread.sleep(3000L);
    }
}

