/*
 * Decompiled with CFR 0.152.
 */
package org.artificer.demos.properties;

import org.artificer.client.ArtificerAtomApiClient;
import org.artificer.client.query.QueryResultSet;
import org.artificer.common.ArtifactType;
import org.artificer.common.ArtificerModelUtils;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;

public class PropertyDemo {
    private static final String DEFAULT_ENDPOINT = "http://localhost:8080/artificer-server";
    private static final String DEFAULT_USER = "admin";
    private static final String DEFAULT_PASSWORD = "artificer1!";

    public static void main(String[] args) throws Exception {
        long ones;
        System.out.println("\n*** Running Artificer Query Demo ***\n");
        String endpoint = System.getProperty("artificer.endpoint");
        String username = System.getProperty("artificer.auth.username");
        String password = System.getProperty("artificer.auth.password");
        if (endpoint == null || endpoint.trim().length() == 0) {
            endpoint = DEFAULT_ENDPOINT;
        }
        if (username == null || username.trim().length() == 0) {
            username = DEFAULT_USER;
        }
        if (password == null || password.trim().length() == 0) {
            password = DEFAULT_PASSWORD;
        }
        System.out.println("Artificer Endpoint: " + endpoint);
        System.out.println("Artificer User: " + username);
        ArtificerAtomApiClient client = new ArtificerAtomApiClient(endpoint, username, password, true);
        QueryResultSet rs = client.buildQuery("/s-ramp[@from-demo = ?]").parameter(PropertyDemo.class.getSimpleName()).count(1).query();
        if (rs.size() > 0L) {
            System.out.println("It looks like you already ran this demo!");
            System.out.println("I'm going to quit, because I don't want to clutter up");
            System.out.println("your repository with duplicate stuff.");
            System.exit(1);
        }
        ArtifactType type = ArtifactType.valueOf((String)"Document");
        System.out.print("Uploading two artifacts...");
        BaseArtifactType artifact1 = client.uploadArtifact(type, PropertyDemo.class.getResourceAsStream("property-demo-doc-1.txt"), "property-demo-doc-1.txt");
        BaseArtifactType artifact2 = client.uploadArtifact(type, PropertyDemo.class.getResourceAsStream("property-demo-doc-2.txt"), "property-demo-doc-2.txt");
        System.out.println("uploaded.");
        artifact1.setName("property-demo-document-1.txt");
        artifact2.setName("property-demo-document-2.txt");
        ArtificerModelUtils.setCustomProperty((BaseArtifactType)artifact1, (String)"property-demo", (String)"true");
        ArtificerModelUtils.setCustomProperty((BaseArtifactType)artifact1, (String)"artifact-num", (String)"one");
        ArtificerModelUtils.setCustomProperty((BaseArtifactType)artifact1, (String)"hello", (String)"world");
        ArtificerModelUtils.setCustomProperty((BaseArtifactType)artifact2, (String)"property-demo", (String)"true");
        ArtificerModelUtils.setCustomProperty((BaseArtifactType)artifact2, (String)"artifact-num", (String)"two");
        ArtificerModelUtils.setCustomProperty((BaseArtifactType)artifact2, (String)"foo", (String)"bar");
        ArtificerModelUtils.setCustomProperty((BaseArtifactType)artifact1, (String)"from-demo", (String)PropertyDemo.class.getSimpleName());
        ArtificerModelUtils.setCustomProperty((BaseArtifactType)artifact2, (String)"from-demo", (String)PropertyDemo.class.getSimpleName());
        System.out.print("Updating (meta-data for) both artifacts...");
        client.updateArtifactMetaData(artifact1);
        client.updateArtifactMetaData(artifact2);
        System.out.println("updated.");
        System.out.print("Re-fetching (meta-data for) both artifacts...");
        BaseArtifactType metaData1 = client.getArtifactMetaData(type, artifact1.getUuid());
        BaseArtifactType metaData2 = client.getArtifactMetaData(type, artifact2.getUuid());
        System.out.println("fetched.");
        if (metaData1.getProperty().size() < 3) {
            System.out.println("Properties not found on artifact 1!  Oh noes!");
            System.exit(1);
        } else {
            System.out.println("All properties accounted for (artifact 1)!");
        }
        if (metaData2.getProperty().size() < 3) {
            System.out.println("Properties not found on artifact 2!  Oh noes!");
            System.exit(1);
        } else {
            System.out.println("All properties accounted for (artifact 2)!");
        }
        String q = "/s-ramp/core/Document[@name = 'property-demo-document-1.txt']";
        QueryResultSet resultSet = client.query(q);
        if (resultSet.size() == 0L) {
            System.out.println("Failed to find property-demo-document-1.txt!");
            System.exit(1);
        }
        if ((resultSet = client.query(q = "/s-ramp/core/Document[@property-demo = 'true']")).size() == 0L) {
            System.out.println("Failed to find document(s) with @property-demo set to 'true'!");
            System.exit(1);
        } else {
            System.out.println("Search 1 succeeded.");
        }
        long total = resultSet.size();
        q = "/s-ramp/core/Document[@artifact-num = 'one']";
        resultSet = client.query(q);
        if (resultSet.size() == 0L) {
            System.out.println("Failed to find document(s) with @artifact-num set to 'one'!");
            System.exit(1);
        }
        if (total / 2L != (ones = resultSet.size())) {
            System.out.println("The wrong number of documents with @artifact-num set to 'one' found!");
            System.exit(1);
        } else {
            System.out.println("Search 2 succeeded.");
        }
        System.out.println("\n*** Demo Completed Successfully ***\n\n");
        Thread.sleep(3000L);
    }
}

