/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.organization;

import java.io.Serializable;
import javax.jcr.RepositoryException;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.CacheHandler;

public class JCRCacheHandler
extends CacheHandler {
    private static char DELIMITER = (char)58;
    private static final Log LOG = ExoLogger.getLogger((String)"exo-jcr-services.JCRCacheHandler");
    private final JCROrganizationServiceImpl jcrOrganizationServiceImpl;
    protected boolean enabled;

    public JCRCacheHandler(CacheService cservice, JCROrganizationServiceImpl jcrOrganizationServiceImpl, boolean enabled) {
        super(cservice);
        this.jcrOrganizationServiceImpl = jcrOrganizationServiceImpl;
        this.enabled = enabled;
    }

    protected Serializable createCacheKey(Serializable orgServiceKey) {
        if (orgServiceKey instanceof String) {
            try {
                return this.jcrOrganizationServiceImpl.getWorkingRepository().getConfiguration().getName() + DELIMITER + orgServiceKey;
            }
            catch (RepositoryException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
            catch (RepositoryConfigurationException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
        return orgServiceKey;
    }

    protected boolean matchKey(Serializable cacheKey) {
        if (cacheKey instanceof String) {
            try {
                String prefix = this.jcrOrganizationServiceImpl.getWorkingRepository().getConfiguration().getName() + DELIMITER;
                return ((String)((Object)cacheKey)).startsWith(prefix);
            }
            catch (RepositoryException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
            catch (RepositoryConfigurationException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }
        return false;
    }

    protected Serializable createOrgServiceKey(Serializable cacheKey) {
        int indexOfDelimiter;
        if (cacheKey instanceof String && (indexOfDelimiter = ((String)((Object)cacheKey)).indexOf(DELIMITER)) >= 0) {
            return ((String)((Object)cacheKey)).substring(indexOfDelimiter + 1);
        }
        return cacheKey;
    }

    public void put(Serializable key, Object value, CacheHandler.CacheType cacheType) {
        if (this.enabled) {
            super.put(key, value, cacheType);
        }
    }

    public Object get(Serializable key, CacheHandler.CacheType cacheType) {
        if (this.enabled) {
            return super.get(key, cacheType);
        }
        return null;
    }

    public void remove(Serializable key, CacheHandler.CacheType cacheType) {
        if (this.enabled) {
            super.remove(key, cacheType);
        }
    }

    public void move(Serializable oldKey, Serializable newKey, CacheHandler.CacheType cacheType) {
        if (this.enabled) {
            super.move(oldKey, newKey, cacheType);
        }
    }
}

