/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.organization;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl;
import org.exoplatform.services.jcr.ext.organization.UserHandlerImpl;
import org.exoplatform.services.jcr.ext.organization.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JCRUserListAccess
implements ListAccess<User> {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo-jcr-services.JCRUserListAccess");
    public static final int DEFAULT_PAGE_SIZE = 20;
    protected final JCROrganizationServiceImpl service;
    protected final UserHandlerImpl uHandler;
    protected final Utils utils;
    protected NodeIterator iterator;
    protected final boolean enabledOnly;

    public JCRUserListAccess(JCROrganizationServiceImpl service, boolean enabledOnly) throws RepositoryException {
        this.service = service;
        this.uHandler = (UserHandlerImpl)service.getUserHandler();
        this.utils = new Utils(service);
        this.enabledOnly = enabledOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User[] load(int index, int length) throws Exception, IllegalArgumentException {
        this.validateParameters(index, length);
        if (length == 0) {
            return new User[0];
        }
        Session session = this.service.getStorageSession();
        try {
            this.reuseIterator(session, index);
            User[] entities = new User[length];
            int processed = 0;
            while (this.iterator.hasNext() && processed != length) {
                Node n = this.iterator.nextNode();
                if (!this.accept(n)) continue;
                entities[processed++] = (User)this.readObject(n);
            }
            if (processed != length) {
                throw new IllegalArgumentException("Illegal index or length: sum of the index and the length cannot be greater than the list size");
            }
            User[] userArray = entities;
            return userArray;
        }
        finally {
            session.logout();
        }
    }

    private void validateParameters(int index, int length) throws IllegalArgumentException {
        if (index < 0) {
            throw new IllegalArgumentException("Illegal index: index must be a positive number");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Illegal length: length must be a positive number");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() throws Exception {
        Session session = this.service.getStorageSession();
        try {
            int n = this.getSize(session);
            return n;
        }
        finally {
            session.logout();
        }
    }

    protected void reuseIterator(Session session, int newPosition) throws RepositoryException {
        if (!this.canReuseIterator() || this.iterator == null || this.iterator.getPosition() != (long)newPosition) {
            this.iterator = this.createIterator(session);
            this.iterator.skip((long)newPosition);
        }
    }

    protected boolean canReuseIterator() {
        return true;
    }

    protected abstract Object readObject(Node var1) throws Exception;

    protected abstract NodeIterator createIterator(Session var1) throws RepositoryException;

    protected abstract int getSize(Session var1) throws Exception;

    protected boolean accept(Node node) {
        try {
            return !this.enabledOnly || node.canAddMixin("jos:disabled");
        }
        catch (RepositoryException e) {
            if (LOG.isDebugEnabled()) {
                String path = "unknown";
                try {
                    path = node.getPath();
                }
                catch (RepositoryException e1) {
                    LOG.debug((Object)("Could not get the node of the node: " + node), (Throwable)e1);
                }
                LOG.debug((Object)("Could not know if the mixin type jos:disabled has been added to the node " + path), (Throwable)e);
            }
            return true;
        }
    }
}

