/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.organization;

import java.io.Serializable;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.Session;
import javax.naming.InvalidNameException;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.organization.JCROrgServiceHandler;
import org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl;
import org.exoplatform.services.jcr.ext.organization.MembershipImpl;
import org.exoplatform.services.jcr.ext.organization.Utils;
import org.exoplatform.services.organization.CacheHandler;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipEventListener;
import org.exoplatform.services.organization.MembershipEventListenerHandler;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.impl.mock.SimpleMembershipListAccess;
import org.exoplatform.services.security.PermissionConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MembershipHandlerImpl
extends JCROrgServiceHandler
implements MembershipHandler,
MembershipEventListenerHandler {
    protected final List<MembershipEventListener> listeners = new ArrayList<MembershipEventListener>();

    MembershipHandlerImpl(JCROrganizationServiceImpl service) {
        super(service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createMembership(Membership m, boolean broadcast) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            this.createMembership(session, (MembershipImpl)m, broadcast);
        }
        finally {
            session.logout();
        }
    }

    private void createMembership(Session session, MembershipImpl membership, boolean broadcast) throws InvalidNameException, Exception {
        Node refTypeNode;
        Node refUserNode;
        Node typeNode;
        Node groupNode;
        Node userNode;
        try {
            userNode = this.utils.getUserNode(session, membership.getUserName());
        }
        catch (PathNotFoundException e) {
            throw new InvalidNameException("The user " + membership.getUserName() + " not exists");
        }
        try {
            groupNode = this.utils.getGroupNode(session, membership.getGroupId());
        }
        catch (PathNotFoundException e) {
            throw new InvalidNameException("The group " + membership.getGroupId() + " not exists");
        }
        try {
            typeNode = this.utils.getMembershipTypeNode(session, membership.getMembershipType());
        }
        catch (PathNotFoundException e) {
            throw new InvalidNameException("The membership type " + membership.getMembershipType() + " not exists");
        }
        Node membershipStorageNode = groupNode.getNode("jos:memberships");
        try {
            refUserNode = membershipStorageNode.addNode(membership.getUserName());
            refUserNode.setProperty("jos:user", userNode);
        }
        catch (ItemExistsException e) {
            refUserNode = membershipStorageNode.getNode(membership.getUserName());
        }
        try {
            refTypeNode = refUserNode.addNode(membership.getMembershipType());
            refTypeNode.setProperty("jos:membershipType", typeNode);
        }
        catch (ItemExistsException e) {
            return;
        }
        String id = this.utils.composeMembershipId(groupNode, refUserNode, refTypeNode);
        membership.setId(id);
        if (broadcast) {
            this.preSave(membership, true);
        }
        session.save();
        this.putInCache(membership);
        if (broadcast) {
            this.postSave(membership, true);
        }
    }

    public Membership createMembershipInstance() {
        return new MembershipImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Membership findMembership(String id) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            Membership membership = this.findMembership((Session)session, (String)id).membership;
            return membership;
        }
        finally {
            session.logout();
        }
    }

    private MembershipByUserGroupTypeWrapper findMembership(Session session, String id) throws Exception {
        Utils.IdComponents ids;
        try {
            ids = this.utils.splitId(id);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ItemNotFoundException("Can not find membership by id=" + id, (Throwable)e);
        }
        Node groupNode = session.getNodeByUUID(ids.groupNodeId);
        Node refUserNode = groupNode.getNode("jos:memberships").getNode(ids.userName);
        Node refTypeNode = refUserNode.getNode(ids.type);
        String groupId = this.utils.getGroupIds((Node)groupNode).groupId;
        MembershipImpl membership = new MembershipImpl();
        membership.setId(id);
        membership.setGroupId(groupId);
        membership.setMembershipType(ids.type);
        membership.setUserName(ids.userName);
        this.putInCache(membership);
        return new MembershipByUserGroupTypeWrapper(membership, refUserNode, refTypeNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Membership findMembershipByUserGroupAndType(String userName, String groupId, String type) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            Membership membership = this.findMembershipByUserGroupAndType(session, userName, groupId, type);
            return membership;
        }
        finally {
            session.logout();
        }
    }

    private Membership findMembershipByUserGroupAndType(Session session, String userName, String groupId, String type) throws Exception {
        MembershipImpl membership = this.getFromCache(userName, groupId, type);
        if (membership != null) {
            return membership;
        }
        try {
            Node groupNode = this.utils.getGroupNode(session, groupId);
            Node refUserNode = groupNode.getNode("jos:memberships").getNode(userName);
            Node refTypeNode = refUserNode.getNode(type);
            String id = this.utils.composeMembershipId(groupNode, refUserNode, refTypeNode);
            membership = new MembershipImpl();
            membership.setGroupId(groupId);
            membership.setUserName(userName);
            membership.setMembershipType(type);
            membership.setId(id);
            this.putInCache(membership);
            return membership;
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findMembershipsByGroup(Group group) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            Collection collection = this.findMembershipsByGroup(session, group);
            return collection;
        }
        finally {
            session.logout();
        }
    }

    private Collection findMembershipsByGroup(Session session, Group group) throws Exception {
        NodeIterator refUsers;
        Node groupNode;
        try {
            groupNode = this.utils.getGroupNode(session, group);
            refUsers = groupNode.getNode("jos:memberships").getNodes();
        }
        catch (PathNotFoundException e) {
            return new ArrayList();
        }
        ArrayList memberships = new ArrayList();
        while (refUsers.hasNext()) {
            Node refUserNode = refUsers.nextNode();
            memberships.addAll(this.findMembershipsByUserAndGroup(session, refUserNode, groupNode));
        }
        return memberships;
    }

    public ListAccess<Membership> findAllMembershipsByGroup(Group group) throws Exception {
        return new SimpleMembershipListAccess(this.findMembershipsByGroup(group));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findMembershipsByUser(String userName) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            Collection<Membership> collection = this.findMembershipsByUser((Session)session, (String)userName).memberships;
            return collection;
        }
        finally {
            session.logout();
        }
    }

    private MembershipsByUserWrapper findMembershipsByUser(Session session, String userName) throws Exception {
        Node userNode;
        try {
            userNode = this.utils.getUserNode(session, userName);
        }
        catch (PathNotFoundException e) {
            return new MembershipsByUserWrapper(new ArrayList(), new ArrayList());
        }
        ArrayList memberships = new ArrayList();
        ArrayList<Node> refUserNodes = new ArrayList<Node>();
        PropertyIterator refUserProps = userNode.getReferences();
        while (refUserProps.hasNext()) {
            Node refUserNode = refUserProps.nextProperty().getParent();
            Node groupNode = refUserNode.getParent().getParent();
            memberships.addAll(this.findMembershipsByUserAndGroup(session, refUserNode, groupNode));
            refUserNodes.add(refUserNode);
        }
        return new MembershipsByUserWrapper(memberships, refUserNodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findMembershipsByUserAndGroup(String userName, String groupId) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            Collection collection = this.findMembershipsByUserAndGroup(session, userName, groupId);
            return collection;
        }
        finally {
            session.logout();
        }
    }

    private Collection findMembershipsByUserAndGroup(Session session, String userName, String groupId) throws Exception {
        Node refUserNode;
        Node groupNode;
        try {
            groupNode = this.utils.getGroupNode(session, groupId);
            refUserNode = groupNode.getNode("jos:memberships").getNode(userName);
        }
        catch (PathNotFoundException e) {
            return new ArrayList();
        }
        return this.findMembershipsByUserAndGroup(session, refUserNode, groupNode);
    }

    private Collection findMembershipsByUserAndGroup(Session session, Node refUserNode, Node groupNode) throws Exception {
        ArrayList<MembershipImpl> memberships = new ArrayList<MembershipImpl>();
        NodeIterator refTypes = refUserNode.getNodes();
        while (refTypes.hasNext()) {
            Node refTypeNode = refTypes.nextNode();
            String id = this.utils.composeMembershipId(groupNode, refUserNode, refTypeNode);
            String groupId = this.utils.getGroupIds((Node)groupNode).groupId;
            MembershipImpl membership = new MembershipImpl();
            membership.setUserName(refUserNode.getName());
            membership.setMembershipType(refTypeNode.getName());
            membership.setGroupId(groupId);
            membership.setId(id);
            memberships.add(membership);
        }
        return memberships;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkMembership(User user, Group group, MembershipType m, boolean broadcast) throws Exception {
        if (user == null) {
            throw new InvalidNameException("Can not create membership record because user is null");
        }
        if (group == null) {
            throw new InvalidNameException("Can not create membership record because group is null");
        }
        if (m == null) {
            throw new InvalidNameException("Can not create membership record because membership type is null");
        }
        Session session = this.service.getStorageSession();
        try {
            MembershipImpl membership = new MembershipImpl();
            membership.setMembershipType(m.getName());
            membership.setGroupId(group.getId());
            membership.setUserName(user.getUserName());
            this.createMembership(session, membership, broadcast);
        }
        finally {
            session.logout();
        }
    }

    void migrateMemberships(Node oldUserNode) throws Exception {
        Session session = oldUserNode.getSession();
        NodeIterator iterator = ((ExtendedNode)oldUserNode).getNodesLazily();
        while (iterator.hasNext()) {
            Node oldMembershipNode = iterator.nextNode();
            if (!oldMembershipNode.isNodeType("jos:userMembership")) continue;
            String oldGroupUUID = this.utils.readString(oldMembershipNode, "jos:group");
            String oldMembershipTypeUUID = this.utils.readString(oldMembershipNode, "jos:membershipType");
            String userName = oldUserNode.getName();
            String groupId = this.utils.readString(session.getNodeByUUID(oldGroupUUID), "jos:groupId");
            String membershipTypeName = session.getNodeByUUID(oldMembershipTypeUUID).getName();
            User user = this.service.getUserHandler().findUserByName(userName);
            Group group = this.service.getGroupHandler().findGroupById(groupId);
            MembershipType mt = this.service.getMembershipTypeHandler().findMembershipType(membershipTypeName);
            Membership existingMembership = this.findMembershipByUserGroupAndType(userName, groupId, membershipTypeName);
            if (existingMembership != null) {
                this.removeMembership(existingMembership.getId(), false);
            }
            this.linkMembership(user, group, mt, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Membership removeMembership(String id, boolean broadcast) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            Membership membership = this.removeMembership(session, id, broadcast);
            return membership;
        }
        finally {
            session.logout();
        }
    }

    private Membership removeMembership(Session session, String id, boolean broadcast) throws Exception {
        MembershipByUserGroupTypeWrapper mWrapper;
        try {
            mWrapper = this.findMembership(session, id);
        }
        catch (ItemNotFoundException e) {
            return null;
        }
        catch (PathNotFoundException e) {
            return null;
        }
        if (broadcast) {
            this.preDelete(mWrapper.membership);
        }
        this.removeMembership(mWrapper.refUserNode, mWrapper.refTypeNode);
        session.save();
        this.removeFromCache(mWrapper.membership);
        if (broadcast) {
            this.postDelete(mWrapper.membership);
        }
        return mWrapper.membership;
    }

    void removeMembership(Node refUserNode, Node refTypeNode) throws Exception {
        refTypeNode.remove();
        if (refUserNode.hasNodes()) {
            refUserNode.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection removeMembershipByUser(String userName, boolean broadcast) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            Collection collection = this.removeMembershipByUser(session, userName, broadcast);
            return collection;
        }
        finally {
            session.logout();
        }
    }

    private Collection removeMembershipByUser(Session session, String userName, boolean broadcast) throws Exception {
        MembershipsByUserWrapper mWrapper = this.findMembershipsByUser(session, userName);
        if (broadcast) {
            for (Membership m : mWrapper.memberships) {
                this.preDelete(m);
            }
        }
        for (Node refUserNode : mWrapper.refUserNodes) {
            refUserNode.remove();
        }
        session.save();
        this.removeFromCache("u=" + userName);
        if (broadcast) {
            for (Membership m : mWrapper.memberships) {
                this.postDelete(m);
            }
        }
        return mWrapper.memberships;
    }

    private MembershipImpl getFromCache(String userName, String groupId, String type) {
        return (MembershipImpl)this.cache.get((Serializable)((Object)this.cache.getMembershipKey(userName, groupId, type)), CacheHandler.CacheType.MEMBERSHIP);
    }

    private void removeFromCache(Membership membership) {
        this.cache.remove((Serializable)((Object)this.cache.getMembershipKey(membership)), CacheHandler.CacheType.MEMBERSHIP);
    }

    private void removeFromCache(String key) {
        this.cache.remove((Serializable)((Object)key), CacheHandler.CacheType.MEMBERSHIP);
    }

    private void putInCache(MembershipImpl membership) {
        this.cache.put((Serializable)((Object)this.cache.getMembershipKey(membership)), membership, CacheHandler.CacheType.MEMBERSHIP);
    }

    private void preSave(Membership membership, boolean isNew) throws Exception {
        for (MembershipEventListener listener : this.listeners) {
            listener.preSave(membership, isNew);
        }
    }

    private void postSave(Membership membership, boolean isNew) throws Exception {
        for (MembershipEventListener listener : this.listeners) {
            listener.postSave(membership, isNew);
        }
    }

    private void preDelete(Membership membership) throws Exception {
        for (MembershipEventListener listener : this.listeners) {
            listener.preDelete(membership);
        }
    }

    private void postDelete(Membership membership) throws Exception {
        for (MembershipEventListener listener : this.listeners) {
            listener.postDelete(membership);
        }
    }

    public void removeMembershipEventListener(MembershipEventListener listener) {
        SecurityHelper.validateSecurityPermission((Permission)PermissionConstants.MANAGE_LISTENERS);
        this.listeners.remove(listener);
    }

    public void addMembershipEventListener(MembershipEventListener listener) {
        SecurityHelper.validateSecurityPermission((Permission)PermissionConstants.MANAGE_LISTENERS);
        this.listeners.add(listener);
    }

    public List<MembershipEventListener> getMembershipListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MembershipsByUserWrapper {
        final Collection<Membership> memberships;
        final Collection<Node> refUserNodes;

        private MembershipsByUserWrapper(Collection<Membership> memberships, Collection<Node> refUserNodes) {
            this.memberships = memberships;
            this.refUserNodes = refUserNodes;
        }
    }

    private class MembershipByUserGroupTypeWrapper {
        final Membership membership;
        final Node refUserNode;
        final Node refTypeNode;

        private MembershipByUserGroupTypeWrapper(Membership membership, Node refUserNode, Node refTypeNode) {
            this.membership = membership;
            this.refTypeNode = refTypeNode;
            this.refUserNode = refUserNode;
        }
    }

    public static class MembershipProperties {
        public static final String JOS_MEMBERSHIP_TYPE = "jos:membershipType";
        public static final String JOS_USER = "jos:user";
    }
}

