/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.organization;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl;
import org.exoplatform.services.jcr.ext.organization.JCRUserListAccess;

public class SimpleJCRUserListAccess
extends JCRUserListAccess {
    private final ExtendedNode usersStorageNode = this.getUsersStorageNode();

    public SimpleJCRUserListAccess(JCROrganizationServiceImpl service, boolean enabledOnly) throws RepositoryException {
        super(service, enabledOnly);
    }

    protected int getSize(Session session) throws Exception {
        long result = this.usersStorageNode.getNodesCount();
        if (this.enabledOnly) {
            StringBuilder statement = new StringBuilder("SELECT * FROM ");
            statement.append("jos:user-v2").append(" WHERE");
            statement.append(" jcr:path LIKE '").append(this.usersStorageNode.getPath()).append("/%'");
            statement.append(" AND NOT jcr:path LIKE '").append(this.usersStorageNode.getPath()).append("/%/%'");
            statement.append(" AND ").append("jos:disabled").append(" IS NOT NULL");
            result -= session.getWorkspace().getQueryManager().createQuery(statement.toString(), "sql").execute().getNodes().getSize();
        }
        return (int)result;
    }

    protected Object readObject(Node node) throws Exception {
        return this.uHandler.readUser(node);
    }

    protected NodeIterator createIterator(Session session) throws RepositoryException {
        return this.usersStorageNode.getNodesLazily(20);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExtendedNode getUsersStorageNode() throws RepositoryException {
        Session session = this.service.getStorageSession();
        try {
            ExtendedNode extendedNode = (ExtendedNode)this.utils.getUsersStorageNode(this.service.getStorageSession());
            return extendedNode;
        }
        finally {
            session.logout();
        }
    }
}

